/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.combine;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Rule;
import org.jboss.security.xacml.sunxacml.combine.RuleCombinerElement;
import org.jboss.security.xacml.sunxacml.combine.RuleCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Result;

public class PermitOverridesRuleAlg
extends RuleCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides";
    private static URI identifierURI = URI.create("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides");

    public PermitOverridesRuleAlg() {
        super(identifierURI);
    }

    protected PermitOverridesRuleAlg(URI identifier) {
        super(identifier);
    }

    @Override
    public Result combine(EvaluationCtx context, List parameters, List ruleElements) {
        boolean atLeastOneError = false;
        boolean potentialPermit = false;
        boolean atLeastOneDeny = false;
        Result firstIndeterminateResult = null;
        Iterator it = ruleElements.iterator();
        while (it.hasNext()) {
            Rule rule = ((RuleCombinerElement)it.next()).getRule();
            Result result = rule.evaluate(context);
            int value = result.getDecision();
            if (value == 0) {
                return result;
            }
            if (value == 2) {
                atLeastOneError = true;
                if (firstIndeterminateResult == null) {
                    firstIndeterminateResult = result;
                }
                if (rule.getEffect() != 0) continue;
                potentialPermit = true;
                continue;
            }
            if (value != 1) continue;
            atLeastOneDeny = true;
        }
        if (potentialPermit) {
            return firstIndeterminateResult;
        }
        if (atLeastOneDeny) {
            return new Result(1, context.getResourceId().encode());
        }
        if (atLeastOneError) {
            return firstIndeterminateResult;
        }
        return new Result(3, context.getResourceId().encode());
    }
}

