/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.w3c.dom.Node;

public class StringAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#string";
    private static URI identifierURI = URI.create("http://www.w3.org/2001/XMLSchema#string");
    private String value;

    public StringAttribute(String value) {
        super(identifierURI);
        this.value = value == null ? "" : value;
    }

    public static StringAttribute getInstance(Node root) {
        Node node = root.getFirstChild();
        if (node == null) {
            return new StringAttribute("");
        }
        short type = node.getNodeType();
        if (type == 3 || type == 4 || type == 8) {
            return StringAttribute.getInstance(node.getNodeValue());
        }
        return null;
    }

    public static StringAttribute getInstance(String value) {
        return new StringAttribute(value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StringAttribute)) {
            return false;
        }
        StringAttribute other = (StringAttribute)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "StringAttribute: \"" + this.value + "\"";
    }

    @Override
    public String encode() {
        return this.value;
    }
}

