/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import java.util.Arrays;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.picketbox.commons.cipher.Base64;
import org.w3c.dom.Node;

public class Base64BinaryAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#base64Binary";
    private static URI identifierURI = URI.create("http://www.w3.org/2001/XMLSchema#base64Binary");
    private byte[] value;
    private String strValue;

    public Base64BinaryAttribute(byte[] value) {
        super(identifierURI);
        this.value = (byte[])value.clone();
    }

    public static Base64BinaryAttribute getInstance(Node root) throws ParsingException {
        return Base64BinaryAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static Base64BinaryAttribute getInstance(String value) throws ParsingException {
        byte[] bytes = Base64.decode((String)value);
        return new Base64BinaryAttribute(bytes);
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Base64BinaryAttribute)) {
            return false;
        }
        Base64BinaryAttribute other = (Base64BinaryAttribute)o;
        return Arrays.equals(this.value, other.value);
    }

    public int hashCode() {
        int code = this.value[0];
        for (int i = 1; i < this.value.length; ++i) {
            code *= 31;
            code += this.value[i];
        }
        return code;
    }

    private String makeStringRep() {
        return Base64.encodeBytes((byte[])this.value);
    }

    public String toString() {
        if (this.strValue == null) {
            this.strValue = this.makeStringRep();
        }
        return "Base64BinaryAttribute: [\n" + this.strValue + "]\n";
    }

    @Override
    public String encode() {
        if (this.strValue == null) {
            this.strValue = this.makeStringRep();
        }
        return this.strValue;
    }
}

