/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.ProcessingException;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.Target;
import org.jboss.security.xacml.sunxacml.VersionConstraints;
import org.jboss.security.xacml.sunxacml.combine.CombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Result;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PolicyReference
extends AbstractPolicy {
    public static final int POLICY_REFERENCE = 0;
    public static final int POLICYSET_REFERENCE = 1;
    private URI reference;
    private int policyType;
    private VersionConstraints constraints;
    private PolicyFinder finder;
    private PolicyMetaData parentMetaData;
    private static final Logger logger = Logger.getLogger(PolicyReference.class.getName());

    public PolicyReference(URI reference, int policyType, PolicyFinder finder, PolicyMetaData parentMetaData) throws IllegalArgumentException {
        this(reference, policyType, new VersionConstraints(null, null, null), finder, parentMetaData);
    }

    public PolicyReference(URI reference, int policyType, VersionConstraints constraints, PolicyFinder finder, PolicyMetaData parentMetaData) throws IllegalArgumentException {
        if (policyType != 0 && policyType != 1) {
            throw new IllegalArgumentException("Input policyType is not avalid value");
        }
        this.reference = reference;
        this.policyType = policyType;
        this.constraints = constraints;
        this.finder = finder;
        this.parentMetaData = parentMetaData;
    }

    public static PolicyReference getInstance(Node root, PolicyFinder finder) throws ParsingException {
        return PolicyReference.getInstance(root, finder, new PolicyMetaData());
    }

    public static PolicyReference getInstance(Node root, PolicyFinder finder, PolicyMetaData metaData) throws ParsingException {
        int policyType;
        URI reference = null;
        String name = SunxacmlUtil.getNodeName(root);
        if (name.equals("PolicyIdReference")) {
            policyType = 0;
        } else if (name.equals("PolicySetIdReference")) {
            policyType = 1;
        } else {
            throw new ParsingException("Unknown reference type: " + name);
        }
        try {
            reference = new URI(root.getFirstChild().getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Invalid URI in Reference", e);
        }
        NamedNodeMap map = root.getAttributes();
        String versionConstraint = null;
        Node versionNode = map.getNamedItem("Version");
        if (versionNode != null) {
            versionConstraint = versionNode.getNodeValue();
        }
        String earlyConstraint = null;
        Node earlyNode = map.getNamedItem("EarliestVersion");
        if (earlyNode != null) {
            earlyConstraint = earlyNode.getNodeValue();
        }
        String lateConstraint = null;
        Node lateNode = map.getNamedItem("LatestVersion");
        if (lateNode != null) {
            lateConstraint = lateNode.getNodeValue();
        }
        VersionConstraints constraints = new VersionConstraints(versionConstraint, earlyConstraint, lateConstraint);
        return new PolicyReference(reference, policyType, constraints, finder, metaData);
    }

    public URI getReference() {
        return this.reference;
    }

    public VersionConstraints getConstraints() {
        return this.constraints;
    }

    public int getReferenceType() {
        return this.policyType;
    }

    @Override
    public URI getId() {
        return this.resolvePolicy().getId();
    }

    @Override
    public String getVersion() {
        return this.resolvePolicy().getVersion();
    }

    @Override
    public CombiningAlgorithm getCombiningAlg() {
        return this.resolvePolicy().getCombiningAlg();
    }

    @Override
    public String getDescription() {
        return this.resolvePolicy().getDescription();
    }

    @Override
    public Target getTarget() {
        return this.resolvePolicy().getTarget();
    }

    @Override
    public String getDefaultVersion() {
        return this.resolvePolicy().getDefaultVersion();
    }

    @Override
    public List getChildren() {
        return this.resolvePolicy().getChildren();
    }

    @Override
    public List getChildElements() {
        return this.resolvePolicy().getChildElements();
    }

    @Override
    public Set getObligations() {
        return this.resolvePolicy().getObligations();
    }

    @Override
    public PolicyMetaData getMetaData() {
        return this.resolvePolicy().getMetaData();
    }

    @Override
    public MatchResult match(EvaluationCtx context) {
        try {
            return this.getTarget().match(context);
        }
        catch (ProcessingException pe) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(code, "couldn't resolve policy ref");
            return new MatchResult(2, status);
        }
    }

    private AbstractPolicy resolvePolicy() {
        if (this.finder == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("PolicyReference with id " + this.reference.toString() + " was queried but was not configured with a PolicyFinder");
            }
            throw new ProcessingException("couldn't find the policy with a null finder");
        }
        PolicyFinderResult pfr = this.finder.findPolicy(this.reference, this.policyType, this.constraints, this.parentMetaData);
        if (pfr.notApplicable()) {
            throw new ProcessingException("couldn't resolve the policy");
        }
        if (pfr.indeterminate()) {
            throw new ProcessingException("error resolving the policy");
        }
        return pfr.getPolicy();
    }

    @Override
    public Result evaluate(EvaluationCtx context) {
        if (this.finder == null) {
            return new Result(3, context.getResourceId().encode());
        }
        PolicyFinderResult pfr = this.finder.findPolicy(this.reference, this.policyType, this.constraints, this.parentMetaData);
        if (pfr.notApplicable()) {
            return new Result(3, context.getResourceId().encode());
        }
        if (pfr.indeterminate()) {
            return new Result(2, pfr.getStatus(), context.getResourceId().encode());
        }
        return pfr.getPolicy().evaluate(context);
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String encoded = indenter.makeString();
        if (this.policyType == 0) {
            out.println(encoded + "<PolicyIdReference" + this.encodeConstraints() + ">" + this.reference.toString() + "</PolicyIdReference>");
        } else {
            out.println(encoded + "<PolicySetIdReference" + this.encodeConstraints() + ">" + this.reference.toString() + "</PolicySetIdReference>");
        }
    }

    private String encodeConstraints() {
        String l;
        String e;
        String str = "";
        VersionConstraints version = this.getConstraints();
        String v = version.getVersionConstraint();
        if (v != null) {
            str = str + " Version=\"" + v + "\"";
        }
        if ((e = version.getEarliestConstraint()) != null) {
            str = str + " EarliestVersion=\"" + e + "\"";
        }
        if ((l = version.getLatestConstraint()) != null) {
            str = str + " LatestVersion=\"" + l + "\"";
        }
        return str;
    }
}

