/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.Builder;

public class TransactionBuilder
extends ComponentBuilder<TransactionConfiguration>
implements ResourceServiceBuilder<TransactionConfiguration> {
    private final InjectedValue<TransactionManager> tm = new InjectedValue();
    private final InjectedValue<TransactionSynchronizationRegistry> tsr = new InjectedValue();
    private final TransactionConfigurationBuilder builder = new ConfigurationBuilder().transaction();
    private volatile TransactionMode mode;

    public TransactionBuilder(PathAddress cacheAddress) {
        super(CacheComponent.TRANSACTION, cacheAddress);
    }

    @Override
    public ServiceBuilder<TransactionConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        switch (this.mode) {
            case NONE: {
                break;
            }
            case BATCH: {
                this.tm.inject((Object)DummyTransactionManager.getInstance());
                break;
            }
            case NON_XA: {
                builder.addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, this.tsr);
            }
            default: {
                builder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, this.tm);
            }
        }
        return builder;
    }

    public Builder<TransactionConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.mode = (TransactionMode)ModelNodes.asEnum((ModelNode)TransactionResourceDefinition.Attribute.MODE.resolveModelAttribute((ExpressionResolver)context, model), TransactionMode.class);
        this.builder.lockingMode((LockingMode)ModelNodes.asEnum((ModelNode)TransactionResourceDefinition.Attribute.LOCKING.resolveModelAttribute((ExpressionResolver)context, model), LockingMode.class));
        this.builder.cacheStopTimeout(TransactionResourceDefinition.Attribute.STOP_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong());
        this.builder.transactionMode(this.mode == TransactionMode.NONE ? org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL : org.infinispan.transaction.TransactionMode.TRANSACTIONAL);
        this.builder.useSynchronization(this.mode == TransactionMode.NON_XA);
        this.builder.recovery().enabled(this.mode == TransactionMode.FULL_XA);
        this.builder.invocationBatching().disable();
        return this;
    }

    public TransactionConfiguration getValue() {
        TransactionManager tm = (TransactionManager)this.tm.getOptionalValue();
        this.builder.transactionManagerLookup((TransactionManagerLookup)(tm != null ? new TransactionManagerProvider(tm) : null));
        TransactionSynchronizationRegistry tsr = (TransactionSynchronizationRegistry)this.tsr.getOptionalValue();
        this.builder.transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)(tsr != null ? new TransactionSynchronizationRegistryProvider(tsr) : null));
        return this.builder.create();
    }
}

