/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.SiteConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.infinispan.AdvancedExternalizerAdapter;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class GlobalConfigurationBuilder
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<GlobalConfiguration>,
Value<GlobalConfiguration> {
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final ValueDependency<Module> module;
    private final ValueDependency<TransportConfiguration> transport;
    private final ValueDependency<SiteConfiguration> site;
    private final Map<ThreadPoolResourceDefinition, ValueDependency<ThreadPoolConfiguration>> pools = new EnumMap<ThreadPoolResourceDefinition, ValueDependency<ThreadPoolConfiguration>>(ThreadPoolResourceDefinition.class);
    private final Map<ScheduledThreadPoolResourceDefinition, ValueDependency<ThreadPoolConfiguration>> schedulers = new EnumMap<ScheduledThreadPoolResourceDefinition, ValueDependency<ThreadPoolConfiguration>>(ScheduledThreadPoolResourceDefinition.class);
    private final String name;
    private volatile ValueDependency<MBeanServer> server;
    private volatile boolean statisticsEnabled;

    GlobalConfigurationBuilder(PathAddress address) {
        super((Capability)CacheContainerResourceDefinition.Capability.CONFIGURATION, address);
        this.name = address.getLastElement().getValue();
        this.module = new InjectedValueDependency(CacheContainerComponent.MODULE.getServiceName(address), Module.class);
        this.transport = new InjectedValueDependency(CacheContainerComponent.TRANSPORT.getServiceName(address), TransportConfiguration.class);
        this.site = new InjectedValueDependency(CacheContainerComponent.SITE.getServiceName(address), SiteConfiguration.class);
        EnumSet.allOf(ThreadPoolResourceDefinition.class).forEach(pool -> this.pools.put((ThreadPoolResourceDefinition)pool, (ValueDependency<ThreadPoolConfiguration>)new InjectedValueDependency(pool.getServiceName(address), ThreadPoolConfiguration.class)));
        EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class).forEach(pool -> this.schedulers.put((ScheduledThreadPoolResourceDefinition)pool, (ValueDependency<ThreadPoolConfiguration>)new InjectedValueDependency(pool.getServiceName(address), ThreadPoolConfiguration.class)));
    }

    public Builder<GlobalConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.server = context.hasOptionalCapability(CommonRequirement.MBEAN_SERVER.getName(), null, null) ? new InjectedValueDependency(CommonRequirement.MBEAN_SERVER.getServiceName(context), MBeanServer.class) : null;
        this.statisticsEnabled = CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        return this;
    }

    public GlobalConfiguration getValue() {
        org.infinispan.configuration.global.GlobalConfigurationBuilder builder = new org.infinispan.configuration.global.GlobalConfigurationBuilder();
        TransportConfiguration transport = (TransportConfiguration)this.transport.getValue();
        builder.transport().transport(transport.transport()).distributedSyncTimeout(transport.distributedSyncTimeout()).clusterName(transport.clusterName()).machineId(transport.machineId()).rackId(transport.rackId()).siteId(transport.siteId());
        Module module = (Module)this.module.getValue();
        builder.serialization().classResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.loader.getValue())));
        builder.classLoader((ClassLoader)module.getClassLoader());
        int id = 255;
        for (Externalizer externalizer : module.loadService(Externalizer.class)) {
            InfinispanLogger.ROOT_LOGGER.debugf("Cache container %s will use an externalizer for %s", this.name, externalizer.getTargetClass().getName());
            builder.serialization().addAdvancedExternalizer(id++, (AdvancedExternalizer)new AdvancedExternalizerAdapter(externalizer));
        }
        builder.transport().transportThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.TRANSPORT).getValue());
        builder.transport().remoteCommandThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.REMOTE_COMMAND).getValue());
        builder.asyncThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.ASYNC_OPERATIONS).getValue());
        builder.expirationThreadPool().read((ThreadPoolConfiguration)this.schedulers.get(ScheduledThreadPoolResourceDefinition.EXPIRATION).getValue());
        builder.listenerThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.LISTENER).getValue());
        builder.stateTransferThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.STATE_TRANSFER).getValue());
        builder.persistenceThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.PERSISTENCE).getValue());
        builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        builder.globalJmxStatistics().enabled(this.statisticsEnabled).cacheManagerName(this.name).mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider(this.server != null ? (MBeanServer)this.server.getValue() : null)).jmxDomain("org.wildfly.clustering.infinispan").allowDuplicateDomains(Boolean.valueOf(true));
        builder.site().read((SiteConfiguration)this.site.getValue());
        return builder.build();
    }

    public ServiceBuilder<GlobalConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).setInitialMode(ServiceController.Mode.PASSIVE);
        this.pools.values().forEach(dependency -> dependency.register(builder));
        this.schedulers.values().forEach(dependency -> dependency.register(builder));
        Stream.of(this.module, this.transport, this.site, this.server).filter(Objects::nonNull).forEach(dependency -> dependency.register(builder));
        return builder;
    }
}

