/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class BackupsBuilder
extends ComponentBuilder<SitesConfiguration>
implements ResourceServiceBuilder<SitesConfiguration> {
    private final ValueDependency<BackupForConfiguration> backupFor;
    private final Map<String, BackupConfiguration> backups = new HashMap<String, BackupConfiguration>();

    BackupsBuilder(PathAddress cacheAddress) {
        super(CacheComponent.BACKUPS, cacheAddress);
        this.backupFor = new InjectedValueDependency(CacheComponent.BACKUP_FOR.getServiceName(cacheAddress), BackupForConfiguration.class);
    }

    @Override
    public ServiceBuilder<SitesConfiguration> build(ServiceTarget target) {
        return this.backupFor.register(super.build(target));
    }

    public Builder<SitesConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.backups.clear();
        if (model.hasDefined(BackupResourceDefinition.WILDCARD_PATH.getKey())) {
            SitesConfigurationBuilder builder = new ConfigurationBuilder().sites();
            for (Property property : model.get(BackupResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                String siteName = property.getName();
                ModelNode backup = property.getValue();
                BackupConfigurationBuilder backupBuilder = builder.addBackup();
                backupBuilder.site(siteName).enabled(BackupResourceDefinition.Attribute.ENABLED.resolveModelAttribute((ExpressionResolver)context, backup).asBoolean()).backupFailurePolicy((BackupFailurePolicy)ModelNodes.asEnum((ModelNode)BackupResourceDefinition.Attribute.FAILURE_POLICY.resolveModelAttribute((ExpressionResolver)context, backup), BackupFailurePolicy.class)).replicationTimeout(BackupResourceDefinition.Attribute.TIMEOUT.resolveModelAttribute((ExpressionResolver)context, backup).asLong()).strategy((BackupConfiguration.BackupStrategy)ModelNodes.asEnum((ModelNode)BackupResourceDefinition.Attribute.STRATEGY.resolveModelAttribute((ExpressionResolver)context, backup), BackupConfiguration.BackupStrategy.class)).takeOffline().afterFailures(BackupResourceDefinition.TakeOfflineAttribute.AFTER_FAILURES.resolveModelAttribute((ExpressionResolver)context, backup).asInt()).minTimeToWait(BackupResourceDefinition.TakeOfflineAttribute.MIN_WAIT.resolveModelAttribute((ExpressionResolver)context, backup).asLong());
                this.backups.put(siteName, backupBuilder.create());
            }
        }
        return this;
    }

    public SitesConfiguration getValue() {
        SitesConfigurationBuilder builder = new ConfigurationBuilder().sites();
        builder.backupFor().read((BackupForConfiguration)this.backupFor.getValue());
        builder.disableBackups(this.backups.isEmpty());
        for (Map.Entry<String, BackupConfiguration> backup : this.backups.entrySet()) {
            builder.addBackup().read(backup.getValue());
            builder.addInUseBackupSite(backup.getKey());
        }
        return builder.create();
    }
}

