/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.tool.Util;

public class ArchiveFileObject
implements JavaFileObject {
    private String entryName;
    private File file;
    private ZipFile zipFile;
    private Charset charset;

    public ArchiveFileObject(File file, String entryName, Charset charset) {
        this.entryName = entryName;
        this.file = file;
        this.charset = charset;
    }

    protected void finalize() throws Throwable {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    @Override
    public Modifier getAccessLevel() {
        if (this.getKind() != JavaFileObject.Kind.CLASS) {
            return null;
        }
        ClassFileReader reader = null;
        try (ZipFile zip2 = new ZipFile(this.file);){
            reader = ClassFileReader.read(zip2, this.entryName);
        }
        catch (ClassFormatException zip2) {
        }
        catch (IOException zip2) {
            // empty catch block
        }
        if (reader == null) {
            return null;
        }
        int accessFlags = reader.accessFlags();
        if ((accessFlags & 1) != 0) {
            return Modifier.PUBLIC;
        }
        if ((accessFlags & 0x400) != 0) {
            return Modifier.ABSTRACT;
        }
        if ((accessFlags & 0x10) != 0) {
            return Modifier.FINAL;
        }
        return null;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        String name = this.entryName.toLowerCase();
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (name.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (name.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public NestingKind getNestingKind() {
        switch (this.getKind()) {
            case SOURCE: {
                return NestingKind.TOP_LEVEL;
            }
            case CLASS: {
                ClassFileReader reader = null;
                try (ZipFile zip = new ZipFile(this.file);){
                    reader = ClassFileReader.read(zip, this.entryName);
                }
                catch (ClassFormatException classFormatException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (reader == null) {
                    return null;
                }
                if (reader.isAnonymous()) {
                    return NestingKind.ANONYMOUS;
                }
                if (reader.isLocal()) {
                    return NestingKind.LOCAL;
                }
                if (reader.isMember()) {
                    return NestingKind.MEMBER;
                }
                return NestingKind.TOP_LEVEL;
            }
        }
        return null;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return this.entryName.endsWith(simpleName + kind.extension);
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ArchiveFileObject)) {
            return false;
        }
        ArchiveFileObject archiveFileObject = (ArchiveFileObject)o;
        return archiveFileObject.toUri().equals(this.toUri());
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        if (this.getKind() == JavaFileObject.Kind.SOURCE) {
            try (ZipFile zipFile2 = new ZipFile(this.file);){
                ZipEntry zipEntry = zipFile2.getEntry(this.entryName);
                CharSequence charSequence = Util.getCharContents(this, ignoreEncodingErrors, org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(zipEntry, zipFile2), this.charset.name());
                return charSequence;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLastModified() {
        try (ZipFile zip = new ZipFile(this.file);){
            ZipEntry zipEntry = zip.getEntry(this.entryName);
            long l = zipEntry.getTime();
            return l;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
        ZipEntry zipEntry = this.zipFile.getEntry(this.entryName);
        return this.zipFile.getInputStream(zipEntry);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toUri() {
        try {
            return new URI("jar:" + this.file.toURI().getPath() + "!" + this.entryName);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String toString() {
        return this.file.getAbsolutePath() + "[" + this.entryName + "]";
    }
}

