/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] paramReferences;
    public JavadocSingleTypeReference[] paramTypeParameters;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public long[] inheritedPositions = null;
    public JavadocSingleNameReference[] invalidParameters;
    public long valuePositions = -1L;

    public Javadoc(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.bits |= 0x10000;
    }

    boolean canBeSeen(int visibility, int modifiers) {
        if (modifiers < 0) {
            return true;
        }
        switch (modifiers & 7) {
            case 1: {
                return true;
            }
            case 4: {
                return visibility != 1;
            }
            case 0: {
                return visibility == 0 || visibility == 2;
            }
            case 2: {
                return visibility == 2;
            }
        }
        return true;
    }

    public ASTNode getNodeStartingAt(int start) {
        int length = 0;
        if (this.paramReferences != null) {
            for (JavadocSingleNameReference javadocSingleNameReference : this.paramReferences) {
                if (javadocSingleNameReference.sourceStart != start) continue;
                return javadocSingleNameReference;
            }
        }
        if (this.invalidParameters != null) {
            for (JavadocSingleNameReference javadocSingleNameReference : this.invalidParameters) {
                if (javadocSingleNameReference.sourceStart != start) continue;
                return javadocSingleNameReference;
            }
        }
        if (this.paramTypeParameters != null) {
            for (JavadocSingleTypeReference javadocSingleTypeReference : this.paramTypeParameters) {
                if (javadocSingleTypeReference.sourceStart != start) continue;
                return javadocSingleTypeReference;
            }
        }
        if (this.exceptionReferences != null) {
            for (TypeReference typeReference : this.exceptionReferences) {
                if (typeReference.sourceStart != start) continue;
                return typeReference;
            }
        }
        if (this.seeReferences != null) {
            length = this.seeReferences.length;
            for (int i = 0; i < length; ++i) {
                int j;
                int l;
                Expression expression = this.seeReferences[i];
                if (expression.sourceStart == start) {
                    return expression;
                }
                if (expression instanceof JavadocAllocationExpression) {
                    JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i];
                    if (allocationExpr.binding == null || !allocationExpr.binding.isValidBinding() || allocationExpr.arguments == null) continue;
                    l = allocationExpr.arguments.length;
                    for (j = 0; j < l; ++j) {
                        if (allocationExpr.arguments[j].sourceStart != start) continue;
                        return allocationExpr.arguments[j];
                    }
                    continue;
                }
                if (!(expression instanceof JavadocMessageSend)) continue;
                JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i];
                if (messageSend.binding == null || !messageSend.binding.isValidBinding() || messageSend.arguments == null) continue;
                l = messageSend.arguments.length;
                for (j = 0; j < l; ++j) {
                    if (messageSend.arguments[j].sourceStart != start) continue;
                    return messageSend.arguments[j];
                }
            }
        }
        return null;
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        int i;
        int length;
        Javadoc.printIndent(indent, output).append("/**\n");
        if (this.paramReferences != null) {
            length = this.paramReferences.length;
            for (i = 0; i < length; ++i) {
                Javadoc.printIndent(indent + 1, output).append(" * @param ");
                this.paramReferences[i].print(indent, output).append('\n');
            }
        }
        if (this.paramTypeParameters != null) {
            length = this.paramTypeParameters.length;
            for (i = 0; i < length; ++i) {
                Javadoc.printIndent(indent + 1, output).append(" * @param <");
                this.paramTypeParameters[i].print(indent, output).append(">\n");
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @");
            this.returnStatement.print(indent, output).append('\n');
        }
        if (this.exceptionReferences != null) {
            length = this.exceptionReferences.length;
            for (i = 0; i < length; ++i) {
                Javadoc.printIndent(indent + 1, output).append(" * @throws ");
                this.exceptionReferences[i].print(indent, output).append('\n');
            }
        }
        if (this.seeReferences != null) {
            length = this.seeReferences.length;
            for (i = 0; i < length; ++i) {
                Javadoc.printIndent(indent + 1, output).append(" * @see ");
                this.seeReferences[i].print(indent, output).append('\n');
            }
        }
        Javadoc.printIndent(indent, output).append(" */\n");
        return output;
    }

    public void resolve(ClassScope scope) {
        boolean source15;
        int i;
        if ((this.bits & 0x10000) == 0) {
            return;
        }
        if (this.inheritedPositions != null) {
            int length = this.inheritedPositions.length;
            for (i = 0; i < length; ++i) {
                int start = (int)(this.inheritedPositions[i] >>> 32);
                int end = (int)this.inheritedPositions[i];
                scope.problemReporter().javadocUnexpectedTag(start, end);
            }
        }
        int paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
        for (i = 0; i < paramTagsSize; ++i) {
            JavadocSingleNameReference param = this.paramReferences[i];
            scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
        }
        this.resolveTypeParameterTags(scope, true);
        if (this.returnStatement != null) {
            scope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        int throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        for (int i2 = 0; i2 < throwsTagsLength; ++i2) {
            int end;
            int start;
            TypeReference typeRef = this.exceptionReferences[i2];
            if (typeRef instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                start = singleRef.tagSourceStart;
                end = singleRef.tagSourceEnd;
            } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)typeRef;
                start = qualifiedRef.tagSourceStart;
                end = qualifiedRef.tagSourceEnd;
            } else {
                start = typeRef.sourceStart;
                end = typeRef.sourceEnd;
            }
            scope.problemReporter().javadocUnexpectedTag(start, end);
        }
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        for (int i3 = 0; i3 < seeTagsLength; ++i3) {
            this.resolveReference(this.seeReferences[i3], scope);
        }
        boolean bl = source15 = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (!source15 && this.valuePositions != -1L) {
            scope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
    }

    public void resolve(CompilationUnitScope unitScope) {
        if ((this.bits & 0x10000) == 0) {
            return;
        }
    }

    public void resolve(MethodScope methScope) {
        boolean source15;
        boolean reportMissing;
        if ((this.bits & 0x10000) == 0) {
            return;
        }
        AbstractMethodDeclaration methDecl = methScope.referenceMethod();
        boolean overriding = methDecl == null || methDecl.binding == null ? false : !methDecl.binding.isStatic() && (methDecl.binding.modifiers & 0x30000000) != 0;
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean superRef = false;
        for (int i = 0; i < seeTagsLength; ++i) {
            MethodBinding superConstructor;
            ReferenceBinding allocType;
            TypeBinding superType;
            this.resolveReference(this.seeReferences[i], methScope);
            if (methDecl == null || superRef) continue;
            if (!methDecl.isConstructor()) {
                ReferenceBinding methodReceiverType;
                if (!overriding || !(this.seeReferences[i] instanceof JavadocMessageSend)) continue;
                JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i];
                if (messageSend.binding == null || !messageSend.binding.isValidBinding() || !(messageSend.actualReceiverType instanceof ReferenceBinding) || (superType = methDecl.binding.declaringClass.findSuperTypeOriginatingFrom(methodReceiverType = (ReferenceBinding)messageSend.actualReceiverType)) == null || !TypeBinding.notEquals(superType.original(), methDecl.binding.declaringClass) || !CharOperation.equals(messageSend.selector, methDecl.selector) || !methScope.environment().methodVerifier().doesMethodOverride(methDecl.binding, messageSend.binding.original())) continue;
                superRef = true;
                continue;
            }
            if (!(this.seeReferences[i] instanceof JavadocAllocationExpression)) continue;
            JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i];
            if (allocationExpr.binding == null || !allocationExpr.binding.isValidBinding() || (superType = (ReferenceBinding)methDecl.binding.declaringClass.findSuperTypeOriginatingFrom(allocType = (ReferenceBinding)allocationExpr.resolvedType.original())) == null || !TypeBinding.notEquals(superType.original(), methDecl.binding.declaringClass) || !(superConstructor = methScope.getConstructor((ReferenceBinding)superType, methDecl.binding.parameters, allocationExpr)).isValidBinding() || superConstructor.original() != allocationExpr.binding.original()) continue;
            MethodBinding current = methDecl.binding;
            if (methScope.compilerOptions().sourceLevel >= 0x340000L && current.typeVariables != Binding.NO_TYPE_VARIABLES) {
                current = current.asRawMethod(methScope.environment());
            }
            if (!superConstructor.areParametersEqual(current)) continue;
            superRef = true;
        }
        if (!superRef && methDecl != null && methDecl.annotations != null) {
            int length = methDecl.annotations.length;
            for (int i = 0; i < length && !superRef; ++i) {
                superRef = (methDecl.binding.tagBits & 0x2000000000000L) != 0L;
            }
        }
        boolean bl = reportMissing = methDecl == null || (!overriding || this.inheritedPositions == null) && !superRef && (methDecl.binding.declaringClass == null || !methDecl.binding.declaringClass.isLocalType());
        if (!overriding && this.inheritedPositions != null) {
            int length = this.inheritedPositions.length;
            for (int i = 0; i < length; ++i) {
                int start = (int)(this.inheritedPositions[i] >>> 32);
                int end = (int)this.inheritedPositions[i];
                methScope.problemReporter().javadocUnexpectedTag(start, end);
            }
        }
        CompilerOptions compilerOptions = methScope.compilerOptions();
        this.resolveParamTags(methScope, reportMissing, compilerOptions.reportUnusedParameterIncludeDocCommentReference);
        this.resolveTypeParameterTags(methScope, reportMissing && compilerOptions.reportMissingJavadocTagsMethodTypeParameters);
        if (this.returnStatement == null) {
            if (reportMissing && methDecl != null && methDecl.isMethod()) {
                MethodDeclaration meth = (MethodDeclaration)methDecl;
                if (meth.binding.returnType != TypeBinding.VOID) {
                    methScope.problemReporter().javadocMissingReturnTag(meth.returnType.sourceStart, meth.returnType.sourceEnd, methDecl.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methScope);
        }
        this.resolveThrowsTags(methScope, reportMissing);
        boolean bl2 = source15 = compilerOptions.sourceLevel >= 0x310000L;
        if (!source15 && methDecl != null && this.valuePositions != -1L) {
            methScope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
        int length = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        for (int i = 0; i < length; ++i) {
            this.invalidParameters[i].resolve(methScope, false, false);
        }
    }

    private void resolveReference(Expression reference, Scope scope) {
        int problemCount = scope.referenceContext().compilationResult().problemCount;
        switch (scope.kind) {
            case 2: {
                reference.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                reference.resolveType((ClassScope)scope);
            }
        }
        boolean hasProblems = scope.referenceContext().compilationResult().problemCount > problemCount;
        boolean source15 = scope.compilerOptions().sourceLevel >= 0x310000L;
        int scopeModifiers = -1;
        if (reference instanceof JavadocFieldReference) {
            ReferenceBinding resolvedType;
            JavadocFieldReference fieldRef = (JavadocFieldReference)reference;
            if (fieldRef.methodBinding != null) {
                if (fieldRef.tagValue == 10) {
                    if (scopeModifiers == -1) {
                        scopeModifiers = scope.getDeclarationModifiers();
                    }
                    scope.problemReporter().javadocInvalidValueReference(fieldRef.sourceStart, fieldRef.sourceEnd, scopeModifiers);
                } else if (fieldRef.actualReceiverType != null) {
                    if (scope.enclosingSourceType().isCompatibleWith(fieldRef.actualReceiverType)) {
                        fieldRef.bits |= 0x4000;
                    }
                    fieldRef.methodBinding = CharOperation.equals((resolvedType = (ReferenceBinding)fieldRef.actualReceiverType).sourceName(), fieldRef.token) ? scope.getConstructor(resolvedType, Binding.NO_TYPES, fieldRef) : scope.findMethod(resolvedType, fieldRef.token, Binding.NO_TYPES, fieldRef, false);
                }
            } else if (source15 && fieldRef.binding != null && fieldRef.binding.isValidBinding() && fieldRef.tagValue == 10 && !fieldRef.binding.isStatic()) {
                if (scopeModifiers == -1) {
                    scopeModifiers = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(fieldRef.sourceStart, fieldRef.sourceEnd, scopeModifiers);
            }
            if (!hasProblems && fieldRef.binding != null && fieldRef.binding.isValidBinding() && fieldRef.actualReceiverType instanceof ReferenceBinding) {
                resolvedType = (ReferenceBinding)fieldRef.actualReceiverType;
                this.verifyTypeReference(fieldRef, fieldRef.receiver, scope, source15, resolvedType, fieldRef.binding.modifiers);
            }
            return;
        }
        if (!hasProblems && (reference instanceof JavadocSingleTypeReference || reference instanceof JavadocQualifiedTypeReference) && reference.resolvedType instanceof ReferenceBinding) {
            ReferenceBinding resolvedType = (ReferenceBinding)reference.resolvedType;
            this.verifyTypeReference(reference, reference, scope, source15, resolvedType, resolvedType.modifiers);
        }
        if (reference instanceof JavadocMessageSend) {
            JavadocMessageSend msgSend = (JavadocMessageSend)reference;
            if (source15 && msgSend.tagValue == 10) {
                if (scopeModifiers == -1) {
                    scopeModifiers = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(msgSend.sourceStart, msgSend.sourceEnd, scopeModifiers);
            }
            if (!hasProblems && msgSend.binding != null && msgSend.binding.isValidBinding() && msgSend.actualReceiverType instanceof ReferenceBinding) {
                ReferenceBinding resolvedType = (ReferenceBinding)msgSend.actualReceiverType;
                this.verifyTypeReference(msgSend, msgSend.receiver, scope, source15, resolvedType, msgSend.binding.modifiers);
            }
        } else if (reference instanceof JavadocAllocationExpression) {
            JavadocAllocationExpression alloc = (JavadocAllocationExpression)reference;
            if (source15 && alloc.tagValue == 10) {
                if (scopeModifiers == -1) {
                    scopeModifiers = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(alloc.sourceStart, alloc.sourceEnd, scopeModifiers);
            }
            if (!hasProblems && alloc.binding != null && alloc.binding.isValidBinding() && alloc.resolvedType instanceof ReferenceBinding) {
                ReferenceBinding resolvedType = (ReferenceBinding)alloc.resolvedType;
                this.verifyTypeReference(alloc, alloc.type, scope, source15, resolvedType, alloc.binding.modifiers);
            }
        } else if (reference instanceof JavadocSingleTypeReference && reference.resolvedType != null && reference.resolvedType.isTypeVariable()) {
            scope.problemReporter().javadocInvalidReference(reference.sourceStart, reference.sourceEnd);
        }
    }

    private void resolveParamTags(MethodScope scope, boolean reportMissing, boolean considerParamRefAsUsage) {
        block9: {
            int j;
            boolean found;
            int i;
            int argumentsSize;
            int paramTagsSize;
            AbstractMethodDeclaration methodDecl;
            block8: {
                methodDecl = scope.referenceMethod();
                int n = paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (methodDecl == null) {
                    for (int i2 = 0; i2 < paramTagsSize; ++i2) {
                        JavadocSingleNameReference param = this.paramReferences[i2];
                        scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                    }
                    return;
                }
                int n2 = argumentsSize = methodDecl.arguments == null ? 0 : methodDecl.arguments.length;
                if (paramTagsSize != 0) break block8;
                if (!reportMissing) break block9;
                for (int i3 = 0; i3 < argumentsSize; ++i3) {
                    Argument arg = methodDecl.arguments[i3];
                    scope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, methodDecl.binding.modifiers);
                }
                break block9;
            }
            LocalVariableBinding[] bindings = new LocalVariableBinding[paramTagsSize];
            int maxBindings = 0;
            for (i = 0; i < paramTagsSize; ++i) {
                JavadocSingleNameReference param = this.paramReferences[i];
                param.resolve(scope, true, considerParamRefAsUsage);
                if (param.binding == null || !param.binding.isValidBinding()) continue;
                found = false;
                for (j = 0; j < maxBindings && !found; ++j) {
                    if (bindings[j] != param.binding) continue;
                    scope.problemReporter().javadocDuplicatedParamTag(param.token, param.sourceStart, param.sourceEnd, methodDecl.binding.modifiers);
                    found = true;
                }
                if (found) continue;
                bindings[maxBindings++] = (LocalVariableBinding)param.binding;
            }
            if (reportMissing) {
                for (i = 0; i < argumentsSize; ++i) {
                    Argument arg = methodDecl.arguments[i];
                    found = false;
                    for (j = 0; j < maxBindings && !found; ++j) {
                        LocalVariableBinding binding = bindings[j];
                        if (arg.binding != binding) continue;
                        found = true;
                    }
                    if (found) continue;
                    scope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, methodDecl.binding.modifiers);
                }
            }
        }
    }

    private void resolveTypeParameterTags(Scope scope, boolean reportMissing) {
        block17: {
            int typeParametersLength;
            int modifiers;
            TypeVariableBinding[] typeVariables;
            TypeParameter[] parameters;
            int paramTypeParamLength;
            block18: {
                paramTypeParamLength = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
                parameters = null;
                typeVariables = null;
                modifiers = -1;
                switch (scope.kind) {
                    case 2: {
                        AbstractMethodDeclaration methodDeclaration = ((MethodScope)scope).referenceMethod();
                        if (methodDeclaration == null) {
                            for (int i = 0; i < paramTypeParamLength; ++i) {
                                JavadocSingleTypeReference param = this.paramTypeParameters[i];
                                scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                            }
                            return;
                        }
                        parameters = methodDeclaration.typeParameters();
                        typeVariables = methodDeclaration.binding.typeVariables;
                        modifiers = methodDeclaration.binding.modifiers;
                        break;
                    }
                    case 3: {
                        TypeDeclaration typeDeclaration = ((ClassScope)scope).referenceContext;
                        parameters = typeDeclaration.typeParameters;
                        typeVariables = typeDeclaration.binding.typeVariables;
                        modifiers = typeDeclaration.binding.modifiers;
                    }
                }
                if (typeVariables == null || typeVariables.length == 0) {
                    for (int i = 0; i < paramTypeParamLength; ++i) {
                        JavadocSingleTypeReference param = this.paramTypeParameters[i];
                        scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                    }
                    return;
                }
                if (parameters == null) break block17;
                reportMissing = reportMissing && scope.compilerOptions().sourceLevel >= 0x310000L;
                typeParametersLength = parameters.length;
                if (paramTypeParamLength != 0) break block18;
                if (!reportMissing) break block17;
                int l = typeParametersLength;
                for (int i = 0; i < l; ++i) {
                    scope.problemReporter().javadocMissingParamTag(parameters[i].name, parameters[i].sourceStart, parameters[i].sourceEnd, modifiers);
                }
                break block17;
            }
            if (typeVariables.length == typeParametersLength) {
                JavadocSingleTypeReference param;
                int i;
                TypeVariableBinding[] bindings = new TypeVariableBinding[paramTypeParamLength];
                for (i = 0; i < paramTypeParamLength; ++i) {
                    param = this.paramTypeParameters[i];
                    TypeBinding paramBindind = param.internalResolveType(scope, 0);
                    if (paramBindind == null || !paramBindind.isValidBinding()) continue;
                    if (paramBindind.isTypeVariable()) {
                        if (scope.compilerOptions().reportUnusedParameterIncludeDocCommentReference) {
                            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)paramBindind;
                            typeVariableBinding.modifiers |= 0x8000000;
                        }
                        boolean duplicate = false;
                        for (int j = 0; j < i && !duplicate; ++j) {
                            if (!TypeBinding.equalsEquals(bindings[j], param.resolvedType)) continue;
                            scope.problemReporter().javadocDuplicatedParamTag(param.token, param.sourceStart, param.sourceEnd, modifiers);
                            duplicate = true;
                        }
                        if (duplicate) continue;
                        bindings[i] = (TypeVariableBinding)param.resolvedType;
                        continue;
                    }
                    scope.problemReporter().javadocUndeclaredParamTagName(param.token, param.sourceStart, param.sourceEnd, modifiers);
                }
                for (i = 0; i < typeParametersLength; ++i) {
                    TypeParameter parameter = parameters[i];
                    boolean found = false;
                    for (int j = 0; j < paramTypeParamLength && !found; ++j) {
                        if (!TypeBinding.equalsEquals(parameter.binding, bindings[j])) continue;
                        found = true;
                        bindings[j] = null;
                    }
                    if (found || !reportMissing) continue;
                    scope.problemReporter().javadocMissingParamTag(parameter.name, parameter.sourceStart, parameter.sourceEnd, modifiers);
                }
                for (i = 0; i < paramTypeParamLength; ++i) {
                    if (bindings[i] == null) continue;
                    param = this.paramTypeParameters[i];
                    scope.problemReporter().javadocUndeclaredParamTagName(param.token, param.sourceStart, param.sourceEnd, modifiers);
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methScope, boolean reportMissing) {
        block15: {
            int j;
            TypeReference typeRef;
            int i;
            int thrownExceptionLength;
            int boundExceptionLength;
            int throwsTagsLength;
            AbstractMethodDeclaration md;
            block14: {
                md = methScope.referenceMethod();
                int n = throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
                if (md == null) {
                    for (int i2 = 0; i2 < throwsTagsLength; ++i2) {
                        TypeReference typeRef2 = this.exceptionReferences[i2];
                        int start = typeRef2.sourceStart;
                        int end = typeRef2.sourceEnd;
                        if (typeRef2 instanceof JavadocQualifiedTypeReference) {
                            start = ((JavadocQualifiedTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocQualifiedTypeReference)typeRef2).tagSourceEnd;
                        } else if (typeRef2 instanceof JavadocSingleTypeReference) {
                            start = ((JavadocSingleTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocSingleTypeReference)typeRef2).tagSourceEnd;
                        }
                        methScope.problemReporter().javadocUnexpectedTag(start, end);
                    }
                    return;
                }
                boundExceptionLength = md.binding == null ? 0 : md.binding.thrownExceptions.length;
                int n2 = thrownExceptionLength = md.thrownExceptions == null ? 0 : md.thrownExceptions.length;
                if (throwsTagsLength != 0) break block14;
                if (!reportMissing) break block15;
                for (int i3 = 0; i3 < boundExceptionLength; ++i3) {
                    int j2;
                    ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i3];
                    if (exceptionBinding == null || !exceptionBinding.isValidBinding()) continue;
                    for (j2 = i3; j2 < thrownExceptionLength && TypeBinding.notEquals(exceptionBinding, md.thrownExceptions[j2].resolvedType); ++j2) {
                    }
                    if (j2 >= thrownExceptionLength) continue;
                    methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[j2], md.binding.modifiers);
                }
                break block15;
            }
            int maxRef = 0;
            TypeReference[] typeReferences = new TypeReference[throwsTagsLength];
            for (i = 0; i < throwsTagsLength; ++i) {
                typeRef = this.exceptionReferences[i];
                typeRef.resolve(methScope);
                TypeBinding typeBinding = typeRef.resolvedType;
                if (typeBinding == null || !typeBinding.isValidBinding() || !typeBinding.isClass()) continue;
                typeReferences[maxRef++] = typeRef;
            }
            for (i = 0; i < boundExceptionLength; ++i) {
                int k;
                ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i];
                if (exceptionBinding != null) {
                    exceptionBinding = (ReferenceBinding)exceptionBinding.erasure();
                }
                boolean found = false;
                for (j = 0; j < maxRef && !found; ++j) {
                    TypeBinding typeBinding;
                    if (typeReferences[j] == null || !TypeBinding.equalsEquals(exceptionBinding, typeBinding = typeReferences[j].resolvedType)) continue;
                    found = true;
                    typeReferences[j] = null;
                }
                if (found || !reportMissing || exceptionBinding == null || !exceptionBinding.isValidBinding()) continue;
                for (k = i; k < thrownExceptionLength && TypeBinding.notEquals(exceptionBinding, md.thrownExceptions[k].resolvedType); ++k) {
                }
                if (k >= thrownExceptionLength) continue;
                methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[k], md.binding.modifiers);
            }
            for (i = 0; i < maxRef; ++i) {
                typeRef = typeReferences[i];
                if (typeRef == null) continue;
                boolean compatible = false;
                for (j = 0; j < thrownExceptionLength && !compatible; ++j) {
                    TypeBinding exceptionBinding = md.thrownExceptions[j].resolvedType;
                    if (exceptionBinding == null) continue;
                    compatible = typeRef.resolvedType.isCompatibleWith(exceptionBinding);
                }
                if (compatible || typeRef.resolvedType.isUncheckedException(false)) continue;
                methScope.problemReporter().javadocInvalidThrowsClassName(typeRef, md.binding.modifiers);
            }
        }
    }

    private void verifyTypeReference(Expression reference, Expression typeReference, Scope scope, boolean source15, ReferenceBinding resolvedType, int modifiers) {
        if (resolvedType.isValidBinding()) {
            int scopeModifiers = -1;
            if (!this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, modifiers)) {
                scope.problemReporter().javadocHiddenReference(typeReference.sourceStart, reference.sourceEnd, scope, modifiers);
                return;
            }
            if (reference != typeReference && !this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, resolvedType.modifiers)) {
                scope.problemReporter().javadocHiddenReference(typeReference.sourceStart, typeReference.sourceEnd, scope, resolvedType.modifiers);
                return;
            }
            if (resolvedType.isMemberType()) {
                ReferenceBinding topLevelType = resolvedType;
                int packageLength = topLevelType.fPackage.compoundName.length;
                int depth = resolvedType.depth();
                int idx = depth + packageLength;
                char[][] computedCompoundName = new char[idx + 1][];
                computedCompoundName[idx] = topLevelType.sourceName;
                while (topLevelType.enclosingType() != null) {
                    topLevelType = topLevelType.enclosingType();
                    computedCompoundName[--idx] = topLevelType.sourceName;
                }
                int i = packageLength;
                while (--i >= 0) {
                    computedCompoundName[--idx] = topLevelType.fPackage.compoundName[i];
                }
                ClassScope topLevelScope = scope.classScope();
                if (topLevelScope.parent.kind != 4 || !CharOperation.equals(topLevelType.sourceName, topLevelScope.referenceContext.name)) {
                    topLevelScope = topLevelScope.outerMostClassScope();
                    if (typeReference instanceof JavadocSingleTypeReference && (!source15 && depth == 1 || TypeBinding.notEquals(topLevelType, topLevelScope.referenceContext.binding))) {
                        boolean hasValidImport = false;
                        if (source15) {
                            CompilationUnitScope unitScope = topLevelScope.compilationUnitScope();
                            ImportBinding[] imports = unitScope.imports;
                            int length = imports == null ? 0 : imports.length;
                            block2: for (int i2 = 0; i2 < length; ++i2) {
                                char[][] compoundName = imports[i2].compoundName;
                                int compoundNameLength = compoundName.length;
                                if ((!imports[i2].onDemand || compoundNameLength != computedCompoundName.length - 1) && compoundNameLength != computedCompoundName.length) continue;
                                int j = compoundNameLength;
                                while (--j >= 0 && CharOperation.equals(imports[i2].compoundName[j], computedCompoundName[j])) {
                                    if (j != 0) continue;
                                    hasValidImport = true;
                                    ImportReference importReference = imports[i2].reference;
                                    if (importReference == null) break block2;
                                    importReference.bits |= 2;
                                    break block2;
                                }
                            }
                            if (!hasValidImport) {
                                if (scopeModifiers == -1) {
                                    scopeModifiers = scope.getDeclarationModifiers();
                                }
                                scope.problemReporter().javadocInvalidMemberTypeQualification(typeReference.sourceStart, typeReference.sourceEnd, scopeModifiers);
                            }
                        } else {
                            if (scopeModifiers == -1) {
                                scopeModifiers = scope.getDeclarationModifiers();
                            }
                            scope.problemReporter().javadocInvalidMemberTypeQualification(typeReference.sourceStart, typeReference.sourceEnd, scopeModifiers);
                            return;
                        }
                    }
                }
                if (typeReference instanceof JavadocQualifiedTypeReference && !scope.isDefinedInSameUnit(resolvedType)) {
                    char[][] typeRefName = ((JavadocQualifiedTypeReference)typeReference).getTypeName();
                    int skipLength = 0;
                    if (topLevelScope.getCurrentPackage() == resolvedType.getPackage() && typeRefName.length < computedCompoundName.length) {
                        skipLength = resolvedType.fPackage.compoundName.length;
                    }
                    boolean valid = true;
                    if (typeRefName.length == computedCompoundName.length - skipLength) {
                        for (int i3 = 0; i3 < typeRefName.length; ++i3) {
                            if (CharOperation.equals(typeRefName[i3], computedCompoundName[i3 + skipLength])) continue;
                            valid = false;
                            break;
                        }
                    } else {
                        valid = false;
                    }
                    if (!valid) {
                        if (scopeModifiers == -1) {
                            scopeModifiers = scope.getDeclarationModifiers();
                        }
                        scope.problemReporter().javadocInvalidMemberTypeQualification(typeReference.sourceStart, typeReference.sourceEnd, scopeModifiers);
                        return;
                    }
                }
            }
            if (scope.referenceCompilationUnit().isPackageInfo() && typeReference instanceof JavadocSingleTypeReference && resolvedType.fPackage.compoundName.length > 0) {
                scope.problemReporter().javadocInvalidReference(typeReference.sourceStart, typeReference.sourceEnd);
                return;
            }
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i;
            int length;
            if (this.paramReferences != null) {
                length = this.paramReferences.length;
                for (i = 0; i < length; ++i) {
                    this.paramReferences[i].traverse(visitor, scope);
                }
            }
            if (this.paramTypeParameters != null) {
                length = this.paramTypeParameters.length;
                for (i = 0; i < length; ++i) {
                    this.paramTypeParameters[i].traverse(visitor, scope);
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(visitor, scope);
            }
            if (this.exceptionReferences != null) {
                length = this.exceptionReferences.length;
                for (i = 0; i < length; ++i) {
                    this.exceptionReferences[i].traverse(visitor, scope);
                }
            }
            if (this.seeReferences != null) {
                length = this.seeReferences.length;
                for (i = 0; i < length; ++i) {
                    this.seeReferences[i].traverse(visitor, scope);
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            int i;
            int length;
            if (this.paramReferences != null) {
                length = this.paramReferences.length;
                for (i = 0; i < length; ++i) {
                    this.paramReferences[i].traverse(visitor, scope);
                }
            }
            if (this.paramTypeParameters != null) {
                length = this.paramTypeParameters.length;
                for (i = 0; i < length; ++i) {
                    this.paramTypeParameters[i].traverse(visitor, scope);
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(visitor, scope);
            }
            if (this.exceptionReferences != null) {
                length = this.exceptionReferences.length;
                for (i = 0; i < length; ++i) {
                    this.exceptionReferences[i].traverse(visitor, scope);
                }
            }
            if (this.seeReferences != null) {
                length = this.seeReferences.length;
                for (i = 0; i < length; ++i) {
                    this.seeReferences[i].traverse(visitor, scope);
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

