/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.Receiver;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Util;

public abstract class AbstractMethodDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    public MethodScope scope;
    public char[] selector;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public Receiver receiver;
    public Argument[] arguments;
    public TypeReference[] thrownExceptions;
    public Statement[] statements;
    public int explicitDeclarations;
    public MethodBinding binding;
    public boolean ignoreFurtherInvestigation = false;
    public Javadoc javadoc;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;

    AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    @Override
    public void abort(int abortLevel, CategorizedProblem problem) {
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, problem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, problem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, problem);
            }
        }
        throw new AbortMethod(this.compilationResult, problem);
    }

    public void createArgumentBindings() {
        AbstractMethodDeclaration.createArgumentBindings(this.arguments, this.binding, this.scope);
    }

    static void createArgumentBindings(Argument[] arguments, MethodBinding binding, MethodScope scope) {
        boolean useTypeAnnotations = scope.environment().usesNullTypeAnnotations();
        if (arguments != null && binding != null) {
            int length = arguments.length;
            for (int i = 0; i < length; ++i) {
                long argTypeTagBits;
                Argument argument = arguments[i];
                binding.parameters[i] = argument.createBinding(scope, binding.parameters[i]);
                if (useTypeAnnotations || (argTypeTagBits = argument.binding.tagBits & 0x180000000000000L) == 0L) continue;
                if (binding.parameterNonNullness == null) {
                    binding.parameterNonNullness = new Boolean[arguments.length];
                    binding.tagBits |= 0x1000L;
                }
                binding.parameterNonNullness[i] = argTypeTagBits == 0x100000000000000L;
            }
        }
    }

    public void bindArguments() {
        if (this.arguments != null) {
            if (this.binding == null) {
                int length = this.arguments.length;
                for (int i = 0; i < length; ++i) {
                    this.arguments[i].bind(this.scope, null, true);
                }
                return;
            }
            boolean used = this.binding.isAbstract() || this.binding.isNative();
            AnnotationBinding[][] paramAnnotations = null;
            int length = this.arguments.length;
            for (int i = 0; i < length; ++i) {
                Argument argument = this.arguments[i];
                this.binding.parameters[i] = argument.bind(this.scope, this.binding.parameters[i], used);
                if (argument.annotations != null) {
                    if (paramAnnotations == null) {
                        paramAnnotations = new AnnotationBinding[length][];
                        for (int j = 0; j < i; ++j) {
                            paramAnnotations[j] = Binding.NO_ANNOTATIONS;
                        }
                    }
                    paramAnnotations[i] = argument.binding.getAnnotations();
                    continue;
                }
                if (paramAnnotations == null) continue;
                paramAnnotations[i] = Binding.NO_ANNOTATIONS;
            }
            if (paramAnnotations != null) {
                this.binding.setParameterAnnotations(paramAnnotations);
            }
        }
    }

    public void bindThrownExceptions() {
        block5: {
            if (this.thrownExceptions == null || this.binding == null || this.binding.thrownExceptions == null) break block5;
            int length = this.binding.thrownExceptions.length;
            int thrownExceptionLength = this.thrownExceptions.length;
            if (length == thrownExceptionLength) {
                for (int i = 0; i < length; ++i) {
                    this.thrownExceptions[i].resolvedType = this.binding.thrownExceptions[i];
                }
            } else {
                int bindingIndex = 0;
                for (int i = 0; i < thrownExceptionLength && bindingIndex < length; ++i) {
                    TypeReference thrownException = this.thrownExceptions[i];
                    ReferenceBinding thrownExceptionBinding = this.binding.thrownExceptions[bindingIndex];
                    char[][] bindingCompoundName = thrownExceptionBinding.compoundName;
                    if (bindingCompoundName == null) continue;
                    if (thrownException instanceof SingleTypeReference) {
                        int lengthName = bindingCompoundName.length;
                        char[] thrownExceptionTypeName = thrownException.getTypeName()[0];
                        if (!CharOperation.equals(thrownExceptionTypeName, bindingCompoundName[lengthName - 1])) continue;
                        thrownException.resolvedType = thrownExceptionBinding;
                        ++bindingIndex;
                        continue;
                    }
                    if (!CharOperation.equals(thrownException.getTypeName(), bindingCompoundName)) continue;
                    thrownException.resolvedType = thrownExceptionBinding;
                    ++bindingIndex;
                }
            }
        }
    }

    static void analyseArguments(LookupEnvironment environment, FlowInfo flowInfo, Argument[] methodArguments, MethodBinding methodBinding) {
        if (methodArguments != null) {
            boolean usesNullTypeAnnotations = environment.usesNullTypeAnnotations();
            int length = Math.min(methodBinding.parameters.length, methodArguments.length);
            for (int i = 0; i < length; ++i) {
                Boolean nonNullNess;
                if (usesNullTypeAnnotations) {
                    long tagBits = methodBinding.parameters[i].tagBits & 0x180000000000000L;
                    if (tagBits == 0x100000000000000L) {
                        flowInfo.markAsDefinitelyNonNull(methodArguments[i].binding);
                    } else if (tagBits == 0x80000000000000L) {
                        flowInfo.markPotentiallyNullBit(methodArguments[i].binding);
                    } else if (methodBinding.parameters[i].isFreeTypeVariable()) {
                        flowInfo.markNullStatus(methodArguments[i].binding, 48);
                    }
                } else if (methodBinding.parameterNonNullness != null && (nonNullNess = methodBinding.parameterNonNullness[i]) != null) {
                    if (nonNullNess.booleanValue()) {
                        flowInfo.markAsDefinitelyNonNull(methodArguments[i].binding);
                    } else {
                        flowInfo.markPotentiallyNullBit(methodArguments[i].binding);
                    }
                }
                flowInfo.markAsDefinitelyAssigned(methodArguments[i].binding);
            }
        }
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        TypeDeclaration referenceContext;
        classFile.codeStream.wideMode = false;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int problemsLength = problems.length;
            CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemMethod(this, this.binding, problemsCopy);
            return;
        }
        int problemResetPC = 0;
        CompilationResult unitResult = null;
        int problemCount = 0;
        if (classScope != null && (referenceContext = classScope.referenceContext) != null) {
            unitResult = referenceContext.compilationResult();
            problemCount = unitResult.problemCount;
        }
        boolean restart = false;
        boolean abort = false;
        do {
            try {
                problemResetPC = classFile.contentsOffset;
                this.generateCode(classFile);
                restart = false;
            }
            catch (AbortMethod e) {
                if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = problemResetPC;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    if (unitResult != null) {
                        unitResult.problemCount = problemCount;
                    }
                    restart = true;
                    continue;
                }
                if (e.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = problemResetPC;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    if (unitResult != null) {
                        unitResult.problemCount = problemCount;
                    }
                    restart = true;
                    continue;
                }
                restart = false;
                abort = true;
            }
        } while (restart);
        if (abort) {
            CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int problemsLength = problems.length;
            CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemMethod(this, this.binding, problemsCopy, problemResetPC);
        }
    }

    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttributes(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int i;
            int max;
            int codeAttributeOffset = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            this.scope.computeLocalVariablePositions(this.binding.isStatic() ? 0 : 1, codeStream);
            if (this.arguments != null) {
                max = this.arguments.length;
                for (i = 0; i < max; ++i) {
                    LocalVariableBinding argBinding = this.arguments[i].binding;
                    codeStream.addVisibleLocalVariable(argBinding);
                    argBinding.recordInitializationStartPC(0);
                }
            }
            if (this.statements != null) {
                max = this.statements.length;
                for (i = 0; i < max; ++i) {
                    this.statements[i].generateCode(this.scope, codeStream);
                }
            }
            if (this.ignoreFurtherInvestigation) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            if ((this.bits & 0x40) != 0) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.declarationSourceEnd);
            try {
                classFile.completeCodeAttribute(codeAttributeOffset);
            }
            catch (NegativeArraySizeException e) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            ++attributeNumber;
        } else {
            this.checkArgumentsSize();
        }
        classFile.completeMethodInfo(this.binding, methodAttributeOffset, attributeNumber);
    }

    public void getAllAnnotationContexts(int targetType, List allAnnotationContexts) {
    }

    private void checkArgumentsSize() {
        TypeBinding[] parameters = this.binding.parameters;
        int size = 1;
        int max = parameters.length;
        for (int i = 0; i < max; ++i) {
            switch (parameters[i].id) {
                case 7: 
                case 8: {
                    size += 2;
                    break;
                }
                default: {
                    ++size;
                }
            }
            if (size <= 255) continue;
            this.scope.problemReporter().noMoreAvailableSpaceForArgument(this.scope.locals[i], this.scope.locals[i].declaration);
        }
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        if (this.scope != null) {
            return this.scope.compilationUnitScope().referenceContext;
        }
        return null;
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        if (this.binding != null) {
            return this.binding.isAbstract();
        }
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationMethod() {
        return false;
    }

    public boolean isClinit() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isDefaultConstructor() {
        return false;
    }

    public boolean isDefaultMethod() {
        return false;
    }

    public boolean isInitializationMethod() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isNative() {
        if (this.binding != null) {
            return this.binding.isNative();
        }
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public abstract void parseStatements(Parser var1, CompilationUnitDeclaration var2);

    @Override
    public StringBuffer print(int tab, StringBuffer output) {
        int i;
        TypeParameter[] typeParams;
        if (this.javadoc != null) {
            this.javadoc.print(tab, output);
        }
        AbstractMethodDeclaration.printIndent(tab, output);
        AbstractMethodDeclaration.printModifiers(this.modifiers, output);
        if (this.annotations != null) {
            AbstractMethodDeclaration.printAnnotations(this.annotations, output);
            output.append(' ');
        }
        if ((typeParams = this.typeParameters()) != null) {
            output.append('<');
            int max = typeParams.length - 1;
            for (int j = 0; j < max; ++j) {
                typeParams[j].print(0, output);
                output.append(", ");
            }
            typeParams[max].print(0, output);
            output.append('>');
        }
        this.printReturnType(0, output).append(this.selector).append('(');
        if (this.receiver != null) {
            this.receiver.print(0, output);
        }
        if (this.arguments != null) {
            for (i = 0; i < this.arguments.length; ++i) {
                if (i > 0 || this.receiver != null) {
                    output.append(", ");
                }
                this.arguments[i].print(0, output);
            }
        }
        output.append(')');
        if (this.thrownExceptions != null) {
            output.append(" throws ");
            for (i = 0; i < this.thrownExceptions.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                this.thrownExceptions[i].print(0, output);
            }
        }
        this.printBody(tab + 1, output);
        return output;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return output.append(';');
        }
        output.append(" {");
        if (this.statements != null) {
            for (int i = 0; i < this.statements.length; ++i) {
                output.append('\n');
                this.statements[i].printStatement(indent, output);
            }
        }
        output.append('\n');
        AbstractMethodDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    public StringBuffer printReturnType(int indent, StringBuffer output) {
        return output;
    }

    public void resolve(ClassScope upperScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        try {
            this.bindArguments();
            this.resolveReceiver();
            this.bindThrownExceptions();
            this.resolveJavadoc();
            AbstractMethodDeclaration.resolveAnnotations(this.scope, this.annotations, this.binding, this.isConstructor());
            long sourceLevel = this.scope.compilerOptions().sourceLevel;
            if (sourceLevel < 0x340000L) {
                this.validateNullAnnotations(this.scope.environment().usesNullTypeAnnotations());
            }
            this.resolveStatements();
            if (this.binding != null && (this.binding.getAnnotationTagBits() & 0x400000000000L) == 0L && (this.binding.modifiers & 0x100000) != 0 && sourceLevel >= 0x310000L) {
                this.scope.problemReporter().missingDeprecatedAnnotationForMethod(this);
            }
        }
        catch (AbortMethod e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolveReceiver() {
        char[][] tokens;
        if (this.receiver == null) {
            return;
        }
        if (this.receiver.modifiers != 0) {
            this.scope.problemReporter().illegalModifiers(this.receiver.declarationSourceStart, this.receiver.declarationSourceEnd);
        }
        TypeBinding resolvedReceiverType = this.receiver.type.resolvedType;
        if (this.binding == null || resolvedReceiverType == null || !resolvedReceiverType.isValidBinding()) {
            return;
        }
        ReferenceBinding declaringClass = this.binding.declaringClass;
        if (this.isStatic() || declaringClass.isAnonymousType()) {
            this.scope.problemReporter().disallowedThisParameter(this.receiver);
            return;
        }
        ReferenceBinding enclosingReceiver = this.scope.enclosingReceiverType();
        if (this.isConstructor()) {
            if (declaringClass.isStatic() || (declaringClass.tagBits & 0x18L) == 0L) {
                this.scope.problemReporter().disallowedThisParameter(this.receiver);
                return;
            }
            enclosingReceiver = enclosingReceiver.enclosingType();
        }
        char[][] cArray = tokens = this.receiver.qualifyingName == null ? (char[][])null : this.receiver.qualifyingName.getName();
        if (this.isConstructor()) {
            if (tokens == null || tokens.length > 1 || !CharOperation.equals(enclosingReceiver.sourceName(), tokens[0])) {
                this.scope.problemReporter().illegalQualifierForExplicitThis(this.receiver, enclosingReceiver);
                this.receiver.qualifyingName = null;
            }
        } else if (tokens != null && tokens.length > 0) {
            this.scope.problemReporter().illegalQualifierForExplicitThis2(this.receiver);
            this.receiver.qualifyingName = null;
        }
        if (TypeBinding.notEquals(enclosingReceiver, resolvedReceiverType)) {
            this.scope.problemReporter().illegalTypeForExplicitThis(this.receiver, enclosingReceiver);
        }
        if (this.receiver.type.hasNullTypeAnnotation(TypeReference.AnnotationPosition.ANY)) {
            this.scope.problemReporter().nullAnnotationUnsupportedLocation(this.receiver.type);
        }
    }

    public void resolveJavadoc() {
        if (this.binding == null) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
            return;
        }
        if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            int javadocVisibility = this.binding.modifiers & 7;
            ClassScope classScope = this.scope.classScope();
            ProblemReporter reporter = this.scope.problemReporter();
            int severity = reporter.computeSeverity(-1610612250);
            if (severity != 256) {
                if (classScope != null) {
                    javadocVisibility = Util.computeOuterMostVisibility(classScope.referenceType(), javadocVisibility);
                }
                int javadocModifiers = this.binding.modifiers & 0xFFFFFFF8 | javadocVisibility;
                reporter.javadocMissing(this.sourceStart, this.sourceEnd, severity, javadocModifiers);
            }
        }
    }

    public void resolveStatements() {
        if (this.statements != null) {
            int length = this.statements.length;
            for (int i = 0; i < length; ++i) {
                this.statements[i].resolve(this.scope);
            }
        } else if (!((this.bits & 8) == 0 || this.isConstructor() && this.arguments == null)) {
            this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd + 1);
        }
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int problemId) {
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
    }

    public TypeParameter[] typeParameters() {
        return null;
    }

    void validateNullAnnotations(boolean useTypeAnnotations) {
        block4: {
            block3: {
                if (this.binding == null) {
                    return;
                }
                if (useTypeAnnotations) break block3;
                if (this.binding.parameterNonNullness == null) break block4;
                int length = this.binding.parameters.length;
                for (int i = 0; i < length; ++i) {
                    long nullAnnotationTagBit;
                    if (this.binding.parameterNonNullness[i] == null) continue;
                    long l = nullAnnotationTagBit = this.binding.parameterNonNullness[i] != false ? 0x100000000000000L : 0x80000000000000L;
                    if (this.scope.validateNullAnnotation(nullAnnotationTagBit, this.arguments[i].type, this.arguments[i].annotations)) continue;
                    this.binding.parameterNonNullness[i] = null;
                }
                break block4;
            }
            int length = this.binding.parameters.length;
            for (int i = 0; i < length; ++i) {
                this.scope.validateNullAnnotation(this.binding.parameters[i].tagBits, this.arguments[i].type, this.arguments[i].annotations);
            }
        }
    }
}

