/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import org.wildfly.discovery.ArrayIterator;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

public final class AllFilterSpec
extends FilterSpec
implements Iterable<FilterSpec> {
    private final FilterSpec[] children;

    AllFilterSpec(FilterSpec ... specs) {
        if (specs.length == 0) {
            throw new IllegalArgumentException("No child filters specified");
        }
        this.children = specs;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        for (FilterSpec child : this.children) {
            if (child.matchesSimple(attributes)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        for (FilterSpec child : this.children) {
            if (child.matchesMulti(attributes)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mayMatch(Collection<String> attributeNames) {
        for (FilterSpec child : this.children) {
            if (child.mayMatch(attributeNames)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mayNotMatch(Collection<String> attributeNames) {
        for (FilterSpec child : this.children) {
            if (child.mayNotMatch(attributeNames)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <P, R, E extends Exception> R accept(FilterSpec.Visitor<P, R, E> visitor, P parameter) throws E {
        return visitor.handle(this, parameter);
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(').append('&');
        for (FilterSpec child : this.children) {
            child.toString(builder);
        }
        builder.append(')');
    }

    @Override
    public ListIterator<FilterSpec> iterator() {
        return new ArrayIterator<FilterSpec>(this.children);
    }
}

