/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.scriptengine;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class ScriptEvaluator {
    private final ScriptEngine engine;

    public ScriptEvaluator(ScriptEngine engine) {
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(String script, Map<String, Object> bindings) throws ScriptException {
        if (this.engineAllowsParallelAccessFromMultipleThreads()) {
            return this.doEvaluate(script, bindings);
        }
        ScriptEngine scriptEngine = this.engine;
        synchronized (scriptEngine) {
            return this.doEvaluate(script, bindings);
        }
    }

    private Object doEvaluate(String script, Map<String, Object> bindings) throws ScriptException {
        return this.engine.eval(script, (Bindings)new SimpleBindings(bindings));
    }

    private boolean engineAllowsParallelAccessFromMultipleThreads() {
        String threadingType = (String)this.engine.getFactory().getParameter("THREADING");
        return "THREAD-ISOLATED".equals(threadingType) || "STATELESS".equals(threadingType);
    }
}

