/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.jdbc.mapper;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.jdbc.KeyMapper;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.HashPasswordSpec;
import org.wildfly.security.password.spec.IteratedHashPasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedHashPasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;
import org.wildfly.security.password.spec.SaltedHashPasswordSpec;
import org.wildfly.security.password.util.ModularCrypt;
import org.wildfly.security.util.CodePointIterator;

public class PasswordKeyMapper
implements KeyMapper {
    private final int hashColumn;
    private final int saltColumn;
    private final int iterationCountColumn;
    private final int defaultIterationCount;
    private final int algorithmColumn;
    private final String defaultAlgorithm;

    PasswordKeyMapper(Builder builder) {
        int hashColumn = builder.hashColumn;
        Assert.checkMinimumParameter("hashColumn", 1, hashColumn);
        this.hashColumn = hashColumn;
        int saltColumn = builder.saltColumn;
        if (saltColumn != -1) {
            Assert.checkMinimumParameter("saltColumn", 1, saltColumn);
        }
        this.saltColumn = saltColumn;
        int iterationCountColumn = builder.iterationCountColumn;
        if (iterationCountColumn != -1) {
            Assert.checkMinimumParameter("iterationCountColumn", 1, iterationCountColumn);
        }
        this.iterationCountColumn = iterationCountColumn;
        int defaultIterationCount = builder.defaultIterationCount;
        if (defaultIterationCount != -1) {
            Assert.checkMinimumParameter("defaultIterationCount", 1, defaultIterationCount);
        }
        this.defaultIterationCount = defaultIterationCount;
        int algorithmColumn = builder.algorithmColumn;
        if (algorithmColumn != -1) {
            Assert.checkMinimumParameter("algorithmColumn", 1, algorithmColumn);
        }
        this.algorithmColumn = algorithmColumn;
        this.defaultAlgorithm = builder.defaultAlgorithm;
    }

    @Override
    public SupportLevel getCredentialSupport(ResultSet resultSet, Supplier<Provider[]> providers) {
        try {
            Object map = this.map(resultSet, (Supplier)providers);
            if (map != null) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }
        catch (SQLException cause) {
            throw ElytronMessages.log.couldNotObtainCredentialWithCause(cause);
        }
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        return PasswordCredential.class.isAssignableFrom(credentialType) ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) {
        return PasswordCredential.canVerifyEvidence(evidenceType, algorithmName) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    public String getDefaultAlgorithm() {
        return this.defaultAlgorithm;
    }

    public int getHashColumn() {
        return this.hashColumn;
    }

    public int getSaltColumn() {
        return this.saltColumn;
    }

    public int getIterationCountColumn() {
        return this.iterationCountColumn;
    }

    public int getDefaultIterationCount() {
        return this.defaultIterationCount;
    }

    public int getAlgorithmColumn() {
        return this.algorithmColumn;
    }

    private static byte[] getBinaryColumn(ResultSetMetaData metaData, ResultSet resultSet, int column) throws SQLException {
        if (column == -1) {
            return null;
        }
        int columnType = metaData.getColumnType(column);
        switch (columnType) {
            case -4: 
            case -3: 
            case -2: {
                return resultSet.getBytes(column);
            }
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return CodePointIterator.ofString(resultSet.getString(column)).base64Decode().drain();
            }
        }
        Object object = resultSet.getObject(column);
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return CodePointIterator.ofString(resultSet.getString(column)).base64Decode().drain();
        }
        return null;
    }

    private static String getStringColumn(ResultSetMetaData metaData, ResultSet resultSet, int column) throws SQLException {
        if (column == -1) {
            return null;
        }
        int columnType = metaData.getColumnType(column);
        switch (columnType) {
            case -4: 
            case -3: 
            case -2: {
                return new String(resultSet.getBytes(column), StandardCharsets.UTF_8);
            }
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return resultSet.getString(column);
            }
        }
        Object object = resultSet.getObject(column);
        if (object instanceof byte[]) {
            return new String((byte[])object, StandardCharsets.UTF_8);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    @Override
    public Credential map(ResultSet resultSet, Supplier<Provider[]> providers) throws SQLException {
        PasswordSpec passwordSpec;
        PasswordFactory passwordFactory;
        byte[] hash = null;
        char[] clear = null;
        byte[] salt = null;
        int iterationCount = -1;
        String algorithmName = this.getDefaultAlgorithm();
        int hashColumn = this.getHashColumn();
        int saltColumn = this.getSaltColumn();
        int iterationCountColumn = this.getIterationCountColumn();
        int algorithmColumn = this.getAlgorithmColumn();
        int defaultIterationCount = this.getDefaultIterationCount();
        ResultSetMetaData metaData = resultSet.getMetaData();
        if (resultSet.next()) {
            String s;
            if (algorithmColumn > 0 && (algorithmName = resultSet.getString(algorithmColumn)) == null) {
                algorithmName = this.getDefaultAlgorithm();
            }
            if ("clear".equals(algorithmName)) {
                s = PasswordKeyMapper.getStringColumn(metaData, resultSet, hashColumn);
                if (s != null) {
                    clear = s.toCharArray();
                } else {
                    hash = PasswordKeyMapper.getBinaryColumn(metaData, resultSet, hashColumn);
                }
            } else {
                char[] chars;
                String identified;
                if (saltColumn == -1 && iterationCountColumn == -1 && (s = PasswordKeyMapper.getStringColumn(metaData, resultSet, hashColumn)) != null && (identified = ModularCrypt.identifyAlgorithm(chars = s.toCharArray())) != null) {
                    try {
                        return new PasswordCredential(ModularCrypt.decode(chars));
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        // empty catch block
                    }
                }
                hash = PasswordKeyMapper.getBinaryColumn(metaData, resultSet, hashColumn);
            }
            if (saltColumn > 0) {
                salt = PasswordKeyMapper.getBinaryColumn(metaData, resultSet, saltColumn);
            }
            iterationCount = iterationCountColumn > 0 ? resultSet.getInt(iterationCountColumn) : defaultIterationCount;
        }
        try {
            passwordFactory = PasswordFactory.getInstance(algorithmName, providers);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.couldNotObtainPasswordFactoryForAlgorithm(algorithmName, e);
        }
        if (hash != null) {
            passwordSpec = salt != null ? (iterationCount > 0 ? new IteratedSaltedHashPasswordSpec(hash, salt, iterationCount) : new SaltedHashPasswordSpec(hash, salt)) : (iterationCount > 0 ? new IteratedHashPasswordSpec(hash, iterationCount) : new HashPasswordSpec(hash));
        } else if (clear != null) {
            passwordSpec = new ClearPasswordSpec(clear);
        } else {
            return null;
        }
        try {
            return new PasswordCredential(passwordFactory.generatePassword(passwordSpec));
        }
        catch (InvalidKeySpecException e) {
            throw ElytronMessages.log.invalidPasswordKeySpecificationForAlgorithm(this.defaultAlgorithm, e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        int hashColumn = -1;
        int saltColumn = -1;
        int iterationCountColumn = -1;
        int defaultIterationCount = -1;
        int algorithmColumn = -1;
        String defaultAlgorithm;

        Builder() {
        }

        public int getHashColumn() {
            return this.hashColumn;
        }

        public Builder setHashColumn(int hashColumn) {
            this.hashColumn = hashColumn;
            return this;
        }

        public int getSaltColumn() {
            return this.saltColumn;
        }

        public Builder setSaltColumn(int saltColumn) {
            this.saltColumn = saltColumn;
            return this;
        }

        public int getIterationCountColumn() {
            return this.iterationCountColumn;
        }

        public Builder setIterationCountColumn(int iterationCountColumn) {
            this.iterationCountColumn = iterationCountColumn;
            return this;
        }

        public int getDefaultIterationCount() {
            return this.defaultIterationCount;
        }

        public Builder setDefaultIterationCount(int defaultIterationCount) {
            this.defaultIterationCount = defaultIterationCount;
            return this;
        }

        public int getAlgorithmColumn() {
            return this.algorithmColumn;
        }

        public Builder setAlgorithmColumn(int algorithmColumn) {
            this.algorithmColumn = algorithmColumn;
            return this;
        }

        public String getDefaultAlgorithm() {
            return this.defaultAlgorithm;
        }

        public Builder setDefaultAlgorithm(String defaultAlgorithm) {
            this.defaultAlgorithm = defaultAlgorithm;
            return this;
        }

        public PasswordKeyMapper build() {
            return new PasswordKeyMapper(this);
        }
    }
}

