/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.IdentitySharedExclusiveLock;
import org.wildfly.security.auth.server.CloseableIterator;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.BasicPasswordSpecEncoding;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;
import org.wildfly.security.password.util.ModularCrypt;
import org.wildfly.security.permission.ElytronPermission;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.CodePointIterator;

public final class FileSystemSecurityRealm
implements ModifiableSecurityRealm,
CacheableSecurityRealm {
    static final String ELYTRON_1_0 = "urn:elytron:1.0";
    static final ElytronPermission CREATE_SECURITY_REALM = ElytronPermission.forName("createSecurityRealm");
    private final Path root;
    private final NameRewriter nameRewriter;
    private final int levels;
    private final boolean encoded;
    private final ConcurrentHashMap<String, IdentitySharedExclusiveLock> realmIdentityLocks = new ConcurrentHashMap();

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels, boolean encoded) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_SECURITY_REALM);
        }
        this.root = root;
        this.nameRewriter = nameRewriter;
        this.levels = levels;
        this.encoded = encoded;
    }

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels) {
        this(root, nameRewriter, levels, true);
    }

    public FileSystemSecurityRealm(Path root, int levels) {
        this(root, NameRewriter.IDENTITY_REWRITER, levels, true);
    }

    public FileSystemSecurityRealm(Path root) {
        this(root, NameRewriter.IDENTITY_REWRITER, 2, true);
    }

    private Path pathFor(String name) {
        assert (name.codePointCount(0, name.length()) > 0);
        String normalizedName = name;
        if (this.encoded) {
            normalizedName = Normalizer.normalize(name, Normalizer.Form.NFKC).toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "_");
        }
        Path path = this.root;
        int idx = 0;
        for (int level = 0; level < this.levels; ++level) {
            int newIdx = normalizedName.offsetByCodePoints(idx, 1);
            path = path.resolve(normalizedName.substring(idx, newIdx));
            idx = newIdx;
            if (idx == normalizedName.length()) break;
        }
        if (this.encoded) {
            String base32 = ByteIterator.ofBytes(new ByteStringBuilder().append(name).toArray()).base32Encode(Alphabet.Base32Alphabet.STANDARD, false).drainToString();
            name = normalizedName + "-" + base32;
        }
        return path.resolve(name + ".xml");
    }

    private String nameFor(Path path) {
        String fileName = path.toString();
        fileName = fileName.substring(0, fileName.length() - 4);
        if (this.encoded) {
            CodePointIterator it = CodePointIterator.ofString(fileName);
            it.delimitedBy(45).skipAll();
            it.next();
            fileName = it.base32Decode(Alphabet.Base32Alphabet.STANDARD, false).asUtf8String().drainToString();
        }
        return fileName;
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) {
        return principal instanceof NamePrincipal ? this.getRealmIdentity(principal.getName(), false) : RealmIdentity.NON_EXISTENT;
    }

    @Override
    public ModifiableRealmIdentity getRealmIdentityForUpdate(Principal principal) {
        return principal instanceof NamePrincipal ? this.getRealmIdentity(principal.getName(), true) : ModifiableRealmIdentity.NON_EXISTENT;
    }

    @Override
    public void registerIdentityChangeListener(Consumer<Principal> listener) {
    }

    private ModifiableRealmIdentity getRealmIdentity(String name, boolean exclusive) {
        String finalName = this.nameRewriter.rewriteName(name);
        if (finalName == null) {
            throw ElytronMessages.log.invalidName();
        }
        IdentitySharedExclusiveLock realmIdentityLock = this.getRealmIdentityLockForName(finalName);
        IdentitySharedExclusiveLock.IdentityLock lock = exclusive ? realmIdentityLock.lockExclusive() : realmIdentityLock.lockShared();
        return new Identity(finalName, this.pathFor(finalName), lock);
    }

    @Override
    public CloseableIterator<ModifiableRealmIdentity> getRealmIdentityIterator() throws RealmUnavailableException {
        return this.subIterator(this.root, this.levels);
    }

    private CloseableIterator<ModifiableRealmIdentity> subIterator(Path root, final int levels) {
        Iterator<Path> iterator;
        DirectoryStream<Path> stream;
        if (levels == 0) {
            Iterator<Path> iterator2;
            DirectoryStream<Path> stream2;
            try {
                stream2 = Files.newDirectoryStream(root, "*.xml");
                iterator2 = stream2.iterator();
            }
            catch (IOException e) {
                ElytronMessages.log.debug(e);
                return CloseableIterator.emptyIterator();
            }
            return new CloseableIterator<ModifiableRealmIdentity>(){

                @Override
                public boolean hasNext() {
                    if (!iterator2.hasNext()) {
                        try {
                            this.close();
                        }
                        catch (IOException e) {
                            ElytronMessages.log.debug(e);
                        }
                    }
                    return iterator2.hasNext();
                }

                @Override
                public ModifiableRealmIdentity next() {
                    Path path = (Path)iterator2.next();
                    String name = FileSystemSecurityRealm.this.nameFor(path.getFileName());
                    return FileSystemSecurityRealm.this.getRealmIdentityForUpdate(new NamePrincipal(name));
                }

                @Override
                public void close() throws IOException {
                    stream2.close();
                }
            };
        }
        try {
            stream = Files.newDirectoryStream(root, entry -> {
                String fileName = entry.getFileName().toString();
                return fileName.length() == 1 && !fileName.equals(".") && Files.isDirectory(entry, new LinkOption[0]);
            });
            iterator = stream.iterator();
        }
        catch (IOException e) {
            ElytronMessages.log.debug(e);
            return CloseableIterator.emptyIterator();
        }
        return new CloseableIterator<ModifiableRealmIdentity>(){
            private CloseableIterator<ModifiableRealmIdentity> subIterator;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.subIterator == null) {
                        if (!iterator.hasNext()) {
                            try {
                                this.close();
                            }
                            catch (IOException e) {
                                ElytronMessages.log.debug(e);
                            }
                            return false;
                        }
                        Path path = (Path)iterator.next();
                        this.subIterator = FileSystemSecurityRealm.this.subIterator(path, levels - 1);
                        continue;
                    }
                    if (this.subIterator.hasNext()) {
                        return true;
                    }
                    this.subIterator = null;
                }
            }

            @Override
            public ModifiableRealmIdentity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (ModifiableRealmIdentity)this.subIterator.next();
            }

            @Override
            public void close() throws IOException {
                if (this.subIterator != null) {
                    this.subIterator.close();
                }
                stream.close();
            }
        };
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private IdentitySharedExclusiveLock getRealmIdentityLockForName(String name) {
        IdentitySharedExclusiveLock newRealmIdentityLock;
        IdentitySharedExclusiveLock realmIdentityLock = this.realmIdentityLocks.get(name);
        if (realmIdentityLock == null && (realmIdentityLock = this.realmIdentityLocks.putIfAbsent(name, newRealmIdentityLock = new IdentitySharedExclusiveLock())) == null) {
            realmIdentityLock = newRealmIdentityLock;
        }
        return realmIdentityLock;
    }

    static class AutoCloseableXMLStreamWriterHolder
    implements AutoCloseable {
        private final XMLStreamWriter xmlStreamWriter;

        AutoCloseableXMLStreamWriterHolder(XMLStreamWriter xmlStreamWriter) {
            this.xmlStreamWriter = xmlStreamWriter;
        }

        @Override
        public void close() throws XMLStreamException {
            this.xmlStreamWriter.close();
        }

        public XMLStreamWriter getXmlStreamWriter() {
            return this.xmlStreamWriter;
        }
    }

    static class AutoCloseableXMLStreamReaderHolder
    implements AutoCloseable {
        private final XMLStreamReader xmlStreamReader;

        AutoCloseableXMLStreamReaderHolder(XMLStreamReader xmlStreamReader) {
            this.xmlStreamReader = xmlStreamReader;
        }

        @Override
        public void close() throws XMLStreamException {
            this.xmlStreamReader.close();
        }

        public XMLStreamReader getXmlStreamReader() {
            return this.xmlStreamReader;
        }
    }

    final class LoadedIdentity {
        private final String name;
        private final List<Credential> credentials;
        private final Attributes attributes;

        LoadedIdentity(String name, List<Credential> credentials, Attributes attributes) {
            this.name = name;
            this.credentials = credentials;
            this.attributes = attributes;
        }

        public String getName() {
            return this.name;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        List<Credential> getCredentials() {
            return this.credentials;
        }
    }

    class Identity
    implements ModifiableRealmIdentity {
        private static final String BASE64_FORMAT = "base64";
        private static final String MCF_FORMAT = "crypt";
        private static final String X509_FORMAT = "X.509";
        private final String name;
        private final Path path;
        private IdentitySharedExclusiveLock.IdentityLock lock;

        Identity(String name, Path path, IdentitySharedExclusiveLock.IdentityLock lock) {
            this.name = name;
            this.path = path;
            this.lock = lock;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return new NamePrincipal(this.name);
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            List<Credential> credentials = this.loadCredentials();
            for (Credential credential : credentials) {
                if (!credential.matches(credentialType, algorithmName, parameterSpec)) continue;
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.getCredential(credentialType, algorithmName, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            List<Credential> credentials = this.loadCredentials();
            for (Credential credential : credentials) {
                if (!credential.matches(credentialType, algorithmName, parameterSpec)) continue;
                return (C)((Credential)credentialType.cast(credential.clone()));
            }
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidenceType", evidenceType);
            List<Credential> credentials = this.loadCredentials();
            for (Credential credential : credentials) {
                if (!credential.canVerify(evidenceType, algorithmName)) continue;
                ElytronMessages.log.tracef("FileSystemSecurityRealm - evidence verification SUPPORTED: type = [%s]  algorithm = [%s]  credentials = [%d]", (Object)evidenceType, (Object)algorithmName, (Object)credentials.size());
                return SupportLevel.SUPPORTED;
            }
            ElytronMessages.log.tracef("FileSystemSecurityRealm - evidence verification UNSUPPORTED: type = [%s]  algorithm = [%s]  credentials = [%d]", (Object)evidenceType, (Object)algorithmName, (Object)credentials.size());
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidence", evidence);
            if (ElytronMessages.log.isTraceEnabled()) {
                LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
                ElytronMessages.log.tracef("Trying to authenticate identity %s using FileSystemSecurityRealm", (Object)(loadedIdentity != null ? loadedIdentity.getName() : "null"));
            }
            List<Credential> credentials = this.loadCredentials();
            ElytronMessages.log.tracef("FileSystemSecurityRealm - verification evidence [%s] against [%d] credentials...", (Object)evidence, (Object)credentials.size());
            for (Credential credential : credentials) {
                if (!credential.canVerify(evidence)) continue;
                boolean verified = credential.verify(evidence);
                ElytronMessages.log.tracef("FileSystemSecurityRealm - verification against credential [%s] = %b", (Object)credential, (Object)verified);
                return verified;
            }
            ElytronMessages.log.tracef("FileSystemSecurityRealm - no credential able to verify evidence [%s]", (Object)evidence);
            return false;
        }

        private List<Credential> loadCredentials() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
            return loadedIdentity == null ? Collections.emptyList() : loadedIdentity.getCredentials();
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                return Files.exists(this.path, new LinkOption[0]);
            }
            return AccessController.doPrivileged(() -> Files.exists(this.path, new LinkOption[0]));
        }

        @Override
        public void delete() throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                this.deletePrivileged();
                return;
            }
            try {
                AccessController.doPrivileged(this::deletePrivileged);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof RealmUnavailableException) {
                    throw (RealmUnavailableException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }

        private Void deletePrivileged() throws RealmUnavailableException {
            try {
                Files.delete(this.path);
                return null;
            }
            catch (NoSuchFileException e) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            catch (IOException e) {
                throw ElytronMessages.log.fileSystemRealmDeleteFailed(this.name, e);
            }
        }

        private String tempSuffix() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            char[] array = new char[12];
            for (int i = 0; i < array.length; ++i) {
                int idx = random.nextInt(36);
                array[i] = idx < 26 ? (char)(65 + idx) : (char)(48 + idx - 26);
            }
            return new String(array);
        }

        private Path tempPath() {
            Path parent = this.path.getParent();
            File file = parent.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            return parent.resolve(this.path.getFileName().toString() + '.' + this.tempSuffix());
        }

        @Override
        public void create() throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                this.createPrivileged();
                return;
            }
            try {
                AccessController.doPrivileged(this::createPrivileged);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof RealmUnavailableException) {
                    throw (RealmUnavailableException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }

        private Void createPrivileged() throws RealmUnavailableException {
            Path tempPath;
            while (true) {
                tempPath = this.tempPath();
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(tempPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.DSYNC));){
                    try (AutoCloseableXMLStreamWriterHolder holder = new AutoCloseableXMLStreamWriterHolder(xmlOutputFactory.createXMLStreamWriter(outputStream));){
                        XMLStreamWriter streamWriter = holder.getXmlStreamWriter();
                        streamWriter.writeStartDocument();
                        streamWriter.writeCharacters("\n");
                        streamWriter.writeStartElement("identity");
                        streamWriter.writeDefaultNamespace(FileSystemSecurityRealm.ELYTRON_1_0);
                        streamWriter.writeEndElement();
                        streamWriter.writeEndDocument();
                    }
                    catch (XMLStreamException e) {
                        throw ElytronMessages.log.fileSystemRealmFailedToWrite(tempPath, this.name, e);
                    }
                }
                catch (FileAlreadyExistsException ignored) {
                    continue;
                }
                catch (IOException e) {
                    throw ElytronMessages.log.fileSystemRealmFailedToOpen(tempPath, this.name, e);
                }
                break;
            }
            try {
                Files.createLink(this.path, tempPath);
            }
            catch (FileAlreadyExistsException e) {
                try {
                    Files.delete(tempPath);
                }
                catch (IOException e2) {
                    e.addSuppressed(e2);
                }
                throw ElytronMessages.log.fileSystemRealmAlreadyExists(this.name, e);
            }
            catch (IOException e) {
                throw ElytronMessages.log.fileSystemRealmFailedToWrite(tempPath, this.name, e);
            }
            try {
                Files.delete(tempPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void setCredentials(Collection<? extends Credential> credentials) throws RealmUnavailableException {
            Assert.checkNotNullParam("credential", credentials);
            LoadedIdentity loadedIdentity = this.loadIdentity(false, false);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            LoadedIdentity newIdentity = new LoadedIdentity(this.name, new ArrayList<Credential>(credentials), loadedIdentity.getAttributes());
            this.replaceIdentity(newIdentity);
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            Assert.checkNotNullParam("attributes", attributes);
            LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            LoadedIdentity newIdentity = new LoadedIdentity(this.name, loadedIdentity.getCredentials(), attributes);
            this.replaceIdentity(newIdentity);
        }

        @Override
        public Attributes getAttributes() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(true, false);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            return loadedIdentity.getAttributes().asReadOnly();
        }

        private void replaceIdentity(LoadedIdentity newIdentity) throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                this.replaceIdentityPrivileged(newIdentity);
                return;
            }
            try {
                AccessController.doPrivileged(() -> this.replaceIdentityPrivileged(newIdentity));
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof RealmUnavailableException) {
                    throw (RealmUnavailableException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }

        /*
         * Exception decompiling
         */
        private Void replaceIdentityPrivileged(LoadedIdentity newIdentity) throws RealmUnavailableException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [38[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void writeIdentity(XMLStreamWriter streamWriter, LoadedIdentity newIdentity) throws XMLStreamException, InvalidKeySpecException, NoSuchAlgorithmException, CertificateEncodingException {
            Iterator<Attributes.Entry> entryIter;
            streamWriter.writeStartDocument();
            streamWriter.writeCharacters("\n");
            streamWriter.writeStartElement("identity");
            streamWriter.writeDefaultNamespace(FileSystemSecurityRealm.ELYTRON_1_0);
            if (newIdentity.getCredentials().size() > 0) {
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeStartElement("credentials");
                for (Credential credential : newIdentity.getCredentials()) {
                    String passwordString;
                    String format;
                    streamWriter.writeCharacters("\n        ");
                    if (!(credential instanceof PasswordCredential)) continue;
                    Password password = ((PasswordCredential)credential).getPassword();
                    if (password instanceof OneTimePassword) {
                        OneTimePassword otp = (OneTimePassword)password;
                        streamWriter.writeStartElement("otp");
                        streamWriter.writeAttribute("algorithm", otp.getAlgorithm());
                        streamWriter.writeAttribute("hash", ByteIterator.ofBytes(otp.getHash()).base64Encode().drainToString());
                        streamWriter.writeAttribute("seed", ByteIterator.ofBytes(otp.getSeed()).base64Encode().drainToString());
                        streamWriter.writeAttribute("sequence", Integer.toString(otp.getSequenceNumber()));
                        streamWriter.writeEndElement();
                        continue;
                    }
                    streamWriter.writeStartElement("password");
                    String algorithm = password.getAlgorithm();
                    byte[] encoded = BasicPasswordSpecEncoding.encode(password);
                    if (encoded != null) {
                        format = BASE64_FORMAT;
                        passwordString = ByteIterator.ofBytes(encoded).base64Encode().drainToString();
                    } else {
                        format = MCF_FORMAT;
                        passwordString = ModularCrypt.encodeAsString(password);
                    }
                    streamWriter.writeAttribute("algorithm", algorithm);
                    streamWriter.writeAttribute("format", format);
                    streamWriter.writeCharacters(passwordString);
                    streamWriter.writeEndElement();
                }
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeEndElement();
            }
            if ((entryIter = newIdentity.getAttributes().entries().iterator()).hasNext()) {
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeStartElement("attributes");
                do {
                    Attributes.Entry entry = entryIter.next();
                    for (String value : entry) {
                        streamWriter.writeCharacters("\n        ");
                        streamWriter.writeStartElement("attribute");
                        streamWriter.writeAttribute("name", entry.getKey());
                        streamWriter.writeAttribute("value", value);
                        streamWriter.writeEndElement();
                    }
                } while (entryIter.hasNext());
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
            streamWriter.writeEndDocument();
        }

        @Override
        public void dispose() {
            IdentitySharedExclusiveLock.IdentityLock identityLock = this.lock;
            this.lock = null;
            if (identityLock != null) {
                identityLock.release();
            }
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(true, false);
            return loadedIdentity == null ? AuthorizationIdentity.EMPTY : AuthorizationIdentity.basicIdentity(loadedIdentity.getAttributes());
        }

        private LoadedIdentity loadIdentity(boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                return this.loadIdentityPrivileged(skipCredentials, skipAttributes);
            }
            try {
                return AccessController.doPrivileged(() -> this.loadIdentityPrivileged(skipCredentials, skipAttributes));
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof RealmUnavailableException) {
                    throw (RealmUnavailableException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }

        /*
         * Exception decompiling
         */
        private LoadedIdentity loadIdentityPrivileged(boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private LoadedIdentity parseIdentity(XMLStreamReader streamReader, boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException, XMLStreamException {
            int tag = streamReader.nextTag();
            if (tag != 1 || !FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI()) || !"identity".equals(streamReader.getLocalName())) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            return this.parseIdentityContents(streamReader, skipCredentials, skipAttributes);
        }

        private LoadedIdentity parseIdentityContents(XMLStreamReader streamReader, boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            List<Credential> credentials = Collections.emptyList();
            Attributes attributes = Attributes.EMPTY;
            boolean gotCredentials = false;
            boolean gotAttributes = false;
            while (true) {
                if (streamReader.isEndElement()) {
                    if (attributes == Attributes.EMPTY && !skipAttributes) {
                        attributes = new MapAttributes();
                    }
                    return new LoadedIdentity(this.name, credentials, attributes);
                }
                if (!FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if (!gotCredentials && "credentials".equals(streamReader.getLocalName())) {
                    gotCredentials = true;
                    if (skipCredentials) {
                        this.consumeContent(streamReader);
                    } else {
                        credentials = this.parseCredentials(streamReader);
                    }
                } else if (!gotAttributes && "attributes".equals(streamReader.getLocalName())) {
                    gotAttributes = true;
                    if (skipAttributes) {
                        this.consumeContent(streamReader);
                    } else {
                        attributes = this.parseAttributes(streamReader);
                    }
                }
                streamReader.nextTag();
            }
        }

        private List<Credential> parseCredentials(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            if (streamReader.nextTag() == 2) {
                return Collections.emptyList();
            }
            ArrayList<Credential> credentials = new ArrayList<Credential>();
            do {
                if (!FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if ("password".equals(streamReader.getLocalName())) {
                    this.parsePassword(credentials, streamReader);
                    continue;
                }
                if ("public-key".equals(streamReader.getLocalName())) {
                    this.parsePublicKey(credentials, streamReader);
                    continue;
                }
                if ("certificate".equals(streamReader.getLocalName())) {
                    this.parseCertificate(credentials, streamReader);
                    continue;
                }
                if ("otp".equals(streamReader.getLocalName())) {
                    this.parseOtp(credentials, streamReader);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            } while (streamReader.nextTag() != 2);
            return credentials;
        }

        private void parseCredential(XMLStreamReader streamReader, CredentialParseFunction function) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            String name = null;
            String algorithm = null;
            String format = null;
            for (int i = 0; i < attributeCount; ++i) {
                String namespace = streamReader.getAttributeNamespace(i);
                if (namespace != null && !namespace.equals("")) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
                }
                String localName = streamReader.getAttributeLocalName(i);
                if ("name".equals(localName)) {
                    name = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("algorithm".equals(localName)) {
                    algorithm = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("format".equals(localName)) {
                    format = streamReader.getAttributeValue(i);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
            }
            String text = streamReader.getElementText().trim();
            function.parseCredential(algorithm, format, text);
        }

        private void parseCertificate(List<Credential> credentials, XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            this.parseCredential(streamReader, (algorithm, format, text) -> {
                if (algorithm == null) {
                    algorithm = X509_FORMAT;
                }
                if (format == null) {
                    format = X509_FORMAT;
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance(algorithm);
                    credentials.add(new X509CertificateChainPublicCredential((X509Certificate)certificateFactory.generateCertificate(CodePointIterator.ofString(text).base64Decode().asInputStream())));
                }
                catch (ClassCastException | CertificateException e) {
                    throw ElytronMessages.log.fileSystemRealmCertificateReadError(format, this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
            });
        }

        private void parsePublicKey(List<Credential> credentials, XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            this.parseCredential(streamReader, (algorithm, format, text) -> {
                if (algorithm == null) {
                    throw ElytronMessages.log.fileSystemRealmMissingAttribute("algorithm", this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if (format == null) {
                    format = X509_FORMAT;
                } else if (!X509_FORMAT.equals(format)) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                    credentials.add(new PublicKeyCredential(keyFactory.generatePublic(new PKCS8EncodedKeySpec(CodePointIterator.ofString(text).base64Decode().drain()))));
                }
                catch (NoSuchAlgorithmException e) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyAlgorithm(format, this.path, streamReader.getLocation().getLineNumber(), this.name, e);
                }
                catch (InvalidKeySpecException e) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
            });
        }

        private void parsePassword(List<Credential> credentials, XMLStreamReader streamReader) throws XMLStreamException, RealmUnavailableException {
            this.parseCredential(streamReader, (algorithm, format, text) -> {
                block5: {
                    try {
                        if (BASE64_FORMAT.equals(format)) {
                            byte[] passwordBytes = CodePointIterator.ofChars(text.toCharArray()).base64Decode().drain();
                            PasswordFactory passwordFactory = PasswordFactory.getInstance(algorithm);
                            PasswordSpec passwordSpec = BasicPasswordSpecEncoding.decode(passwordBytes);
                            if (passwordSpec != null) {
                                credentials.add(new PasswordCredential(passwordFactory.generatePassword(passwordSpec)));
                                break block5;
                            }
                            throw ElytronMessages.log.fileSystemRealmInvalidPasswordAlgorithm(algorithm, this.path, streamReader.getLocation().getLineNumber(), this.name);
                        }
                        if (MCF_FORMAT.equals(format)) {
                            credentials.add(new PasswordCredential(ModularCrypt.decode(text)));
                            break block5;
                        }
                        throw ElytronMessages.log.fileSystemRealmInvalidPasswordFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.name);
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                    }
                }
            });
        }

        private void parseOtp(List<Credential> credentials, XMLStreamReader streamReader) throws XMLStreamException, RealmUnavailableException {
            String name = null;
            String algorithm = null;
            byte[] hash = null;
            byte[] seed = null;
            int sequenceNumber = 0;
            int attributeCount = streamReader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                String namespace = streamReader.getAttributeNamespace(i);
                if (namespace != null && !namespace.equals("")) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
                }
                String localName = streamReader.getAttributeLocalName(i);
                if ("name".equals(localName)) {
                    name = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("algorithm".equals(localName)) {
                    algorithm = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("hash".equals(localName)) {
                    hash = CodePointIterator.ofString(streamReader.getAttributeValue(i)).base64Decode().drain();
                    continue;
                }
                if ("seed".equals(localName)) {
                    seed = CodePointIterator.ofString(streamReader.getAttributeValue(i)).base64Decode().drain();
                    continue;
                }
                if ("sequence".equals(localName)) {
                    sequenceNumber = Integer.parseInt(streamReader.getAttributeValue(i));
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
            }
            if (streamReader.nextTag() != 2) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
            }
            try {
                PasswordFactory passwordFactory = PasswordFactory.getInstance(algorithm);
                Password password = passwordFactory.generatePassword(new OneTimePasswordSpec(hash, seed, sequenceNumber));
                credentials.add(new PasswordCredential(password));
            }
            catch (InvalidKeySpecException e) {
                throw ElytronMessages.log.fileSystemRealmInvalidOtpDefinition(this.path, streamReader.getLocation().getLineNumber(), name, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw ElytronMessages.log.fileSystemRealmInvalidOtpAlgorithm(algorithm, this.path, streamReader.getLocation().getLineNumber(), name, e);
            }
        }

        private Attributes parseAttributes(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            int tag = streamReader.nextTag();
            if (tag == 2) {
                return Attributes.EMPTY;
            }
            MapAttributes attributes = new MapAttributes();
            do {
                if (!FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if (!"attribute".equals(streamReader.getLocalName())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                this.parseAttribute(streamReader, attributes);
            } while (streamReader.nextTag() == 1);
            return attributes;
        }

        private void parseAttribute(XMLStreamReader streamReader, Attributes attributes) throws XMLStreamException, RealmUnavailableException {
            String name = null;
            String value = null;
            int attributeCount = streamReader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                String namespace = streamReader.getAttributeNamespace(i);
                if (namespace != null && !namespace.equals("")) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if ("name".equals(streamReader.getAttributeLocalName(i))) {
                    name = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("value".equals(streamReader.getAttributeLocalName(i))) {
                    value = streamReader.getAttributeValue(i);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            if (name == null) {
                throw ElytronMessages.log.fileSystemRealmMissingAttribute("name", this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            if (value == null) {
                throw ElytronMessages.log.fileSystemRealmMissingAttribute("value", this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            attributes.addLast(name, value);
            if (streamReader.nextTag() != 2) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
        }

        private void consumeContent(XMLStreamReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        this.consumeContent(reader);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        }
    }

    @FunctionalInterface
    static interface CredentialParseFunction {
        public void parseCredential(String var1, String var2, String var3) throws RealmUnavailableException, XMLStreamException;
    }
}

