/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.logging.Logger;
import org.jboss.threads.ArrayQueue;
import org.jboss.threads.BlockingExecutorService;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.EventListener;
import org.jboss.threads.ExecutionInterruptedException;
import org.jboss.threads.ExecutionTimedOutException;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.ShutdownListenable;
import org.jboss.threads.SimpleShutdownListenable;
import org.jboss.threads.StoppedExecutorException;
import org.jboss.threads.ThreadCreationException;
import org.jboss.threads.management.BoundedQueueThreadPoolExecutorMBean;

public final class QueueExecutor
extends AbstractExecutorService
implements BlockingExecutorService,
BoundedQueueThreadPoolExecutorMBean,
ShutdownListenable {
    private static final Logger log = Logger.getLogger("org.jboss.threads.executor");
    private final SimpleShutdownListenable shutdownListenable = new SimpleShutdownListenable();
    private final Lock lock = new ReentrantLock();
    private final Condition enqueueCondition = this.lock.newCondition();
    private final Condition removeCondition = this.lock.newCondition();
    private final Condition threadExitCondition = this.lock.newCondition();
    private final ThreadFactory threadFactory;
    private final DirectExecutor taskExecutor;
    private int coreThreads;
    private int maxThreads;
    private int largestPoolSize;
    private int rejectCount;
    private boolean allowCoreThreadTimeout;
    private long keepAliveTime;
    private TimeUnit keepAliveTimeUnit;
    private boolean blocking;
    private Executor handoffExecutor;
    private int threadCount;
    private Set<Thread> workers = new HashSet<Thread>();
    private boolean stop;
    private Queue<Runnable> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueExecutor(int coreThreads, int maxThreads, long keepAliveTime, TimeUnit keepAliveTimeUnit, Queue<Runnable> queue, ThreadFactory threadFactory, boolean blocking, Executor handoffExecutor, DirectExecutor taskExecutor) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is null");
        }
        if (queue == null) {
            throw new NullPointerException("queue is null");
        }
        if (keepAliveTimeUnit == null) {
            throw new NullPointerException("keepAliveTimeUnit is null");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            this.threadFactory = threadFactory;
            this.keepAliveTime = keepAliveTime;
            this.keepAliveTimeUnit = keepAliveTimeUnit;
            this.coreThreads = coreThreads;
            this.maxThreads = maxThreads > coreThreads ? maxThreads : coreThreads;
            this.queue = queue;
            this.blocking = blocking;
            this.handoffExecutor = handoffExecutor;
            this.taskExecutor = taskExecutor;
        }
        finally {
            lock.unlock();
        }
    }

    public QueueExecutor(int coreThreads, int maxThreads, long keepAliveTime, TimeUnit keepAliveTimeUnit, Queue<Runnable> queue, ThreadFactory threadFactory, boolean blocking, Executor handoffExecutor) {
        this(coreThreads, maxThreads, keepAliveTime, keepAliveTimeUnit, queue, threadFactory, blocking, handoffExecutor, JBossExecutors.directExecutor());
    }

    public QueueExecutor(int coreThreads, int maxThreads, long keepAliveTime, TimeUnit keepAliveTimeUnit, int queueLength, ThreadFactory threadFactory, boolean blocking, Executor handoffExecutor) {
        this(coreThreads, maxThreads, keepAliveTime, keepAliveTimeUnit, new ArrayQueue<Runnable>(queueLength), threadFactory, blocking, handoffExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) throws RejectedExecutionException {
        Executor executor;
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            while (true) {
                if (this.stop) {
                    throw new StoppedExecutorException("Executor is stopped");
                }
                int count = this.threadCount;
                if (count < this.coreThreads) {
                    this.startNewThread(task);
                    this.threadCount = count + 1;
                    return;
                }
                Queue<Runnable> queue = this.queue;
                if (queue.offer(task)) {
                    this.enqueueCondition.signal();
                    return;
                }
                if (count < this.maxThreads) {
                    this.startNewThread(task);
                    this.threadCount = count + 1;
                    return;
                }
                if (!this.blocking) break;
                try {
                    this.removeCondition.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ExecutionInterruptedException("Thread interrupted");
                }
            }
            ++this.rejectCount;
            executor = this.handoffExecutor;
        }
        finally {
            lock.unlock();
        }
        if (executor == null) {
            throw new RejectedExecutionException();
        }
        executor.execute(task);
    }

    @Override
    public void executeBlocking(Runnable task) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            while (true) {
                if (this.stop) {
                    throw new StoppedExecutorException("Executor is stopped");
                }
                int count = this.threadCount;
                if (count < this.coreThreads) {
                    this.startNewThread(task);
                    this.threadCount = count + 1;
                    return;
                }
                Queue<Runnable> queue = this.queue;
                if (queue.offer(task)) {
                    this.enqueueCondition.signal();
                    return;
                }
                if (count < this.maxThreads) {
                    this.startNewThread(task);
                    this.threadCount = count + 1;
                    return;
                }
                this.removeCondition.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void executeBlocking(Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        long now = System.currentTimeMillis();
        long deadline = now + unit.toMillis(timeout);
        if (deadline < 0L) {
            this.executeBlocking(task);
            return;
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            while (true) {
                if (this.stop) {
                    throw new StoppedExecutorException("Executor is stopped");
                }
                int count = this.threadCount;
                if (count < this.coreThreads) {
                    this.startNewThread(task);
                    this.threadCount = count + 1;
                    return;
                }
                Queue<Runnable> queue = this.queue;
                if (queue.offer(task)) {
                    this.enqueueCondition.signal();
                    return;
                }
                if (count < this.maxThreads) {
                    this.startNewThread(task);
                    this.threadCount = count + 1;
                    return;
                }
                long remaining = deadline - now;
                if (remaining <= 0L) {
                    throw new ExecutionTimedOutException();
                }
                this.removeCondition.await(remaining, TimeUnit.MILLISECONDS);
                now = System.currentTimeMillis();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNonBlocking(Runnable task) throws RejectedExecutionException {
        Executor executor;
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            if (this.stop) {
                throw new StoppedExecutorException("Executor is stopped");
            }
            int count = this.threadCount;
            if (count < this.coreThreads) {
                this.startNewThread(task);
                this.threadCount = count + 1;
                return;
            }
            Queue<Runnable> queue = this.queue;
            if (queue.offer(task)) {
                this.enqueueCondition.signal();
                return;
            }
            if (count < this.maxThreads) {
                this.startNewThread(task);
                this.threadCount = count + 1;
                return;
            }
            ++this.rejectCount;
            executor = this.handoffExecutor;
        }
        finally {
            lock.unlock();
        }
        if (executor != null) {
            executor.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        boolean callShutdownListener = false;
        Lock lock = this.lock;
        lock.lock();
        try {
            if (!this.stop) {
                this.stop = true;
                this.removeCondition.signalAll();
                this.enqueueCondition.signalAll();
                if (this.workers.isEmpty()) {
                    callShutdownListener = true;
                } else {
                    for (Thread worker : this.workers) {
                        worker.interrupt();
                    }
                }
            }
        }
        finally {
            lock.unlock();
            if (callShutdownListener) {
                this.shutdownListenable.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        boolean callShutdownListener = false;
        Lock lock = this.lock;
        lock.lock();
        try {
            this.stop = true;
            this.removeCondition.signalAll();
            this.enqueueCondition.signalAll();
            if (this.workers.isEmpty()) {
                callShutdownListener = true;
            } else {
                for (Thread worker : this.workers) {
                    worker.interrupt();
                }
            }
            Queue<Runnable> queue = this.queue;
            ArrayList<Runnable> list = new ArrayList<Runnable>(queue);
            queue.clear();
            ArrayList<Runnable> arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
            if (callShutdownListener) {
                this.shutdownListenable.shutdown();
            }
        }
    }

    @Override
    public boolean isShutdown() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.stop;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isTerminated() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.stop && this.threadCount == 0;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Lock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (this.workers.contains(Thread.currentThread())) {
                throw new IllegalStateException("Cannot await termination of a thread pool from one of its threads");
            }
            long start = System.currentTimeMillis();
            long elapsed = 0L;
            while (!this.stop && this.threadCount > 0) {
                long remaining = timeout - elapsed;
                if (remaining <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                this.threadExitCondition.await(remaining, unit);
                elapsed = unit.convert(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isAllowCoreThreadTimeout() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.allowCoreThreadTimeout;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void setAllowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.allowCoreThreadTimeout = allowCoreThreadTimeout;
            if (allowCoreThreadTimeout) {
                this.enqueueCondition.signalAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getCoreThreads() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.coreThreads;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCoreThreads(int coreThreads) {
        Lock lock = this.lock;
        lock.lock();
        try {
            int oldLimit = this.coreThreads;
            if (this.maxThreads < coreThreads) {
                this.setMaxThreads(coreThreads);
            } else if (oldLimit < coreThreads) {
                this.removeCondition.signalAll();
            } else if (oldLimit > coreThreads) {
                this.enqueueCondition.signalAll();
            } else {
                return;
            }
            this.coreThreads = coreThreads;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getMaxThreads() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.maxThreads;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxThreads(int maxThreads) {
        Lock lock = this.lock;
        lock.lock();
        try {
            int oldLimit = this.maxThreads;
            if (maxThreads < this.coreThreads) {
                this.setCoreThreads(maxThreads);
            } else if (oldLimit < maxThreads) {
                this.removeCondition.signalAll();
            } else if (oldLimit > maxThreads) {
                this.enqueueCondition.signalAll();
            } else {
                return;
            }
            this.maxThreads = maxThreads;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getKeepAliveTime() {
        Lock lock = this.lock;
        lock.lock();
        try {
            long l = this.keepAliveTime;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepAliveTime(long keepAliveTime, TimeUnit keepAliveTimeUnit) {
        if (keepAliveTimeUnit == null) {
            throw new NullPointerException("keepAliveTimeUnit is null");
        }
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("keepAliveTime is less than zero");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            this.keepAliveTime = keepAliveTimeUnit.convert(keepAliveTime, TimeUnit.MILLISECONDS);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void setKeepAliveTime(long milliseconds) {
        this.setKeepAliveTime(milliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isBlocking() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.blocking;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void setBlocking(boolean blocking) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.blocking = blocking;
        }
        finally {
            lock.unlock();
        }
    }

    public Executor getHandoffExecutor() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Executor executor = this.handoffExecutor;
            return executor;
        }
        finally {
            lock.unlock();
        }
    }

    public void setHandoffExecutor(Executor handoffExecutor) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.handoffExecutor = handoffExecutor;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <A> void addShutdownListener(EventListener<A> shutdownListener, A attachment) {
        this.shutdownListenable.addShutdownListener(shutdownListener, attachment);
    }

    private void startNewThread(Runnable task) {
        Thread thread = this.threadFactory.newThread(new Worker(task));
        if (thread == null) {
            throw new ThreadCreationException();
        }
        this.workers.add(thread);
        int size = this.workers.size();
        if (size > this.largestPoolSize) {
            this.largestPoolSize = size;
        }
        thread.start();
    }

    private Runnable pollTask() {
        Runnable task = this.queue.poll();
        if (task != null) {
            this.removeCondition.signal();
            return task;
        }
        if (--this.threadCount == 0) {
            this.threadExitCondition.signalAll();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Runnable takeTask() {
        Condition removeCondition = this.removeCondition;
        Runnable task = this.queue.poll();
        if (task != null) {
            removeCondition.signal();
            return task;
        }
        Condition enqueueCondition = this.enqueueCondition;
        long start = System.currentTimeMillis();
        boolean intr = Thread.interrupted();
        try {
            long elapsed = 0L;
            while (true) {
                Runnable runnable;
                int threadCount = this.threadCount;
                int coreThreadLimit = this.coreThreads;
                boolean allowCoreThreadTimeout = this.allowCoreThreadTimeout;
                if (this.stop || threadCount > this.maxThreads) {
                    runnable = this.pollTask();
                    return runnable;
                }
                if (allowCoreThreadTimeout || threadCount > coreThreadLimit) {
                    long time = this.keepAliveTime;
                    TimeUnit timeUnit = this.keepAliveTimeUnit;
                    long remaining = time - timeUnit.convert(elapsed, TimeUnit.MILLISECONDS);
                    if (remaining <= 0L) {
                        Runnable runnable2 = this.pollTask();
                        return runnable2;
                    }
                    try {
                        enqueueCondition.await(remaining, timeUnit);
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                } else {
                    try {
                        enqueueCondition.await();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
                task = this.queue.poll();
                if (task != null) {
                    removeCondition.signal();
                    runnable = task;
                    return runnable;
                }
                elapsed = System.currentTimeMillis() - start;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public int getCurrentThreadCount() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.workers.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getLargestThreadCount() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getRejectedCount() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.rejectCount;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    private void runTask(Runnable task) {
        if (task != null) {
            try {
                this.taskExecutor.execute(task);
            }
            catch (Throwable t) {
                log.errorf(t, "Task execution failed for task %s", (Object)task);
            }
        }
    }

    static /* synthetic */ Lock access$000(QueueExecutor x0) {
        return x0.lock;
    }

    static /* synthetic */ void access$100(QueueExecutor x0, Runnable x1) {
        x0.runTask(x1);
    }

    static /* synthetic */ boolean access$200(QueueExecutor x0) {
        return x0.stop;
    }

    static /* synthetic */ Runnable access$300(QueueExecutor x0) {
        return x0.pollTask();
    }

    static /* synthetic */ Runnable access$400(QueueExecutor x0) {
        return x0.takeTask();
    }

    static /* synthetic */ Set access$500(QueueExecutor x0) {
        return x0.workers;
    }

    static /* synthetic */ SimpleShutdownListenable access$600(QueueExecutor x0) {
        return x0.shutdownListenable;
    }

    private class Worker
    implements Runnable {
        private volatile Runnable first;

        public Worker(Runnable command) {
            this.first = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block24: {
                lock = QueueExecutor.access$000(QueueExecutor.this);
                try {
                    task = this.first;
                    this.first = null;
                    QueueExecutor.access$100(QueueExecutor.this, task);
lbl6:
                    // 2 sources

                    while (true) {
                        task = null;
                        lock.lock();
                        try {
                            if (!QueueExecutor.access$200(QueueExecutor.this)) ** GOTO lbl51
                            task = QueueExecutor.access$300(QueueExecutor.this);
                            if (task == null) {
                                lock.unlock();
                                last = false;
                                lock.lock();
                                break;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var6_7) {
                            lock.unlock();
                            throw var6_7;
                        }
                        break;
                    }
                }
                catch (Throwable var7_8) {
                    last = false;
                    lock.lock();
                    try {
                        QueueExecutor.access$500(QueueExecutor.this).remove(Thread.currentThread());
                        last = QueueExecutor.access$200(QueueExecutor.this) != false && QueueExecutor.access$500(QueueExecutor.this).isEmpty() != false;
                    }
                    finally {
                        lock.unlock();
                    }
                    if (last) {
                        QueueExecutor.access$600(QueueExecutor.this).shutdown();
                    }
                    throw var7_8;
                }
                try {
                    QueueExecutor.access$500(QueueExecutor.this).remove(Thread.currentThread());
                    last = QueueExecutor.access$200(QueueExecutor.this) != false && QueueExecutor.access$500(QueueExecutor.this).isEmpty() != false;
                }
                finally {
                    lock.unlock();
                }
                if (last) {
                    QueueExecutor.access$600(QueueExecutor.this).shutdown();
                }
                return;
lbl-1000:
                // 1 sources

                {
                    Thread.currentThread().interrupt();
                    break block24;
lbl51:
                    // 1 sources

                    task = QueueExecutor.access$400(QueueExecutor.this);
                    if (task != null) break block24;
                    lock.unlock();
                    last = false;
                    lock.lock();
                }
                try {
                    QueueExecutor.access$500(QueueExecutor.this).remove(Thread.currentThread());
                    last = QueueExecutor.access$200(QueueExecutor.this) != false && QueueExecutor.access$500(QueueExecutor.this).isEmpty() != false;
                }
                finally {
                    lock.unlock();
                }
                if (last) {
                    QueueExecutor.access$600(QueueExecutor.this).shutdown();
                }
                return;
            }
            lock.unlock();
            QueueExecutor.access$100(QueueExecutor.this, task);
            Thread.interrupted();
            ** while (true)
        }
    }
}

