/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.config.ErrorManagerConfiguration;
import org.jboss.logmanager.config.FilterConfiguration;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.PojoConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.config.ValueExpression;

public final class PropertyConfigurator
implements Configurator {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");
    private static final String NEW_LINE = System.lineSeparator();
    private final LogContextConfiguration config;

    public PropertyConfigurator() {
        this(LogContext.getSystemLogContext());
    }

    public PropertyConfigurator(LogContext context) {
        this.config = LogContextConfiguration.Factory.create(context);
    }

    public LogContextConfiguration getLogContextConfiguration() {
        return this.config;
    }

    @Override
    public void configure(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            inputStream.close();
        }
        finally {
            PropertyConfigurator.safeClose(inputStream);
        }
        this.configure(properties);
    }

    public void writeConfiguration(OutputStream outputStream) throws IOException {
        this.writeConfiguration(outputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfiguration(OutputStream outputStream, boolean writeExpressions) throws IOException {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            try {
                HashSet<String> implicitHandlers = new HashSet<String>();
                HashSet<String> implicitFilters = new HashSet<String>();
                HashSet<String> implicitFormatters = new HashSet<String>();
                HashSet<String> implicitErrorManagers = new HashSet<String>();
                List<String> loggerNames = this.config.getLoggerNames();
                PropertyConfigurator.writePropertyComment(out, "Additional loggers to configure (the root logger is always configured)");
                PropertyConfigurator.writeProperty(out, "loggers", PropertyConfigurator.toCsvString(loggerNames));
                LoggerConfiguration rootLogger = this.config.getLoggerConfiguration("");
                this.writeLoggerConfiguration(out, rootLogger, implicitHandlers, implicitFilters, writeExpressions);
                loggerNames.remove("");
                for (String loggerName : loggerNames) {
                    this.writeLoggerConfiguration(out, this.config.getLoggerConfiguration(loggerName), implicitHandlers, implicitFilters, writeExpressions);
                }
                List<String> allHandlerNames = this.config.getHandlerNames();
                ArrayList<String> explicitHandlerNames = new ArrayList<String>(allHandlerNames);
                explicitHandlerNames.removeAll(implicitHandlers);
                if (!explicitHandlerNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional handlers to configure");
                    PropertyConfigurator.writeProperty(out, "handlers", PropertyConfigurator.toCsvString(explicitHandlerNames));
                    out.write(NEW_LINE);
                }
                for (String handlerName : allHandlerNames) {
                    this.writeHandlerConfiguration(out, this.config.getHandlerConfiguration(handlerName), implicitHandlers, implicitFilters, implicitFormatters, implicitErrorManagers, writeExpressions);
                }
                List<String> allFilterNames = this.config.getFilterNames();
                ArrayList<String> explicitFilterNames = new ArrayList<String>(allFilterNames);
                explicitFilterNames.removeAll(implicitFilters);
                if (!explicitFilterNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional filters to configure");
                    PropertyConfigurator.writeProperty(out, "filters", PropertyConfigurator.toCsvString(explicitFilterNames));
                    out.write(NEW_LINE);
                }
                for (String filterName : allFilterNames) {
                    PropertyConfigurator.writeFilterConfiguration(out, this.config.getFilterConfiguration(filterName), writeExpressions);
                }
                List<String> allFormatterNames = this.config.getFormatterNames();
                ArrayList<String> explicitFormatterNames = new ArrayList<String>(allFormatterNames);
                explicitFormatterNames.removeAll(implicitFormatters);
                if (!explicitFormatterNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional formatters to configure");
                    PropertyConfigurator.writeProperty(out, "formatters", PropertyConfigurator.toCsvString(explicitFormatterNames));
                    out.write(NEW_LINE);
                }
                for (String formatterName : allFormatterNames) {
                    PropertyConfigurator.writeFormatterConfiguration(out, this.config.getFormatterConfiguration(formatterName), writeExpressions);
                }
                List<String> allErrorManagerNames = this.config.getErrorManagerNames();
                ArrayList<String> explicitErrorManagerNames = new ArrayList<String>(allErrorManagerNames);
                explicitErrorManagerNames.removeAll(implicitErrorManagers);
                if (!explicitErrorManagerNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional errorManagers to configure");
                    PropertyConfigurator.writeProperty(out, "errorManagers", PropertyConfigurator.toCsvString(explicitErrorManagerNames));
                    out.write(NEW_LINE);
                }
                for (String errorManagerName : allErrorManagerNames) {
                    PropertyConfigurator.writeErrorManagerConfiguration(out, this.config.getErrorManagerConfiguration(errorManagerName), writeExpressions);
                }
                List<String> pojoNames = this.config.getPojoNames();
                if (!pojoNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "POJOs to configure");
                    PropertyConfigurator.writeProperty(out, "pojos", PropertyConfigurator.toCsvString(pojoNames));
                    for (String pojoName : pojoNames) {
                        PropertyConfigurator.writePojoConfiguration(out, this.config.getPojoConfiguration(pojoName), writeExpressions);
                    }
                }
                out.flush();
                out.close();
            }
            finally {
                PropertyConfigurator.safeClose(out);
            }
            outputStream.close();
        }
        finally {
            PropertyConfigurator.safeClose(outputStream);
        }
    }

    private void writeLoggerConfiguration(Writer out, LoggerConfiguration logger2, Set<String> implicitHandlers, Set<String> implicitFilters, boolean writeExpressions) throws IOException {
        if (logger2 != null) {
            String useParentHandlersValue;
            String filterName;
            String level;
            out.write(NEW_LINE);
            String name = logger2.getName();
            String prefix = name.isEmpty() ? "logger." : "logger." + name + ".";
            String string = level = writeExpressions ? logger2.getLevelValueExpression().getValue() : logger2.getLevel();
            if (level != null) {
                PropertyConfigurator.writeProperty(out, prefix, "level", level);
            }
            String string2 = filterName = writeExpressions ? logger2.getFilterValueExpression().getValue() : logger2.getFilter();
            if (filterName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "filter", filterName);
                implicitFilters.add(logger2.getFilter());
            }
            Boolean useParentHandlers = logger2.getUseParentHandlers();
            String string3 = writeExpressions ? logger2.getUseParentHandlersValueExpression().getValue() : (useParentHandlersValue = useParentHandlers == null ? null : useParentHandlers.toString());
            if (useParentHandlersValue != null) {
                PropertyConfigurator.writeProperty(out, prefix, "useParentHandlers", useParentHandlersValue);
            }
            ArrayList<String> handlerNames = new ArrayList<String>();
            for (String handlerName : logger2.getHandlerNames()) {
                if (this.config.getHandlerNames().contains(handlerName)) {
                    implicitHandlers.add(handlerName);
                    handlerNames.add(handlerName);
                    continue;
                }
                PropertyConfigurator.printError("Handler %s is not defined and will not be written to the configuration for logger %s%n", handlerName, name.isEmpty() ? "ROOT" : name);
            }
            if (!handlerNames.isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "handlers", PropertyConfigurator.toCsvString(handlerNames));
            }
        }
    }

    private void writeHandlerConfiguration(Writer out, HandlerConfiguration handler, Set<String> implicitHandlers, Set<String> implicitFilters, Set<String> implicitFormatters, Set<String> implicitErrorManagers, boolean writeExpressions) throws IOException {
        if (handler != null) {
            List<String> postConfigurationMethods;
            String errorManagerName;
            String formatterName;
            String filter;
            String encoding;
            String level;
            out.write(NEW_LINE);
            String name = handler.getName();
            String prefix = "handler." + name + ".";
            String className = handler.getClassName();
            PropertyConfigurator.writeProperty(out, "handler.", name, className);
            String moduleName = handler.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            String string = level = writeExpressions ? handler.getLevelValueExpression().getValue() : handler.getLevel();
            if (level != null) {
                PropertyConfigurator.writeProperty(out, prefix, "level", level);
            }
            String string2 = encoding = writeExpressions ? handler.getEncodingValueExpression().getValue() : handler.getEncoding();
            if (encoding != null) {
                PropertyConfigurator.writeProperty(out, prefix, "encoding", encoding);
            }
            String string3 = filter = writeExpressions ? handler.getFilterValueExpression().getValue() : handler.getFilter();
            if (filter != null) {
                PropertyConfigurator.writeProperty(out, prefix, "filter", filter);
                implicitFilters.add(handler.getFilter());
            }
            String string4 = formatterName = writeExpressions ? handler.getFormatterNameValueExpression().getValue() : handler.getFormatterName();
            if (formatterName != null) {
                if (this.config.getFormatterNames().contains(handler.getFormatterName())) {
                    PropertyConfigurator.writeProperty(out, prefix, "formatter", formatterName);
                    implicitFormatters.add(handler.getFormatterName());
                } else {
                    PropertyConfigurator.printError("Formatter %s is not defined and will not be written to the configuration for handler %s%n", formatterName, name);
                }
            }
            String string5 = errorManagerName = writeExpressions ? handler.getErrorManagerNameValueExpression().getValue() : handler.getErrorManagerName();
            if (errorManagerName != null) {
                if (this.config.getErrorManagerNames().contains(handler.getErrorManagerName())) {
                    PropertyConfigurator.writeProperty(out, prefix, "errorManager", errorManagerName);
                    implicitErrorManagers.add(handler.getErrorManagerName());
                } else {
                    PropertyConfigurator.printError("Error manager %s is not defined and will not be written to the configuration for handler %s%n", errorManagerName, name);
                }
            }
            ArrayList<String> handlerNames = new ArrayList<String>();
            for (String handlerName : handler.getHandlerNames()) {
                if (this.config.getHandlerNames().contains(handlerName)) {
                    implicitHandlers.add(handlerName);
                    handlerNames.add(handlerName);
                    continue;
                }
                PropertyConfigurator.printError("Handler %s is not defined and will not be written to the configuration for handler %s%n", handlerName, name);
            }
            if (!handlerNames.isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "handlers", PropertyConfigurator.toCsvString(handlerNames));
            }
            if (!(postConfigurationMethods = handler.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, handler, writeExpressions);
        }
    }

    private static void writeFilterConfiguration(Writer out, FilterConfiguration filter, boolean writeExpressions) throws IOException {
        if (filter != null) {
            List<String> postConfigurationMethods;
            out.write(NEW_LINE);
            String name = filter.getName();
            String prefix = "filter." + name + ".";
            String className = filter.getClassName();
            PropertyConfigurator.writeProperty(out, "filter.", name, className);
            String moduleName = filter.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            if (!(postConfigurationMethods = filter.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, filter, writeExpressions);
        }
    }

    private static void writeFormatterConfiguration(Writer out, FormatterConfiguration formatter, boolean writeExpressions) throws IOException {
        if (formatter != null) {
            List<String> postConfigurationMethods;
            out.write(NEW_LINE);
            String name = formatter.getName();
            String prefix = "formatter." + name + ".";
            String className = formatter.getClassName();
            PropertyConfigurator.writeProperty(out, "formatter.", name, className);
            String moduleName = formatter.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            if (!(postConfigurationMethods = formatter.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, formatter, writeExpressions);
        }
    }

    private static void writeErrorManagerConfiguration(Writer out, ErrorManagerConfiguration errorManager, boolean writeExpressions) throws IOException {
        if (errorManager != null) {
            List<String> postConfigurationMethods;
            out.write(NEW_LINE);
            String name = errorManager.getName();
            String prefix = "errorManager." + name + ".";
            String className = errorManager.getClassName();
            PropertyConfigurator.writeProperty(out, "errorManager.", name, className);
            String moduleName = errorManager.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            if (!(postConfigurationMethods = errorManager.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, errorManager, writeExpressions);
        }
    }

    private static void writePojoConfiguration(Writer out, PojoConfiguration pojo, boolean writeExpressions) throws IOException {
        if (pojo != null) {
            List<String> postConfigurationMethods;
            out.write(NEW_LINE);
            String name = pojo.getName();
            String prefix = "pojo." + name + ".";
            String className = pojo.getClassName();
            PropertyConfigurator.writeProperty(out, "pojo.", name, className);
            String moduleName = pojo.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            if (!(postConfigurationMethods = pojo.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, pojo, writeExpressions);
        }
    }

    private static void writePropertyComment(Writer out, String comment) throws IOException {
        out.write(NEW_LINE);
        out.write("# ");
        out.write(comment);
        out.write(NEW_LINE);
    }

    private static void writeProperty(Writer out, String name, String value) throws IOException {
        PropertyConfigurator.writeProperty(out, null, name, value);
    }

    private static void writeProperty(Writer out, String prefix, String name, String value) throws IOException {
        if (prefix == null) {
            PropertyConfigurator.writeKey(out, name);
        } else {
            PropertyConfigurator.writeKey(out, String.format("%s%s", prefix, name));
        }
        PropertyConfigurator.writeValue(out, value);
        out.write(NEW_LINE);
    }

    private static void writeProperties(Writer out, String prefix, PropertyConfigurable propertyConfigurable, boolean writeExpression) throws IOException {
        block8: {
            List<String> names = propertyConfigurable.getPropertyNames();
            if (names.isEmpty()) break block8;
            List<String> ctorProps = propertyConfigurable.getConstructorProperties();
            if (prefix == null) {
                PropertyConfigurator.writeProperty(out, "properties", PropertyConfigurator.toCsvString(names));
                if (!ctorProps.isEmpty()) {
                    PropertyConfigurator.writeProperty(out, "constructorProperties", PropertyConfigurator.toCsvString(ctorProps));
                }
                for (String name : names) {
                    if (writeExpression) {
                        PropertyConfigurator.writeProperty(out, name, propertyConfigurable.getPropertyValueExpression(name).getValue());
                        continue;
                    }
                    PropertyConfigurator.writeProperty(out, name, propertyConfigurable.getPropertyValueString(name));
                }
            } else {
                PropertyConfigurator.writeProperty(out, prefix, "properties", PropertyConfigurator.toCsvString(names));
                if (!ctorProps.isEmpty()) {
                    PropertyConfigurator.writeProperty(out, prefix, "constructorProperties", PropertyConfigurator.toCsvString(ctorProps));
                }
                for (String name : names) {
                    if (writeExpression) {
                        PropertyConfigurator.writeProperty(out, prefix, name, propertyConfigurable.getPropertyValueExpression(name).getValue());
                        continue;
                    }
                    PropertyConfigurator.writeProperty(out, prefix, name, propertyConfigurable.getPropertyValueString(name));
                }
            }
        }
    }

    private static String toCsvString(List<String> names) {
        StringBuilder result = new StringBuilder(1024);
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            if (name.isEmpty()) continue;
            result.append(name);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Properties properties) throws IOException {
        try {
            this.configureLogger(properties, "");
            for (String loggerName : PropertyConfigurator.getStringCsvArray(properties, "loggers")) {
                this.configureLogger(properties, loggerName);
            }
            for (String handlerName : PropertyConfigurator.getStringCsvArray(properties, "handlers")) {
                this.configureHandler(properties, handlerName);
            }
            for (String filterName : PropertyConfigurator.getStringCsvArray(properties, "filters")) {
                this.configureFilter(properties, filterName);
            }
            for (String formatterName : PropertyConfigurator.getStringCsvArray(properties, "formatters")) {
                this.configureFormatter(properties, formatterName);
            }
            for (String errorManagerName : PropertyConfigurator.getStringCsvArray(properties, "errorManagers")) {
                this.configureErrorManager(properties, errorManagerName);
            }
            for (String pojoName : PropertyConfigurator.getStringCsvArray(properties, "pojos")) {
                this.configurePojos(properties, pojoName);
            }
            this.config.commit();
        }
        finally {
            this.config.forget();
        }
    }

    private void configureLogger(Properties properties, String loggerName) {
        String[] handlerNames;
        String filterName;
        if (this.config.getLoggerConfiguration(loggerName) != null) {
            return;
        }
        LoggerConfiguration loggerConfiguration = this.config.addLoggerConfiguration(loggerName);
        String levelName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "level"));
        if (levelName != null) {
            loggerConfiguration.setLevel(levelName);
        }
        if ((filterName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "filter"))) != null) {
            loggerConfiguration.setFilter(filterName);
            String resolvedFilter = loggerConfiguration.getFilterValueExpression().getResolvedValue();
            String string = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", resolvedFilter));
            if (string != null) {
                this.configureFilter(properties, resolvedFilter);
            }
        }
        for (String name : handlerNames = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("logger", loggerName, "handlers"))) {
            if (!this.configureHandler(properties, name)) continue;
            loggerConfiguration.addHandlerName(name);
        }
        String string = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "useParentHandlers"));
        if (string != null) {
            if (EXPRESSION_PATTERN.matcher(string).matches()) {
                loggerConfiguration.setUseParentHandlers(string);
            } else {
                loggerConfiguration.setUseParentHandlers(Boolean.parseBoolean(string));
            }
        }
    }

    private boolean configureFilter(Properties properties, String filterName) {
        if (this.config.getFilterConfiguration(filterName) != null) {
            return true;
        }
        String className = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", filterName));
        if (className == null) {
            PropertyConfigurator.printError("Filter %s is not defined%n", filterName);
            return false;
        }
        FilterConfiguration configuration = this.config.addFilterConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", filterName, "module")), className, filterName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("filter", filterName, "constructorProperties")));
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("filter", filterName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("filter", filterName));
        return true;
    }

    private boolean configureFormatter(Properties properties, String formatterName) {
        if (this.config.getFormatterConfiguration(formatterName) != null) {
            return true;
        }
        String className = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("formatter", formatterName));
        if (className == null) {
            PropertyConfigurator.printError("Formatter %s is not defined%n", formatterName);
            return false;
        }
        FormatterConfiguration configuration = this.config.addFormatterConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("formatter", formatterName, "module")), className, formatterName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("formatter", formatterName, "constructorProperties")));
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("formatter", formatterName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("formatter", formatterName));
        return true;
    }

    private boolean configureErrorManager(Properties properties, String errorManagerName) {
        if (this.config.getErrorManagerConfiguration(errorManagerName) != null) {
            return true;
        }
        String className = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("errorManager", errorManagerName));
        if (className == null) {
            PropertyConfigurator.printError("Error manager %s is not defined%n", errorManagerName);
            return false;
        }
        ErrorManagerConfiguration configuration = this.config.addErrorManagerConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("errorManager", errorManagerName, "module")), className, errorManagerName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("errorManager", errorManagerName, "constructorProperties")));
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("errorManager", errorManagerName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("errorManager", errorManagerName));
        return true;
    }

    private boolean configureHandler(Properties properties, String handlerName) {
        String[] handlerNames;
        String errorManagerName;
        String encoding;
        String formatterName;
        String levelName;
        if (this.config.getHandlerConfiguration(handlerName) != null) {
            return true;
        }
        String className = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName));
        if (className == null) {
            PropertyConfigurator.printError("Handler %s is not defined%n", handlerName);
            return false;
        }
        HandlerConfiguration configuration = this.config.addHandlerConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "module")), className, handlerName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("handler", handlerName, "constructorProperties")));
        String filter = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "filter"));
        if (filter != null) {
            configuration.setFilter(filter);
            String resolvedFilter = configuration.getFilterValueExpression().getResolvedValue();
            String filterClassName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", resolvedFilter));
            if (filterClassName != null) {
                this.configureFilter(properties, resolvedFilter);
            }
        }
        if ((levelName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "level"))) != null) {
            configuration.setLevel(levelName);
        }
        if ((formatterName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "formatter"))) != null) {
            if (PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("formatter", ValueExpression.STRING_RESOLVER.resolve(formatterName).getResolvedValue())) == null) {
                PropertyConfigurator.printError("Formatter %s is not defined%n", formatterName);
            } else {
                configuration.setFormatterName(formatterName);
                this.configureFormatter(properties, configuration.getFormatterNameValueExpression().getResolvedValue());
            }
        }
        if ((encoding = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "encoding"))) != null) {
            configuration.setEncoding(encoding);
        }
        if ((errorManagerName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "errorManager"))) != null) {
            if (PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("errorManager", ValueExpression.STRING_RESOLVER.resolve(errorManagerName).getResolvedValue())) == null) {
                PropertyConfigurator.printError("Error manager %s is not defined%n", errorManagerName);
            } else {
                configuration.setErrorManagerName(errorManagerName);
                this.configureErrorManager(properties, configuration.getErrorManagerNameValueExpression().getResolvedValue());
            }
        }
        for (String name : handlerNames = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("handler", handlerName, "handlers"))) {
            if (!this.configureHandler(properties, name)) continue;
            configuration.addHandlerName(name);
        }
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("handler", handlerName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("handler", handlerName));
        return true;
    }

    private boolean configurePojos(Properties properties, String pojoName) {
        if (this.config.getPojoConfiguration(pojoName) != null) {
            return true;
        }
        String className = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("pojo", pojoName));
        if (className == null) {
            PropertyConfigurator.printError("POJO %s is not defined%n", pojoName);
            return false;
        }
        PojoConfiguration configuration = this.config.addPojoConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("pojo", pojoName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("pojo", pojoName)), pojoName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("pojo", pojoName, "constructorProperties")));
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("pojo", pojoName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("pojo", pojoName));
        return true;
    }

    private void configureProperties(Properties properties, PropertyConfigurable configurable, String prefix) {
        List<String> propertyNames = PropertyConfigurator.getStringCsvList(properties, PropertyConfigurator.getKey(prefix, "properties"));
        for (String propertyName : propertyNames) {
            String valueString = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey(prefix, propertyName), false);
            if (valueString == null) continue;
            configurable.setPropertyValueString(propertyName, valueString);
        }
    }

    private static String getKey(String prefix, String objectName) {
        return objectName.length() > 0 ? prefix + "." + objectName : prefix;
    }

    private static String getKey(String prefix, String objectName, String key) {
        return objectName.length() > 0 ? prefix + "." + objectName + "." + key : prefix + "." + key;
    }

    private static String getStringProperty(Properties properties, String key) {
        return PropertyConfigurator.getStringProperty(properties, key, true);
    }

    private static String getStringProperty(Properties properties, String key, boolean trim) {
        String value = properties.getProperty(key);
        return trim ? (value == null ? null : value.trim()) : value;
    }

    private static String[] getStringCsvArray(Properties properties, String key) {
        String property = properties.getProperty(key, "");
        if (property == null) {
            return EMPTY_STRINGS;
        }
        String value = property.trim();
        if (value.length() == 0) {
            return EMPTY_STRINGS;
        }
        return value.split("\\s*,\\s*");
    }

    private static List<String> getStringCsvList(Properties properties, String key) {
        return new ArrayList<String>(Arrays.asList(PropertyConfigurator.getStringCsvArray(properties, key)));
    }

    private static void writeValue(Appendable out, String value) throws IOException {
        PropertyConfigurator.writeSanitized(out, value, false);
    }

    private static void writeKey(Appendable out, String key) throws IOException {
        PropertyConfigurator.writeSanitized(out, key, true);
        out.append('=');
    }

    private static void writeSanitized(Appendable out, String string, boolean escapeSpaces) throws IOException {
        block8: for (int x = 0; x < string.length(); ++x) {
            char c = string.charAt(x);
            switch (c) {
                case ' ': {
                    if (x == 0 || escapeSpaces) {
                        out.append('\\');
                    }
                    out.append(c);
                    continue block8;
                }
                case '\t': {
                    out.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    out.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    out.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    out.append('\\').append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    out.append('\\').append(c);
                    continue block8;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    static void printError(String msg) {
        System.err.println(msg);
    }

    static void printError(String format, Object ... args) {
        System.err.printf(format, args);
    }

    private static void safeClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

