/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.impl.ClientConfigurationImpl;
import org.jboss.threads.JBossThreadFactory;

public interface ModelControllerClientConfiguration
extends Closeable {
    public String getHost();

    public int getPort();

    public String getProtocol();

    public int getConnectionTimeout();

    public CallbackHandler getCallbackHandler();

    public Map<String, String> getSaslOptions();

    public SSLContext getSSLContext();

    public ExecutorService getExecutor();

    public String getClientBindAddress();

    default public URI getAuthenticationConfigUri() {
        return null;
    }

    @Deprecated
    public static class Factory {
        private static final AtomicInteger executorCount = new AtomicInteger();
        private static final ThreadGroup defaultThreadGroup = new ThreadGroup("management-client-thread");

        static ExecutorService createDefaultExecutor() {
            ThreadFactory threadFactory = AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

                @Override
                public JBossThreadFactory run() {
                    return new JBossThreadFactory(defaultThreadGroup, Boolean.FALSE, null, "%G " + executorCount.incrementAndGet() + "-%t", null, null);
                }
            });
            return new ThreadPoolExecutor(2, Factory.getSystemProperty("org.jboss.as.controller.client.max-threads", 6), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        }

        private static int getSystemProperty(String name, int defaultValue) {
            String value = Factory.getStringProperty(name);
            try {
                return value == null ? defaultValue : Integer.parseInt(value);
            }
            catch (NumberFormatException ignored) {
                return defaultValue;
            }
        }

        private static String getStringProperty(final String name) {
            return System.getSecurityManager() == null ? System.getProperty(name) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port) throws UnknownHostException {
            return new Builder().setHostName(hostName).setPort(port).setProtocol(protocol).build();
        }

        public static ModelControllerClientConfiguration create(InetAddress address, int port, CallbackHandler handler) {
            return new Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).build();
        }

        public static ModelControllerClientConfiguration create(InetAddress address, int port) {
            return new Builder().setHostName(address.getHostAddress()).setPort(port).build();
        }

        public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return new Builder().setHostName(hostName).setPort(port).setHandler(handler).setSslContext(sslContext).build();
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return new Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).build();
        }

        public static ModelControllerClientConfiguration create(String protocol, InetAddress address, int port) {
            return new Builder().setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).build();
        }

        public static ModelControllerClientConfiguration create(String protocol, InetAddress address, int port, CallbackHandler handler) {
            return new Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).build();
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return new Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSslContext(sslContext).build();
        }

        public static ModelControllerClientConfiguration create(InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return new Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setSaslOptions(saslOptions).build();
        }

        public static ModelControllerClientConfiguration create(String protocol, InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return new Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).build();
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return new Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSslContext(sslContext).build();
        }

        public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return new Builder().setHandler(handler).setHostName(hostName).setPort(port).setSaslOptions(saslOptions).build();
        }

        public static ModelControllerClientConfiguration create(String hostName, int port) throws UnknownHostException {
            return new Builder().setHostName(hostName).setPort(port).build();
        }

        public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return new Builder().setHandler(handler).setHostName(hostName).setPort(port).build();
        }

        public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return new Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setSslContext(sslContext).build();
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions) throws UnknownHostException {
            return new Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).setSslContext(sslContext).build();
        }

        public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return new Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).build();
        }
    }

    public static class Builder {
        private String hostName;
        private String clientBindAddress;
        private int port;
        private CallbackHandler handler;
        private Map<String, String> saslOptions;
        private SSLContext sslContext;
        private String protocol;
        private int connectionTimeout = 0;
        private URI authConfigUri;

        public Builder setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder setClientBindAddress(String clientBindAddress) {
            this.clientBindAddress = clientBindAddress;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setHandler(CallbackHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder setSaslOptions(Map<String, String> saslOptions) {
            this.saslOptions = saslOptions;
            return this;
        }

        public Builder setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setAuthenticationConfigUri(URI authConfigUri) {
            this.authConfigUri = authConfigUri;
            return this;
        }

        public ModelControllerClientConfiguration build() {
            return new ClientConfigurationImpl(this.hostName, this.port, this.handler, this.saslOptions, this.sslContext, Factory.createDefaultExecutor(), true, this.connectionTimeout, this.protocol, this.clientBindAddress, this.authConfigUri);
        }
    }
}

