/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.VersionHandler;
import org.jboss.as.cli.impl.CommandContextConfiguration;
import org.jboss.as.protocol.StreamUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class CliLauncher {
    private static final String JBOSS_CLI_RC_PROPERTY = "jboss.cli.rc";
    private static final String CURRENT_WORKING_DIRECTORY = "user.dir";
    private static final String JBOSS_CLI_RC_FILE = ".jbossclirc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int exitCode = 0;
        CommandContext cmdCtx = null;
        boolean gui = false;
        ArrayList<String> systemPropertyKeys = new ArrayList<String>();
        try {
            String argError = null;
            List<String> commands = null;
            File file = null;
            boolean errorOnInteract = false;
            boolean connect = false;
            boolean version = false;
            int connectionTimeout = -1;
            CommandContextConfiguration.Builder ctxBuilder = new CommandContextConfiguration.Builder();
            ctxBuilder.setErrorOnInteract(errorOnInteract);
            for (String arg : args) {
                String value;
                if (arg.startsWith("--controller=") || arg.startsWith("controller=")) {
                    if (arg.startsWith("--")) {
                        ctxBuilder.setController(arg.substring(13));
                        continue;
                    }
                    ctxBuilder.setController(arg.substring(11));
                    continue;
                }
                if ("--connect".equals(arg) || "-c".equals(arg)) {
                    connect = true;
                    continue;
                }
                if ("--version".equals(arg)) {
                    version = true;
                    continue;
                }
                if ("--gui".equals(arg)) {
                    gui = true;
                    continue;
                }
                if (arg.startsWith("--file=") || arg.startsWith("file=")) {
                    String fileName;
                    if (file != null) {
                        argError = "Duplicate argument '--file'.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    String string = fileName = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    if (!fileName.isEmpty()) {
                        file = new File(FilenameTabCompleter.expand(fileName));
                        if (file.exists()) continue;
                        argError = "File " + file.getAbsolutePath() + " doesn't exist.";
                        break;
                    }
                    argError = "Argument '--file' is missing value.";
                    break;
                }
                if (arg.startsWith("--commands=") || arg.startsWith("commands=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(11) : arg.substring(9);
                    commands = Util.splitCommands(value);
                    continue;
                }
                if (arg.startsWith("--command=") || arg.startsWith("command=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "'" + arg + "' is assumed to be a command(s) but the commands to execute have been specified by another argument: " + commands;
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(10) : arg.substring(8);
                    commands = Collections.singletonList(value);
                    continue;
                }
                if (arg.startsWith("--user")) {
                    if (arg.length() > 6 && arg.charAt(6) == '=') {
                        ctxBuilder.setUsername(arg.substring(7));
                        ctxBuilder.setDisableLocalAuth(true);
                        continue;
                    }
                    argError = "'=' is missing after --user";
                    break;
                }
                if (arg.startsWith("--password")) {
                    if (arg.length() > 10 && arg.charAt(10) == '=') {
                        ctxBuilder.setPassword(arg.substring(11).toCharArray());
                        continue;
                    }
                    argError = "'=' is missing after --password";
                    break;
                }
                if (arg.startsWith("-u")) {
                    if (arg.length() > 2 && arg.charAt(2) == '=') {
                        ctxBuilder.setUsername(arg.substring(3));
                        ctxBuilder.setDisableLocalAuth(true);
                        continue;
                    }
                    argError = "'=' is missing after -u";
                    break;
                }
                if (arg.startsWith("-p")) {
                    if (arg.length() > 2 && arg.charAt(2) == '=') {
                        ctxBuilder.setPassword(arg.substring(3).toCharArray());
                        continue;
                    }
                    argError = "'=' is missing after -p";
                    break;
                }
                if (arg.equals("--no-local-auth")) {
                    ctxBuilder.setDisableLocalAuth(true);
                    continue;
                }
                if (arg.equals("--echo-command")) {
                    ctxBuilder.setEchoCommand(true);
                    continue;
                }
                if (arg.startsWith("--command-timeout=")) {
                    ctxBuilder.setCommandTimeout(Integer.parseInt(arg.substring(18)));
                    continue;
                }
                if (arg.equals("--error-on-interact")) {
                    ctxBuilder.setErrorOnInteract(true);
                    errorOnInteract = true;
                    continue;
                }
                if (arg.startsWith("--timeout")) {
                    if (connectionTimeout > 0) {
                        argError = "Duplicate argument '--timeout'";
                        break;
                    }
                    if (arg.length() > 9 && arg.charAt(9) == '=') {
                        value = arg.substring(10);
                        try {
                            connectionTimeout = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (connectionTimeout > 0) continue;
                        argError = "The timeout must be a valid positive integer: '" + value + "'";
                        break;
                    }
                    argError = "'=' is missing after --timeout";
                    break;
                }
                if (arg.startsWith("--bind=")) {
                    ctxBuilder.setClientBindAddress(arg.substring(7));
                    continue;
                }
                if (arg.equals("--help") || arg.equals("-h")) {
                    commands = Collections.singletonList("help");
                    continue;
                }
                if (arg.startsWith("--properties=")) {
                    value = arg.substring(13);
                    File propertiesFile = new File(FilenameTabCompleter.expand(value));
                    if (!propertiesFile.exists()) {
                        argError = "File doesn't exist: " + propertiesFile.getAbsolutePath();
                        break;
                    }
                    Properties props = new Properties();
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(propertiesFile);
                        props.load(fis);
                    }
                    catch (FileNotFoundException e) {
                        argError = e.getLocalizedMessage();
                        break;
                    }
                    catch (IOException e) {
                        argError = "Failed to load properties from " + propertiesFile.getAbsolutePath() + ": " + e.getLocalizedMessage();
                        break;
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    for (String key : props.stringPropertyNames()) {
                        if (systemPropertyKeys.contains(key)) continue;
                        WildFlySecurityManager.setPropertyPrivileged(key, props.getProperty(key));
                    }
                    continue;
                }
                if (arg.startsWith("-D")) {
                    String prop = arg.substring(2);
                    int i = prop.indexOf(61);
                    if (i > 0) {
                        String key = prop.substring(0, i);
                        WildFlySecurityManager.setPropertyPrivileged(key, prop.substring(i + 1, prop.length()));
                        systemPropertyKeys.add(key);
                        continue;
                    }
                    WildFlySecurityManager.setPropertyPrivileged(prop, "true");
                    systemPropertyKeys.add(prop);
                    continue;
                }
                if (arg.equals("-XX:")) continue;
                if (file != null) {
                    argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time: " + arg;
                    break;
                }
                if (commands != null) {
                    argError = "'" + arg + "' is assumed to be a command(s) but the commands to execute have been specified by another argument: " + commands;
                    break;
                }
                commands = Util.splitCommands(arg);
            }
            if (errorOnInteract && file == null && commands == null) {
                argError = "--error-on-interact function is only available in non-interactive mode, using --file or --command(s).";
            }
            ctxBuilder.setConnectionTimeout(connectionTimeout);
            if (argError != null) {
                System.err.println(argError);
                exitCode = 1;
                return;
            }
            if (version) {
                cmdCtx = CliLauncher.initCommandContext(ctxBuilder.build(), connect);
                VersionHandler.INSTANCE.handle(cmdCtx);
                return;
            }
            if (file != null) {
                cmdCtx = CliLauncher.initCommandContext(ctxBuilder.build(), connect);
                CliLauncher.processFile(file, cmdCtx);
                return;
            }
            if (commands != null) {
                cmdCtx = CliLauncher.initCommandContext(ctxBuilder.build(), connect);
                CliLauncher.processCommands(commands, cmdCtx);
                return;
            }
            if (gui) {
                cmdCtx = CliLauncher.initCommandContext(ctxBuilder.build(), true);
                CliLauncher.processGui(cmdCtx);
                return;
            }
            ctxBuilder.setInitConsole(true);
            cmdCtx = CliLauncher.initCommandContext(ctxBuilder.build(), connect);
            cmdCtx.interact();
        }
        catch (Throwable t) {
            System.out.println(Util.getMessagesFromThrowable(t));
            exitCode = 1;
        }
        finally {
            if (cmdCtx != null && !gui) {
                cmdCtx.terminateSession();
                if (cmdCtx.getExitCode() != 0) {
                    exitCode = cmdCtx.getExitCode();
                }
            }
            if (!gui) {
                System.exit(exitCode);
            }
        }
        System.exit(exitCode);
    }

    private static CommandContext initCommandContext(CommandContextConfiguration ctxConfig, boolean connect) throws CliInitializationException {
        CommandContext cmdCtx = CommandContextFactory.getInstance().newCommandContext(ctxConfig);
        if (connect) {
            try {
                cmdCtx.connectController();
            }
            catch (CommandLineException e) {
                throw new CliInitializationException("Failed to connect to the controller", e);
            }
        }
        return cmdCtx;
    }

    private static void processGui(CommandContext cmdCtx) {
        try {
            GuiMain.start(cmdCtx);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void processCommands(List<String> commands, CommandContext cmdCtx) {
        for (int i = 0; cmdCtx.getExitCode() == 0 && i < commands.size() && !cmdCtx.isTerminated(); ++i) {
            cmdCtx.handleSafe(commands.get(i));
        }
    }

    private static void processFile(File file, CommandContext cmdCtx) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (cmdCtx.getExitCode() == 0 && !cmdCtx.isTerminated() && line != null) {
                cmdCtx.handleSafe(line.trim());
                line = reader.readLine();
            }
        }
        catch (Throwable e) {
            try {
                throw new IllegalStateException("Failed to process file '" + file.getAbsolutePath() + "'", e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(reader);
                throw throwable;
            }
        }
        StreamUtils.safeClose(reader);
    }

    static void runcom(CommandContext ctx) throws CliInitializationException {
        File jbossCliRcFile = null;
        String jbossCliRc = WildFlySecurityManager.getPropertyPrivileged(JBOSS_CLI_RC_PROPERTY, null);
        if (jbossCliRc == null) {
            String dir = WildFlySecurityManager.getPropertyPrivileged(CURRENT_WORKING_DIRECTORY, null);
            File f = new File(dir, JBOSS_CLI_RC_FILE);
            if (!f.exists()) {
                dir = WildFlySecurityManager.getEnvPropertyPrivileged("JBOSS_HOME", null);
                if (dir != null && (f = new File(dir + File.separatorChar + "bin", JBOSS_CLI_RC_FILE)).exists()) {
                    jbossCliRcFile = f;
                }
            } else {
                jbossCliRcFile = f;
            }
        } else {
            jbossCliRcFile = new File(jbossCliRc);
            if (!jbossCliRcFile.exists()) {
                throw new CliInitializationException("Property jboss.cli.rc points to a file that doesn't exist: " + jbossCliRcFile.getAbsolutePath());
            }
        }
        if (jbossCliRcFile != null) {
            CliLauncher.processFile(jbossCliRcFile, ctx);
            if (ctx.getExitCode() != 0) {
                throw new CliInitializationException("Failed to process " + jbossCliRcFile.getAbsoluteFile());
            }
        }
    }
}

