/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.binary.SingleKeyOperationImpl;

class MutatorOperationImpl
extends SingleKeyOperationImpl
implements MutatorOperation {
    private static final byte CMD_INCR = 5;
    private static final byte CMD_DECR = 6;
    private final Mutator mutator;
    private final long by;
    private final int exp;
    private final long def;

    public MutatorOperationImpl(Mutator m, String k, long b, long d, int e, OperationCallback cb) {
        super(m == Mutator.incr ? (byte)5 : 6, MutatorOperationImpl.generateOpaque(), k, cb);
        assert (d >= 0L) : "Default value is below zero";
        this.mutator = m;
        this.by = b;
        this.exp = e;
        this.def = d;
    }

    public void initialize() {
        byte[] defBytes = new byte[]{(byte)(this.def >> 56 & 0xFFL), (byte)(this.def >> 48 & 0xFFL), (byte)(this.def >> 40 & 0xFFL), (byte)(this.def >> 32 & 0xFFL), (byte)(this.def >> 24 & 0xFFL), (byte)(this.def >> 16 & 0xFFL), (byte)(this.def >> 8 & 0xFFL), (byte)(this.def & 0xFFL)};
        this.prepareBuffer(this.key, 0L, EMPTY_BYTES, this.by, defBytes, this.exp);
    }

    protected void decodePayload(byte[] pl) {
        this.getCallback().receivedStatus(new OperationStatus(true, String.valueOf(MutatorOperationImpl.decodeLong(pl, 0))));
    }

    public int getBy() {
        return (int)this.by;
    }

    public long getDefault() {
        return this.def;
    }

    public int getExpiration() {
        return this.exp;
    }

    public Mutator getType() {
        return this.mutator;
    }

    public String toString() {
        return super.toString() + " Amount: " + this.by + " Default: " + this.def + " Exp: " + this.exp;
    }
}

