/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.compat.log.LoggerFactory;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationException;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.TapOperation;
import net.spy.memcached.ops.VBucketAware;
import net.spy.memcached.protocol.binary.TapAckOperationImpl;
import net.spy.memcached.vbucket.Reconfigurable;
import net.spy.memcached.vbucket.VBucketNodeLocator;
import net.spy.memcached.vbucket.config.Bucket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemcachedConnection
extends SpyObject
implements Reconfigurable {
    private static final int DOUBLE_CHECK_EMPTY = 256;
    private static final int EXCESSIVE_EMPTY = 0x1000000;
    private volatile boolean shutDown = false;
    private final boolean shouldOptimize;
    private Selector selector = null;
    private final NodeLocator locator;
    private final FailureMode failureMode;
    private final long maxDelay;
    private int emptySelects = 0;
    private final int bufSize;
    private final ConnectionFactory connectionFactory;
    private final ConcurrentLinkedQueue<MemcachedNode> addedQueue;
    private final SortedMap<Long, MemcachedNode> reconnectQueue;
    private final Collection<ConnectionObserver> connObservers = new ConcurrentLinkedQueue<ConnectionObserver>();
    private final OperationFactory opFact;
    private final int timeoutExceptionThreshold;
    private final Collection<Operation> retryOps;
    private final ConcurrentLinkedQueue<MemcachedNode> nodesToShutdown;

    public MemcachedConnection(int bufSize, ConnectionFactory f, List<InetSocketAddress> a, Collection<ConnectionObserver> obs, FailureMode fm, OperationFactory opfactory) throws IOException {
        this.connObservers.addAll(obs);
        this.reconnectQueue = new TreeMap<Long, MemcachedNode>();
        this.addedQueue = new ConcurrentLinkedQueue();
        this.failureMode = fm;
        this.shouldOptimize = f.shouldOptimize();
        this.maxDelay = f.getMaxReconnectDelay();
        this.opFact = opfactory;
        this.timeoutExceptionThreshold = f.getTimeoutExceptionThreshold();
        this.selector = Selector.open();
        this.retryOps = new ArrayList<Operation>();
        this.nodesToShutdown = new ConcurrentLinkedQueue();
        this.bufSize = bufSize;
        this.connectionFactory = f;
        List<MemcachedNode> connections = this.createConnections(a);
        this.locator = f.createLocator(connections);
    }

    private List<MemcachedNode> createConnections(Collection<InetSocketAddress> a) throws IOException {
        ArrayList<MemcachedNode> connections = new ArrayList<MemcachedNode>(a.size());
        for (InetSocketAddress sa : a) {
            SocketChannel ch = SocketChannel.open();
            ch.configureBlocking(false);
            MemcachedNode qa = this.connectionFactory.createMemcachedNode(sa, ch, this.bufSize);
            int ops = 0;
            ch.socket().setTcpNoDelay(!this.connectionFactory.useNagleAlgorithm());
            try {
                if (ch.connect(sa)) {
                    this.getLogger().info("Connected to %s immediately", qa);
                    this.connected(qa);
                } else {
                    this.getLogger().info("Added %s to connect queue", qa);
                    ops = 8;
                }
                qa.setSk(ch.register(this.selector, ops, qa));
                assert (ch.isConnected() || qa.getSk().interestOps() == 8) : "Not connected, and not wanting to connect";
            }
            catch (SocketException e) {
                this.getLogger().warn((Object)"Socket error on initial connect", e);
                this.queueReconnect(qa);
            }
            connections.add(qa);
        }
        return connections;
    }

    @Override
    public void reconfigure(Bucket bucket) {
        try {
            List<String> servers = bucket.getConfig().getServers();
            HashSet<InetSocketAddress> newServerAddresses = new HashSet<InetSocketAddress>();
            ArrayList<InetSocketAddress> newServers = new ArrayList<InetSocketAddress>();
            for (String server : servers) {
                int finalColon = server.lastIndexOf(58);
                if (finalColon < 1) {
                    throw new IllegalArgumentException("Invalid server ``" + server + "'' in vbucket's server list");
                }
                String hostPart = server.substring(0, finalColon);
                String portNum = server.substring(finalColon + 1);
                InetSocketAddress address = new InetSocketAddress(hostPart, Integer.parseInt(portNum));
                newServerAddresses.add(address);
                newServers.add(address);
            }
            ArrayList<MemcachedNode> oddNodes = new ArrayList<MemcachedNode>();
            ArrayList<MemcachedNode> stayNodes = new ArrayList<MemcachedNode>();
            ArrayList<InetSocketAddress> stayServers = new ArrayList<InetSocketAddress>();
            for (MemcachedNode current : this.locator.getAll()) {
                if (newServerAddresses.contains(current.getSocketAddress())) {
                    stayNodes.add(current);
                    stayServers.add((InetSocketAddress)current.getSocketAddress());
                    continue;
                }
                oddNodes.add(current);
            }
            newServers.removeAll(stayServers);
            List<MemcachedNode> newNodes = this.createConnections(newServers);
            ArrayList<MemcachedNode> mergedNodes = new ArrayList<MemcachedNode>();
            mergedNodes.addAll(stayNodes);
            mergedNodes.addAll(newNodes);
            this.locator.updateLocator(mergedNodes, bucket.getConfig());
            this.nodesToShutdown.addAll(oddNodes);
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Connection reconfiguration failed", e);
        }
    }

    private boolean selectorsMakeSense() {
        for (MemcachedNode qa : this.locator.getAll()) {
            int sops;
            if (qa.getSk() == null || !qa.getSk().isValid()) continue;
            if (qa.getChannel().isConnected()) {
                sops = qa.getSk().interestOps();
                int expected = 0;
                if (qa.hasReadOp()) {
                    expected |= 1;
                }
                if (qa.hasWriteOp()) {
                    expected |= 4;
                }
                if (qa.getBytesRemainingToWrite() > 0) {
                    expected |= 4;
                }
                assert (sops == expected) : "Invalid ops:  " + qa + ", expected " + expected + ", got " + sops;
                continue;
            }
            sops = qa.getSk().interestOps();
            assert (sops == 8) : "Not connected, and not watching for connect: " + sops;
        }
        this.getLogger().debug("Checked the selectors.");
        return true;
    }

    public void handleIO() throws IOException {
        if (this.shutDown) {
            throw new IOException("No IO while shut down");
        }
        this.handleInputQueue();
        this.getLogger().debug("Done dealing with queue.");
        long delay = 0L;
        if (!this.reconnectQueue.isEmpty()) {
            long now = System.currentTimeMillis();
            long then = this.reconnectQueue.firstKey();
            delay = Math.max(then - now, 1L);
        }
        this.getLogger().debug("Selecting with delay of %sms", delay);
        assert (this.selectorsMakeSense()) : "Selectors don't make sense.";
        int selected = this.selector.select(delay);
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        if (selectedKeys.isEmpty() && !this.shutDown) {
            this.getLogger().debug("No selectors ready, interrupted: " + Thread.interrupted());
            if (++this.emptySelects > 256) {
                for (SelectionKey sk : this.selector.keys()) {
                    this.getLogger().info("%s has %s, interested in %s", sk, sk.readyOps(), sk.interestOps());
                    if (sk.readyOps() != 0) {
                        this.getLogger().info("%s has a ready op, handling IO", sk);
                        this.handleIO(sk);
                        continue;
                    }
                    this.lostConnection((MemcachedNode)sk.attachment());
                }
                assert (this.emptySelects < 0x1000000) : "Too many empty selects";
            }
        } else {
            this.getLogger().debug("Selected %d, selected %d keys", selected, selectedKeys.size());
            this.emptySelects = 0;
            for (SelectionKey sk : selectedKeys) {
                this.handleIO(sk);
            }
            selectedKeys.clear();
        }
        for (SelectionKey sk : this.selector.keys()) {
            MemcachedNode mn = (MemcachedNode)sk.attachment();
            if (mn.getContinuousTimeout() <= this.timeoutExceptionThreshold) continue;
            this.getLogger().warn("%s exceeded continuous timeout threshold", sk);
            this.lostConnection(mn);
        }
        if (!this.shutDown && !this.reconnectQueue.isEmpty()) {
            this.attemptReconnects();
        }
        this.redistributeOperations(this.retryOps);
        this.retryOps.clear();
        for (MemcachedNode qa : this.nodesToShutdown) {
            if (this.addedQueue.contains(qa)) continue;
            this.nodesToShutdown.remove(qa);
            Collection<Operation> notCompletedOperations = qa.destroyInputQueue();
            if (qa.getChannel() != null) {
                qa.getChannel().close();
                qa.setSk(null);
                if (qa.getBytesRemainingToWrite() > 0) {
                    this.getLogger().warn("Shut down with %d bytes remaining to write", qa.getBytesRemainingToWrite());
                }
                this.getLogger().debug("Shut down channel %s", qa.getChannel());
            }
            this.redistributeOperations(notCompletedOperations);
        }
    }

    private void handleInputQueue() {
        if (!this.addedQueue.isEmpty()) {
            this.getLogger().debug("Handling queue");
            HashSet<MemcachedNode> toAdd = new HashSet<MemcachedNode>();
            HashSet<MemcachedNode> todo = new HashSet<MemcachedNode>();
            MemcachedNode qaNode = null;
            while ((qaNode = this.addedQueue.poll()) != null) {
                todo.add(qaNode);
            }
            for (MemcachedNode qa : todo) {
                boolean readyForIO = false;
                if (qa.isActive()) {
                    if (qa.getCurrentWriteOp() != null) {
                        readyForIO = true;
                        this.getLogger().debug("Handling queued write %s", qa);
                    }
                } else {
                    toAdd.add(qa);
                }
                qa.copyInputQueue();
                if (readyForIO) {
                    try {
                        if (qa.getWbuf().hasRemaining()) {
                            this.handleWrites(qa.getSk(), qa);
                        }
                    }
                    catch (IOException e) {
                        this.getLogger().warn((Object)"Exception handling write", e);
                        this.lostConnection(qa);
                    }
                }
                qa.fixupOps();
            }
            this.addedQueue.addAll(toAdd);
        }
    }

    public boolean addObserver(ConnectionObserver obs) {
        return this.connObservers.add(obs);
    }

    public boolean removeObserver(ConnectionObserver obs) {
        return this.connObservers.remove(obs);
    }

    private void connected(MemcachedNode qa) {
        assert (qa.getChannel().isConnected()) : "Not connected.";
        int rt = qa.getReconnectCount();
        qa.connected();
        for (ConnectionObserver observer : this.connObservers) {
            observer.connectionEstablished(qa.getSocketAddress(), rt);
        }
    }

    private void lostConnection(MemcachedNode qa) {
        this.queueReconnect(qa);
        for (ConnectionObserver observer : this.connObservers) {
            observer.connectionLost(qa.getSocketAddress());
        }
    }

    private void handleIO(SelectionKey sk) {
        MemcachedNode qa = (MemcachedNode)sk.attachment();
        try {
            this.getLogger().debug("Handling IO for:  %s (r=%s, w=%s, c=%s, op=%s)", sk, sk.isReadable(), sk.isWritable(), sk.isConnectable(), sk.attachment());
            if (sk.isConnectable()) {
                this.getLogger().info("Connection state changed for %s", sk);
                SocketChannel channel = qa.getChannel();
                if (channel.finishConnect()) {
                    this.connected(qa);
                    this.addedQueue.offer(qa);
                    if (qa.getWbuf().hasRemaining()) {
                        this.handleWrites(sk, qa);
                    }
                } else assert (!channel.isConnected()) : "connected";
            } else {
                if (sk.isValid() && sk.isReadable()) {
                    this.handleReads(sk, qa);
                }
                if (sk.isValid() && sk.isWritable()) {
                    this.handleWrites(sk, qa);
                }
            }
        }
        catch (ClosedChannelException e) {
            if (!this.shutDown) {
                this.getLogger().info("Closed channel and not shutting down.  Queueing reconnect on %s", qa, e);
                this.lostConnection(qa);
            }
        }
        catch (ConnectException e) {
            this.getLogger().info("Reconnecting due to failure to connect to %s", qa, e);
            this.queueReconnect(qa);
        }
        catch (OperationException e) {
            qa.setupForAuth();
            this.getLogger().info("Reconnection due to exception handling a memcached operation on %s.  This may be due to an authentication failure.", qa, e);
            this.lostConnection(qa);
        }
        catch (Exception e) {
            qa.setupForAuth();
            this.getLogger().info("Reconnecting due to exception on %s", qa, e);
            this.lostConnection(qa);
        }
        qa.fixupOps();
    }

    private void handleWrites(SelectionKey sk, MemcachedNode qa) throws IOException {
        boolean canWriteMore;
        qa.fillWriteBuffer(this.shouldOptimize);
        boolean bl = canWriteMore = qa.getBytesRemainingToWrite() > 0;
        while (canWriteMore) {
            int wrote = qa.writeSome();
            qa.fillWriteBuffer(this.shouldOptimize);
            canWriteMore = wrote > 0 && qa.getBytesRemainingToWrite() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReads(SelectionKey sk, MemcachedNode qa) throws IOException {
        Operation currentOp = qa.getCurrentReadOp();
        if (currentOp instanceof TapAckOperationImpl) {
            qa.removeCurrentReadOp();
            return;
        }
        ByteBuffer rbuf = qa.getRbuf();
        SocketChannel channel = qa.getChannel();
        int read = channel.read(rbuf);
        if (read < 0) {
            if (currentOp instanceof TapOperation) {
                currentOp.getCallback().complete();
                ((TapOperation)currentOp).streamClosed(OperationState.COMPLETE);
                this.getLogger().debug("Completed read op: %s and giving the next %d bytes", currentOp, rbuf.remaining());
                Operation op = qa.removeCurrentReadOp();
                assert (op == currentOp) : "Expected to pop " + currentOp + " got " + op;
                currentOp = qa.getCurrentReadOp();
            } else {
                throw new IOException("Disconnected unexpected, will reconnect.");
            }
        }
        while (read > 0) {
            this.getLogger().debug("Read %d bytes", read);
            rbuf.flip();
            while (rbuf.remaining() > 0) {
                if (currentOp == null) {
                    throw new IllegalStateException("No read operation.");
                }
                Operation operation = currentOp;
                synchronized (operation) {
                    Operation op;
                    currentOp.readFromBuffer(rbuf);
                    if (currentOp.getState() == OperationState.COMPLETE) {
                        this.getLogger().debug("Completed read op: %s and giving the next %d bytes", currentOp, rbuf.remaining());
                        op = qa.removeCurrentReadOp();
                        assert (op == currentOp) : "Expected to pop " + currentOp + " got " + op;
                    } else if (currentOp.getState() == OperationState.RETRY) {
                        this.getLogger().warn("Reschedule read op due to NOT_MY_VBUCKET error: %s ", currentOp);
                        ((VBucketAware)((Object)currentOp)).addNotMyVbucketNode(currentOp.getHandlingNode());
                        op = qa.removeCurrentReadOp();
                        assert (op == currentOp) : "Expected to pop " + currentOp + " got " + op;
                        this.retryOps.add(currentOp);
                    }
                }
                currentOp = qa.getCurrentReadOp();
            }
            rbuf.clear();
            read = channel.read(rbuf);
        }
    }

    static String dbgBuffer(ByteBuffer b, int size) {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = b.array();
        for (int i = 0; i < size; ++i) {
            char ch = (char)bytes[i];
            if (Character.isWhitespace(ch) || Character.isLetterOrDigit(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append("\\x");
            sb.append(Integer.toHexString(bytes[i] & 0xFF));
        }
        return sb.toString();
    }

    private void queueReconnect(MemcachedNode qa) {
        if (!this.shutDown) {
            this.getLogger().warn("Closing, and reopening %s, attempt %d.", qa, qa.getReconnectCount());
            if (qa.getSk() != null) {
                qa.getSk().cancel();
                assert (!qa.getSk().isValid()) : "Cancelled selection key is valid";
            }
            qa.reconnecting();
            try {
                if (qa.getChannel() != null && qa.getChannel().socket() != null) {
                    qa.getChannel().socket().close();
                } else {
                    this.getLogger().info("The channel or socket was null for %s", qa);
                }
            }
            catch (IOException e) {
                this.getLogger().warn((Object)"IOException trying to close a socket", e);
            }
            qa.setChannel(null);
            long delay = (long)Math.min((double)this.maxDelay, Math.pow(2.0, qa.getReconnectCount())) * 1000L;
            long reconTime = System.currentTimeMillis() + delay;
            while (this.reconnectQueue.containsKey(reconTime)) {
                ++reconTime;
            }
            this.reconnectQueue.put(reconTime, qa);
            qa.setupResend();
            if (this.failureMode == FailureMode.Redistribute) {
                this.redistributeOperations(qa.destroyInputQueue());
            } else if (this.failureMode == FailureMode.Cancel) {
                this.cancelOperations(qa.destroyInputQueue());
            }
        }
    }

    private void cancelOperations(Collection<Operation> ops) {
        for (Operation op : ops) {
            op.cancel();
        }
    }

    private void redistributeOperations(Collection<Operation> ops) {
        for (Operation op : ops) {
            if (op.isCancelled() || op.isTimedOut()) continue;
            if (op instanceof KeyedOperation) {
                KeyedOperation ko = (KeyedOperation)op;
                int added = 0;
                for (String k : ko.getKeys()) {
                    for (Operation newop : this.opFact.clone(ko)) {
                        this.addOperation(k, newop);
                        ++added;
                    }
                }
                assert (added > 0) : "Didn't add any new operations when redistributing";
                continue;
            }
            op.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void attemptReconnects() throws IOException {
        long now = System.currentTimeMillis();
        IdentityHashMap<MemcachedNode, Boolean> seen = new IdentityHashMap<MemcachedNode, Boolean>();
        ArrayList<MemcachedNode> rereQueue = new ArrayList<MemcachedNode>();
        SocketChannel ch = null;
        Iterator<MemcachedNode> i = this.reconnectQueue.headMap(now).values().iterator();
        while (i.hasNext()) {
            MemcachedNode qa = i.next();
            i.remove();
            if (!seen.containsKey(qa)) {
                seen.put(qa, Boolean.TRUE);
                this.getLogger().info("Reconnecting %s", qa);
                ch = SocketChannel.open();
                ch.configureBlocking(false);
                int ops = 0;
                if (ch.connect(qa.getSocketAddress())) {
                    this.getLogger().info("Immediately reconnected to %s", qa);
                    assert (ch.isConnected());
                } else {
                    ops = 8;
                }
                qa.registerChannel(ch, ch.register(this.selector, ops, qa));
                assert (qa.getChannel() == ch) : "Channel was lost.";
            } else {
                this.getLogger().debug("Skipping duplicate reconnect request for %s", qa);
            }
            if (ch == null || ch.isConnected() || ch.isConnectionPending()) continue;
            try {
                ch.close();
            }
            catch (IOException x) {
                this.getLogger().error("Exception closing channel: %s", qa, x);
            }
            continue;
            catch (SocketException e) {
                this.getLogger().warn((Object)"Error on reconnect", e);
                rereQueue.add(qa);
                if (ch == null || ch.isConnected() || ch.isConnectionPending()) continue;
                try {
                    ch.close();
                }
                catch (IOException x) {
                    this.getLogger().error("Exception closing channel: %s", qa, x);
                }
                continue;
            }
            catch (Exception e2) {
                this.getLogger().error("Exception on reconnect, lost node %s", qa, e2);
                if (ch == null || ch.isConnected() || ch.isConnectionPending()) continue;
                {
                    catch (Throwable throwable) {
                        if (ch != null && !ch.isConnected() && !ch.isConnectionPending()) {
                            try {
                                ch.close();
                            }
                            catch (IOException x) {
                                this.getLogger().error("Exception closing channel: %s", qa, x);
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    ch.close();
                }
                catch (IOException x) {
                    this.getLogger().error("Exception closing channel: %s", qa, x);
                }
            }
        }
        for (MemcachedNode n : rereQueue) {
            this.queueReconnect(n);
        }
    }

    NodeLocator getLocator() {
        return this.locator;
    }

    public void addOperation(String key, Operation o) {
        MemcachedNode placeIn = null;
        MemcachedNode primary = this.locator.getPrimary(key);
        if (primary.isActive() || this.failureMode == FailureMode.Retry) {
            placeIn = primary;
        } else if (this.failureMode == FailureMode.Cancel) {
            o.cancel();
        } else {
            Iterator<MemcachedNode> i = this.locator.getSequence(key);
            while (placeIn == null && i.hasNext()) {
                MemcachedNode n = i.next();
                if (!n.isActive()) continue;
                placeIn = n;
            }
            if (placeIn == null) {
                placeIn = primary;
                this.getLogger().warn("Could not redistribute to another node, retrying primary node for %s.", key);
            }
        }
        assert (o.isCancelled() || placeIn != null) : "No node found for key " + key;
        if (placeIn != null) {
            if (this.locator instanceof VBucketNodeLocator) {
                VBucketNodeLocator vbucketLocator = (VBucketNodeLocator)this.locator;
                short vbucketIndex = (short)vbucketLocator.getVBucketIndex(key);
                if (o instanceof VBucketAware) {
                    MemcachedNode alternative;
                    VBucketAware vbucketAwareOp = (VBucketAware)((Object)o);
                    vbucketAwareOp.setVBucket(key, vbucketIndex);
                    if (!vbucketAwareOp.getNotMyVbucketNodes().isEmpty() && (alternative = vbucketLocator.getAlternative(key, vbucketAwareOp.getNotMyVbucketNodes())) != null) {
                        placeIn = alternative;
                    }
                }
            }
            this.addOperation(placeIn, o);
        } else assert (o.isCancelled()) : "No node found for " + key + " (and not immediately cancelled)";
    }

    public void insertOperation(MemcachedNode node, Operation o) {
        o.setHandlingNode(node);
        o.initialize();
        node.insertOp(o);
        this.addedQueue.offer(node);
        Selector s = this.selector.wakeup();
        assert (s == this.selector) : "Wakeup returned the wrong selector.";
        this.getLogger().debug("Added %s to %s", o, node);
    }

    private void addOperation(MemcachedNode node, Operation o) {
        o.setHandlingNode(node);
        o.initialize();
        node.addOp(o);
        this.addedQueue.offer(node);
        Selector s = this.selector.wakeup();
        assert (s == this.selector) : "Wakeup returned the wrong selector.";
        this.getLogger().debug("Added %s to %s", o, node);
    }

    public void addOperations(Map<MemcachedNode, Operation> ops) {
        for (Map.Entry<MemcachedNode, Operation> me : ops.entrySet()) {
            MemcachedNode node = me.getKey();
            Operation o = me.getValue();
            if (this.locator instanceof VBucketNodeLocator && o instanceof KeyedOperation && o instanceof VBucketAware) {
                Collection<String> keys = ((KeyedOperation)o).getKeys();
                VBucketNodeLocator vbucketLocator = (VBucketNodeLocator)this.locator;
                for (String key : keys) {
                    short vbucketIndex = (short)vbucketLocator.getVBucketIndex(key);
                    VBucketAware vbucketAwareOp = (VBucketAware)((Object)o);
                    vbucketAwareOp.setVBucket(key, vbucketIndex);
                }
            }
            o.setHandlingNode(node);
            o.initialize();
            node.addOp(o);
            this.addedQueue.offer(node);
        }
        Selector s = this.selector.wakeup();
        assert (s == this.selector) : "Wakeup returned the wrong selector.";
    }

    public CountDownLatch broadcastOperation(BroadcastOpFactory of) {
        return this.broadcastOperation(of, this.locator.getAll());
    }

    public CountDownLatch broadcastOperation(BroadcastOpFactory of, Collection<MemcachedNode> nodes) {
        CountDownLatch latch = new CountDownLatch(this.locator.getAll().size());
        for (MemcachedNode node : nodes) {
            Operation op = of.newOp(node, latch);
            op.initialize();
            node.addOp(op);
            op.setHandlingNode(node);
            this.addedQueue.offer(node);
        }
        Selector s = this.selector.wakeup();
        assert (s == this.selector) : "Wakeup returned the wrong selector.";
        return latch;
    }

    public void shutdown() throws IOException {
        this.shutDown = true;
        Selector s = this.selector.wakeup();
        assert (s == this.selector) : "Wakeup returned the wrong selector.";
        for (MemcachedNode qa : this.locator.getAll()) {
            if (qa.getChannel() == null) continue;
            qa.getChannel().close();
            qa.setSk(null);
            if (qa.getBytesRemainingToWrite() > 0) {
                this.getLogger().warn("Shut down with %d bytes remaining to write", qa.getBytesRemainingToWrite());
            }
            this.getLogger().debug("Shut down channel %s", qa.getChannel());
        }
        this.selector.close();
        this.getLogger().debug("Shut down selector %s", this.selector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{MemcachedConnection to");
        for (MemcachedNode qa : this.locator.getAll()) {
            sb.append(" ");
            sb.append(qa.getSocketAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public static void opTimedOut(Operation op) {
        MemcachedConnection.setTimeout(op, true);
    }

    public static void opSucceeded(Operation op) {
        MemcachedConnection.setTimeout(op, false);
    }

    private static void setTimeout(Operation op, boolean isTimeout) {
        try {
            if (op == null || op.isTimedOutUnsent()) {
                return;
            }
            MemcachedNode node = op.getHandlingNode();
            if (node == null) {
                LoggerFactory.getLogger(MemcachedConnection.class).warn("handling node for operation is not set");
            } else {
                node.setContinuousTimeout(isTimeout);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(MemcachedConnection.class).error(e.getMessage());
        }
    }
}

