/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.protocol.binary.OperationImpl;

public class OptimizedSetImpl
extends OperationImpl
implements Operation {
    private static final OperationCallback NOOP_CALLBACK = new NoopCallback();
    private final int terminalOpaque = OptimizedSetImpl.generateOpaque();
    private final Map<Integer, OperationCallback> callbacks = new HashMap<Integer, OperationCallback>();
    private final List<CASOperation> ops = new ArrayList<CASOperation>();
    private int byteCount = 24;

    public OptimizedSetImpl(CASOperation firstStore) {
        super(-1, -1, NOOP_CALLBACK);
        this.addOperation(firstStore);
    }

    public void addOperation(CASOperation op) {
        this.ops.add(op);
        Iterator<String> is = op.getKeys().iterator();
        String k = is.next();
        int keylen = KeyUtil.getKeyBytes(k).length;
        this.byteCount += 32 + keylen + op.getBytes().length;
    }

    public int size() {
        return this.ops.size();
    }

    public int bytes() {
        return this.byteCount;
    }

    public void initialize() {
        ByteBuffer bb = ByteBuffer.allocate(this.byteCount);
        for (CASOperation so : this.ops) {
            Iterator<String> is = so.getKeys().iterator();
            String k = is.next();
            byte[] keyBytes = KeyUtil.getKeyBytes(k);
            assert (!is.hasNext());
            int myOpaque = OptimizedSetImpl.generateOpaque();
            this.callbacks.put(myOpaque, so.getCallback());
            byte[] data = so.getBytes();
            bb.put((byte)-128);
            bb.put((byte)OptimizedSetImpl.cmdMap(so.getStoreType()));
            bb.putShort((short)keyBytes.length);
            bb.put((byte)8);
            bb.put((byte)0);
            bb.putShort((short)0);
            bb.putInt(keyBytes.length + data.length + 8);
            bb.putInt(myOpaque);
            bb.putLong(so.getCasValue());
            bb.putInt(so.getFlags());
            bb.putInt(so.getExpiration());
            bb.put(keyBytes);
            bb.put(data);
        }
        bb.put((byte)-128);
        bb.put((byte)10);
        bb.putShort((short)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.putShort((short)0);
        bb.putInt(0);
        bb.putInt(this.terminalOpaque);
        bb.putLong(0L);
        bb.flip();
        this.setBuffer(bb);
    }

    private static int cmdMap(StoreType t) {
        int rv = -1;
        switch (t) {
            case set: {
                rv = 17;
                break;
            }
            case add: {
                rv = 18;
                break;
            }
            case replace: {
                rv = 19;
            }
        }
        assert (rv != -1) : "Unhandled store type:  " + (Object)((Object)t);
        return rv;
    }

    protected void finishedPayload(byte[] pl) throws IOException {
        if (this.responseOpaque == this.terminalOpaque) {
            for (OperationCallback cb : this.callbacks.values()) {
                cb.receivedStatus(STATUS_OK);
                cb.complete();
            }
            this.transitionState(OperationState.COMPLETE);
        } else {
            OperationCallback cb = this.callbacks.remove(this.responseOpaque);
            assert (cb != null) : "No callback for " + this.responseOpaque;
            assert (this.errorCode != 0) : "Got no error on a quiet mutation.";
            OperationStatus status = this.getStatusForErrorCode(this.errorCode, pl);
            assert (status != null) : "Got no status for a quiet mutation error";
            cb.receivedStatus(status);
            cb.complete();
        }
        this.resetInput();
    }

    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        OperationStatus rv = null;
        switch (errCode) {
            case 2: {
                rv = EXISTS_STATUS;
                break;
            }
            case 1: {
                rv = NOT_FOUND_STATUS;
            }
        }
        return rv;
    }

    protected boolean opaqueIsValid() {
        return this.responseOpaque == this.terminalOpaque || this.callbacks.containsKey(this.responseOpaque);
    }

    static class NoopCallback
    implements OperationCallback {
        NoopCallback() {
        }

        public void complete() {
        }

        public void receivedStatus(OperationStatus status) {
        }
    }
}

