/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.config;

import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigDifference;
import com.couchbase.client.vbucket.config.ConfigType;
import com.couchbase.client.vbucket.config.VBucket;
import java.net.URL;
import java.util.List;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.HashAlgorithm;

public class CacheConfig
implements Config {
    private final HashAlgorithm hashAlgorithm = DefaultHashAlgorithm.NATIVE_HASH;
    private int vbucketsCount;
    private final int serversCount;
    private List<String> servers;
    private List<VBucket> vbuckets;

    public CacheConfig(int serversCount) {
        this.serversCount = serversCount;
    }

    @Override
    public int getReplicasCount() {
        throw new IllegalArgumentException("TODO: refactor this");
    }

    @Override
    public int getVbucketsCount() {
        throw new IllegalArgumentException("TODO: refactor this");
    }

    @Override
    public int getServersCount() {
        return this.serversCount;
    }

    @Override
    public String getServer(int serverIndex) {
        if (serverIndex > this.servers.size() - 1) {
            throw new IllegalArgumentException("Server index is out of bounds, index = " + serverIndex + ", servers count = " + this.servers.size());
        }
        return this.servers.get(serverIndex);
    }

    @Override
    public int getVbucketByKey(String key) {
        throw new IllegalArgumentException("TODO: refactor this");
    }

    @Override
    public int getMaster(int vbucketIndex) {
        throw new IllegalArgumentException("TODO: refactor this");
    }

    @Override
    public int getReplica(int vbucketIndex, int replicaIndex) {
        throw new IllegalArgumentException("TODO: refactor this");
    }

    @Override
    public int foundIncorrectMaster(int vbucket, int wrongServer) {
        throw new IllegalArgumentException("TODO: refactor this");
    }

    public void setServers(List<String> newServers) {
        this.servers = newServers;
    }

    public void setVbuckets(List<VBucket> newVbuckets) {
        this.vbuckets = newVbuckets;
    }

    @Override
    public List<String> getServers() {
        return this.servers;
    }

    @Override
    public List<VBucket> getVbuckets() {
        return this.vbuckets;
    }

    @Override
    public ConfigDifference compareTo(Config config) {
        ConfigDifference difference = new ConfigDifference();
        if (this.serversCount == config.getServersCount()) {
            difference.setSequenceChanged(false);
            for (int i = 0; i < this.serversCount; ++i) {
                if (this.getServer(i).equals(config.getServer(i))) continue;
                difference.setSequenceChanged(true);
                break;
            }
        } else {
            difference.setSequenceChanged(true);
        }
        if (this.vbucketsCount == config.getVbucketsCount()) {
            int vbucketsChanges = 0;
            for (int i = 0; i < this.vbucketsCount; ++i) {
                vbucketsChanges += this.getMaster(i) == config.getMaster(i) ? 0 : 1;
            }
            difference.setVbucketsChanges(vbucketsChanges);
        } else {
            difference.setVbucketsChanges(-1);
        }
        return difference;
    }

    @Override
    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.MEMCACHE;
    }

    @Override
    public List<URL> getCouchServers() {
        throw new UnsupportedOperationException("No couch port for cache buckets");
    }
}

