/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.BackupSessionService;
import de.javakaffee.web.msm.BackupSessionTask;
import de.javakaffee.web.msm.LRUCache;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.ReadOnlyRequestsCache;
import de.javakaffee.web.msm.SessionTrackerValve;
import de.javakaffee.web.msm.Statistics;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import net.spy.memcached.MemcachedClient;
import org.apache.catalina.connector.Request;

public class LockingStrategyAuto
extends LockingStrategy {
    private final ExecutorService _requestPatternDetectionExecutor = Executors.newSingleThreadExecutor();
    private final ReadOnlyRequestsCache _readOnlyRequestCache = new ReadOnlyRequestsCache();

    public LockingStrategyAuto(@Nonnull MemcachedSessionService manager, @Nonnull MemcachedClient memcached, @Nonnull LRUCache<String, Boolean> missingSessionsCache, boolean storeSecondaryBackup, @Nonnull Statistics stats) {
        super(manager, memcached, missingSessionsCache, storeSecondaryBackup, stats);
    }

    @Override
    protected void onBackupWithoutLoadedSession(@Nonnull String sessionId, @Nonnull String requestId, @Nonnull BackupSessionService backupSessionService) {
        if (!this._sessionIdFormat.isValid(sessionId)) {
            return;
        }
        super.onBackupWithoutLoadedSession(sessionId, requestId, backupSessionService);
        this._readOnlyRequestCache.readOnlyRequest(requestId);
    }

    @Override
    protected void onAfterBackupSession(MemcachedBackupSession session, boolean backupWasForced, final Future<BackupSessionTask.BackupResult> result, final String requestId, BackupSessionService backupSessionService) {
        if (!this._sessionIdFormat.isValid(session.getIdInternal())) {
            return;
        }
        super.onAfterBackupSession(session, backupWasForced, result, requestId, backupSessionService);
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    if (((BackupSessionTask.BackupResult)result.get()).getStatus() == SessionTrackerValve.SessionBackupService.BackupResultStatus.SKIPPED) {
                        LockingStrategyAuto.this._readOnlyRequestCache.readOnlyRequest(requestId);
                    } else {
                        LockingStrategyAuto.this._readOnlyRequestCache.modifyingRequest(requestId);
                    }
                }
                catch (Exception e) {
                    LockingStrategyAuto.this._readOnlyRequestCache.modifyingRequest(requestId);
                }
                return null;
            }
        };
        if (result instanceof BackupSessionService.SimpleFuture) {
            try {
                task.call();
            }
            catch (Exception e) {}
        } else {
            this._requestPatternDetectionExecutor.submit(task);
        }
    }

    @Override
    protected MemcachedSessionService.LockStatus onBeforeLoadFromMemcached(String sessionId) throws InterruptedException, ExecutionException {
        Request request = (Request)this._requestsThreadLocal.get();
        if (request == null) {
            throw new RuntimeException("There's no request set, this indicates that this findSessionwas triggered by the container which should already be handled in findSession.");
        }
        if (this._readOnlyRequestCache.isReadOnlyRequest(SessionTrackerValve.getURIWithQueryString(request))) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Not getting lock for readonly request " + SessionTrackerValve.getURIWithQueryString(request)));
            }
            this._stats.nonStickySessionsReadOnlyRequest();
            return MemcachedSessionService.LockStatus.LOCK_NOT_REQUIRED;
        }
        return this.lock(sessionId);
    }
}

