/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.ws;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javolution.io.AppendableWriter;
import javolution.io.UTF8StreamWriter;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLStreamWriter;

public abstract class WebServiceClient {
    public static final String ENVELOPE_PREFIX = "env";
    public static final String ENVELOPE_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    Object _url;
    private final TextBuilder _buffer = new TextBuilder();
    private final AppendableWriter _out = new AppendableWriter();
    private final XMLObjectWriter _writer = new XMLObjectWriter();
    private final UTF8StreamWriter _utf8Writer = new UTF8StreamWriter();
    private final XMLObjectReader _reader = new XMLObjectReader();

    public WebServiceClient setAddress(String address) {
        try {
            this._url = new URL(address);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + address);
        }
        return this;
    }

    public void invoke() throws IOException, XMLStreamException {
        try {
            this._out.setOutput(this._buffer);
            this._writer.setOutput(this._out);
            XMLStreamWriter xmlOut = this._writer.getStreamWriter();
            xmlOut.setPrefix(WebServiceClient.csq(ENVELOPE_PREFIX), WebServiceClient.csq(ENVELOPE_URI));
            xmlOut.writeStartElement(WebServiceClient.csq(ENVELOPE_URI), WebServiceClient.csq("Envelope"));
            xmlOut.writeNamespace(WebServiceClient.csq(ENVELOPE_PREFIX), WebServiceClient.csq(ENVELOPE_URI));
            xmlOut.writeStartElement(WebServiceClient.csq(ENVELOPE_URI), WebServiceClient.csq("Header"));
            xmlOut.writeEndElement();
            xmlOut.writeStartElement(WebServiceClient.csq(ENVELOPE_URI), WebServiceClient.csq("Body"));
            this.writeRequest(this._writer);
            this._writer.close();
            if (this._url == null) {
                throw new IOException("URL not set");
            }
            HttpURLConnection http = (HttpURLConnection)((URL)this._url).openConnection();
            http.setRequestProperty("Content-Length", String.valueOf(this._buffer.length()));
            http.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            http.setDoInput(true);
            this._utf8Writer.setOutput(http.getOutputStream());
            this._buffer.print(this._utf8Writer);
            this._utf8Writer.close();
            this._reader.setInput(http.getInputStream());
            XMLStreamReader xmlIn = this._reader.getStreamReader();
            while (xmlIn.hasNext()) {
                if (xmlIn.next() != 1 || !xmlIn.getLocalName().equals("Body") || !xmlIn.getNamespaceURI().equals(ENVELOPE_URI)) continue;
                xmlIn.next();
                this.readResponse(this._reader);
                break;
            }
        }
        finally {
            this._reader.close();
            this._writer.reset();
            this._out.reset();
            this._buffer.reset();
            this._utf8Writer.reset();
            this._reader.reset();
        }
    }

    protected abstract void writeRequest(XMLObjectWriter var1) throws XMLStreamException;

    protected void readResponse(XMLObjectReader in) throws XMLStreamException {
        XMLStreamReader xml = in.getStreamReader();
        block10: while (xml.hasNext()) {
            switch (xml.next()) {
                case 7: {
                    System.out.println("Start Document");
                    break;
                }
                case 8: {
                    System.out.println("End Document.");
                    break;
                }
                case 1: {
                    System.out.println("Start Element: " + xml.getLocalName() + "(" + xml.getNamespaceURI() + ")");
                    int i = 0;
                    int n = xml.getAttributeCount();
                    while (i < n) {
                        System.out.println("   Attribute: " + xml.getAttributeLocalName(i) + "(" + xml.getAttributeNamespace(i) + "), Value: " + xml.getAttributeValue(i));
                        ++i;
                    }
                    continue block10;
                }
                case 2: {
                    if (xml.getLocalName().equals("Body") && xml.getNamespaceURI().equals(ENVELOPE_URI)) {
                        return;
                    }
                    System.out.println("End Element: " + xml.getLocalName() + "(" + xml.getNamespaceURI() + ")");
                    break;
                }
                case 4: {
                    System.out.println("Characters: " + xml.getText());
                    break;
                }
                case 12: {
                    System.out.println("CDATA: " + xml.getText());
                    break;
                }
                case 5: {
                    System.out.println("Comment: " + xml.getText());
                    break;
                }
                case 6: {
                    System.out.println("Space");
                    break;
                }
                default: {
                    System.out.println(xml);
                }
            }
        }
    }

    private static final CharSequence csq(Object string) {
        return string instanceof CharSequence ? (CharSequence)string : Text.valueOf(string);
    }
}

