/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import javax.realtime.MemoryArea;
import javolution.context.ObjectFactory;
import javolution.context.PersistentContext;
import javolution.lang.MathLib;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastList;
import javolution.util.Index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastTable<E>
extends FastCollection<E>
implements List<E>,
Reusable,
RandomAccess {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastTable();
        }
    };
    private static final int B0 = 4;
    private static final int C0 = 16;
    private static final int B1 = 10;
    private static final int C1 = 1024;
    private static final int M1 = 1023;
    private transient E[] _low;
    private transient E[][] _high;
    private transient int _capacity = 16;
    private transient int _size;
    private transient FastComparator<? super E> _valueComparator = FastComparator.DEFAULT;
    private static final Object[] NULL_BLOCK = new Object[1024];
    private static final long serialVersionUID = 1L;
    static volatile int ONE_VOLATILE = 1;

    public FastTable() {
        this._low = new Object[16];
        this._high = new Object[1][];
        this._high[0] = this._low;
    }

    public FastTable(String id) {
        this();
        new PersistentContext.Reference(id, this){

            protected void notifyChange() {
                FastTable.this.clear();
                FastTable.this.addAll((FastList)this.get());
            }
        };
    }

    public FastTable(int capacity) {
        this();
        while (capacity > this._capacity) {
        }
    }

    public FastTable(Collection<? extends E> values) {
        this(values.size());
        this.addAll(values);
    }

    public static <E> FastTable<E> newInstance() {
        return (FastTable)FACTORY.object();
    }

    public static void recycle(FastTable instance) {
        FACTORY.recycle(instance);
    }

    public void setSize(int size) {
        while (this._size < size) {
            this.addLast(null);
        }
        while (this._size > size) {
            this.removeLast();
        }
    }

    @Override
    public final E get(int index) {
        if (index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        return index < 1024 ? this._low[index] : this._high[index >> 10][index & 0x3FF];
    }

    @Override
    public final E set(int index, E value) {
        if (index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        E[] low = this._high[index >> 10];
        E previous = low[index & 0x3FF];
        low[index & 0x3FF] = value;
        return previous;
    }

    @Override
    public final boolean add(E value) {
        if (this._size >= this._capacity) {
            this.increaseCapacity();
        }
        this._high[this._size >> 10][this._size & 0x3FF] = value;
        this._size += ONE_VOLATILE;
        return true;
    }

    @Override
    public final E getFirst() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this._low[0];
    }

    @Override
    public final E getLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this._size - 1);
    }

    @Override
    public final void addLast(E value) {
        this.add(value);
    }

    @Override
    public final E removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        E[] low = this._high[this._size >> 10];
        E previous = low[this._size & 0x3FF];
        low[this._size & 0x3FF] = null;
        return previous;
    }

    @Override
    public final void clear() {
        int i = 0;
        while (i < this._size) {
            int count = MathLib.min(this._size - i, 1024);
            E[] low = this._high[i >> 10];
            System.arraycopy(NULL_BLOCK, 0, low, 0, count);
            i += 1024;
        }
        this._size = 0;
    }

    @Override
    public void reset() {
        this.clear();
        this.setValueComparator(FastComparator.DEFAULT);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int shift = values.size();
        this.shiftRight(index, shift);
        Iterator<E> valuesIterator = values.iterator();
        int i = index;
        int n = index + shift;
        while (i < n) {
            this._high[i >> 10][i & 0x3FF] = valuesIterator.next();
            ++i;
        }
        this._size += shift * ONE_VOLATILE;
        return shift != 0;
    }

    @Override
    public final void add(int index, E value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.shiftRight(index, 1);
        this._high[index >> 10][index & 0x3FF] = value;
        this._size += ONE_VOLATILE;
    }

    @Override
    public final E remove(int index) {
        E previous = this.get(index);
        this.shiftLeft(index + 1, 1);
        --this._size;
        this._high[this._size >> 10][this._size & 0x3FF] = null;
        return previous;
    }

    public final void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < 0 || fromIndex > toIndex || toIndex > this._size) {
            throw new IndexOutOfBoundsException("FastTable removeRange(" + fromIndex + ", " + toIndex + ") index out of bounds, size: " + this._size);
        }
        int shift = toIndex - fromIndex;
        this.shiftLeft(toIndex, shift);
        this._size -= shift;
        int i = this._size;
        int n = this._size + shift;
        while (i < n) {
            this._high[i >> 10][i & 0x3FF] = null;
            ++i;
        }
    }

    @Override
    public final int indexOf(Object value) {
        FastComparator<E> comp = this.getValueComparator();
        int i = 0;
        while (i < this._size) {
            E[] low = this._high[i >> 10];
            int count = MathLib.min(low.length, this._size - i);
            int j = 0;
            while (j < count) {
                if (comp == FastComparator.DEFAULT ? FastTable.defaultEquals(value, low[j]) : comp.areEqual(value, low[j])) {
                    return i + j;
                }
                ++j;
            }
            i += count;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object value) {
        FastComparator<E> comp = this.getValueComparator();
        int i = this._size - 1;
        while (i >= 0) {
            int count;
            E[] low = this._high[i >> 10];
            int j = count = (i & 0x3FF) + 1;
            while (--j >= 0) {
                if (!(comp == FastComparator.DEFAULT ? FastTable.defaultEquals(value, low[j]) : comp.areEqual(value, low[j]))) continue;
                return i + j - count + 1;
            }
            i -= count;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return FastTableIterator.valueOf(this, 0, 0, this._size);
    }

    @Override
    public ListIterator<E> listIterator() {
        return FastTableIterator.valueOf(this, 0, 0, this._size);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException();
        }
        return FastTableIterator.valueOf(this, index, 0, this._size);
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubTable.valueOf(this, fromIndex, toIndex - fromIndex);
    }

    public final void trimToSize() {
        while (this._capacity - this._size > 1024) {
            this._capacity -= 1024;
            this._high[this._capacity >> 10] = null;
        }
    }

    public final FastTable<E> sort() {
        if (this._size > 1) {
            this.quicksort(0, this._size - 1, this.getValueComparator());
        }
        return this;
    }

    private void quicksort(int first, int last, FastComparator cmp) {
        int pivIndex = 0;
        if (first < last) {
            pivIndex = this.partition(first, last, cmp);
            this.quicksort(first, pivIndex - 1, cmp);
            this.quicksort(pivIndex + 1, last, cmp);
        }
    }

    private int partition(int f, int l, FastComparator cmp) {
        E piv = this.get(f);
        int up = f;
        int down = l;
        while (true) {
            if (cmp.compare(this.get(up), piv) <= 0 && up < l) {
                ++up;
                continue;
            }
            while (cmp.compare(this.get(down), piv) > 0 && down > f) {
                --down;
            }
            if (up < down) {
                E temp = this.get(up);
                this.set(up, this.get(down));
                this.set(down, temp);
            }
            if (down <= up) break;
        }
        this.set(f, this.get(down));
        this.set(down, piv);
        return down;
    }

    public FastTable<E> setValueComparator(FastComparator<? super E> comparator) {
        this._valueComparator = comparator;
        return this;
    }

    @Override
    public FastComparator<? super E> getValueComparator() {
        return this._valueComparator;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final FastCollection.Record head() {
        return Index.valueOf(-1);
    }

    @Override
    public final FastCollection.Record tail() {
        return Index.valueOf(this._size);
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return this.get(((Index)record).intValue());
    }

    @Override
    public final void delete(FastCollection.Record record) {
        this.remove(((Index)record).intValue());
    }

    @Override
    public List<E> unmodifiable() {
        return (List)super.unmodifiable();
    }

    @Override
    public final boolean contains(Object value) {
        return this.indexOf(value) >= 0;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.setValueComparator((FastComparator)stream.readObject());
        int size = stream.readInt();
        this._capacity = 16;
        while (this._capacity < this._size && this._capacity < 1024) {
            this._capacity <<= 1;
        }
        this._low = new Object[this._capacity];
        this._high = new Object[1][];
        this._high[0] = this._low;
        int i = 0;
        while (i < size) {
            this.addLast(stream.readObject());
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getValueComparator());
        int size = this._size;
        stream.writeInt(size);
        int i = 0;
        while (i < size) {
            stream.writeObject(this.get(i));
            ++i;
        }
    }

    protected final int getCapacity() {
        return this._capacity;
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                if (FastTable.this._capacity < 1024) {
                    FastTable fastTable = FastTable.this;
                    fastTable._capacity = fastTable._capacity << 1;
                    Object[] tmp = new Object[FastTable.this._capacity];
                    System.arraycopy(FastTable.this._low, 0, tmp, 0, FastTable.this._size);
                    FastTable.this._low = tmp;
                    ((FastTable)FastTable.this)._high[0] = tmp;
                } else {
                    int j = FastTable.this._capacity >> 10;
                    if (j >= FastTable.this._high.length) {
                        Object[][] tmp = new Object[FastTable.this._high.length * 2][];
                        System.arraycopy(FastTable.this._high, 0, tmp, 0, FastTable.this._high.length);
                        FastTable.this._high = tmp;
                    }
                    ((FastTable)FastTable.this)._high[j] = new Object[1024];
                    FastTable fastTable = FastTable.this;
                    fastTable._capacity = fastTable._capacity + 1024;
                }
            }
        });
    }

    private void shiftRight(int index, int shift) {
        while (this._size + shift >= this._capacity) {
            this.increaseCapacity();
        }
        int i = this._size;
        while (--i >= index) {
            int dest = i + shift;
            this._high[dest >> 10][dest & 0x3FF] = this._high[i >> 10][i & 0x3FF];
        }
    }

    private void shiftLeft(int index, int shift) {
        int i = index;
        while (i < this._size) {
            int dest = i - shift;
            this._high[dest >> 10][dest & 0x3FF] = this._high[i >> 10][i & 0x3FF];
            ++i;
        }
    }

    private static boolean defaultEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
    }

    private static final class FastTableIterator
    implements ListIterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new FastTableIterator();
            }

            protected void cleanup(Object obj) {
                FastTableIterator i = (FastTableIterator)obj;
                i._table = null;
                i._low = null;
                i._high = null;
            }
        };
        private FastTable _table;
        private int _currentIndex;
        private int _start;
        private int _end;
        private int _nextIndex;
        private Object[] _low;
        private Object[][] _high;

        private FastTableIterator() {
        }

        public static FastTableIterator valueOf(FastTable table, int nextIndex, int start, int end) {
            FastTableIterator iterator = (FastTableIterator)FACTORY.object();
            iterator._table = table;
            iterator._start = start;
            iterator._end = end;
            iterator._nextIndex = nextIndex;
            iterator._low = table._low;
            iterator._high = table._high;
            iterator._currentIndex = -1;
            return iterator;
        }

        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        public Object next() {
            int i;
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            return (i = (this._currentIndex = this._nextIndex++)) < 1024 ? this._low[i] : this._high[i >> 10][i & 0x3FF];
        }

        public int nextIndex() {
            return this._nextIndex;
        }

        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        public Object previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            int i = this._nextIndex;
            return i < 1024 ? this._low[i] : this._high[i >> 10][i & 0x3FF];
        }

        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void add(Object o) {
            this._table.add(this._nextIndex++, o);
            ++this._end;
            this._currentIndex = -1;
        }

        public void set(Object o) {
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._table.set(this._currentIndex, o);
        }

        public void remove() {
            if (this._currentIndex >= 0) {
                this._table.remove(this._currentIndex);
                --this._end;
                if (this._currentIndex < this._nextIndex) {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this._currentIndex = -1;
        }
    }

    private static final class SubTable
    extends FastCollection
    implements List,
    RandomAccess {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new SubTable();
            }

            protected void cleanup(Object obj) {
                SubTable st = (SubTable)obj;
                st._table = null;
            }
        };
        private FastTable _table;
        private int _offset;
        private int _size;

        private SubTable() {
        }

        public static SubTable valueOf(FastTable table, int offset, int size) {
            SubTable subTable = (SubTable)FACTORY.object();
            subTable._table = table;
            subTable._offset = offset;
            subTable._size = size;
            return subTable;
        }

        public int size() {
            return this._size;
        }

        public FastCollection.Record head() {
            return Index.valueOf(-1);
        }

        public FastCollection.Record tail() {
            return Index.valueOf(this._size);
        }

        public Object valueOf(FastCollection.Record record) {
            return this._table.get(((Index)record).intValue() + this._offset);
        }

        public void delete(FastCollection.Record record) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        public boolean addAll(int index, Collection values) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        public Object get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this._table.get(index + this._offset);
        }

        public Object set(int index, Object value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this._table.set(index + this._offset, value);
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        public int indexOf(Object value) {
            FastComparator comp = this._table.getValueComparator();
            int i = -1;
            while (++i < this._size) {
                if (!comp.areEqual(value, this._table.get(i + this._offset))) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(Object value) {
            FastComparator comp = this._table.getValueComparator();
            int i = this._size;
            while (--i >= 0) {
                if (!comp.areEqual(value, this._table.get(i + this._offset))) continue;
                return i;
            }
            return -1;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return FastTableIterator.valueOf(this._table, index + this._offset, this._offset, this._offset + this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for table of size: " + this._size);
        }

        public List subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            return SubTable.valueOf(this._table, this._offset + fromIndex, toIndex - fromIndex);
        }
    }
}

