/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

public class TinyAttributeCollection
implements AttributeCollection {
    int element;
    TinyTree tree;
    int firstAttribute;

    public TinyAttributeCollection(TinyTree tree, int element) {
        this.tree = tree;
        this.element = element;
        this.firstAttribute = tree.alpha[element];
    }

    @Override
    public int getLength() {
        int i;
        for (i = this.firstAttribute; i < this.tree.numberOfAttributes && this.tree.attParent[i] == this.element; ++i) {
        }
        return i - this.firstAttribute;
    }

    @Override
    public int getFingerprint(int index) {
        int nc = this.tree.attCode[this.firstAttribute + index];
        return nc == -1 ? -1 : nc & 0xFFFFF;
    }

    @Override
    public NodeName getNodeName(int index) {
        return new CodedName(this.tree.attCode[this.firstAttribute + index], this.getPrefix(index), this.tree.getNamePool());
    }

    @Override
    public SimpleType getTypeAnnotation(int index) {
        if (this.tree.attType == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return this.tree.getAttributeType(this.firstAttribute + index);
    }

    @Override
    public Location getLocation(int index) {
        return ExplicitLocation.UNKNOWN_LOCATION;
    }

    @Override
    public String getSystemId(int index) {
        return this.tree.getSystemId(this.element);
    }

    @Override
    public int getLineNumber(int index) {
        return -1;
    }

    @Override
    public int getProperties(int index) {
        return 0;
    }

    @Override
    public String getPrefix(int index) {
        return this.tree.prefixPool.getPrefix(this.tree.attCode[this.firstAttribute + index] >> 20);
    }

    @Override
    public String getQName(int index) {
        return this.getNodeName(index).getDisplayName();
    }

    @Override
    public String getLocalName(int index) {
        return this.tree.getNamePool().getLocalName(this.tree.attCode[this.firstAttribute + index]);
    }

    @Override
    public String getURI(int index) {
        return this.tree.getNamePool().getURI(this.tree.attCode[this.firstAttribute + index]);
    }

    @Override
    public int getIndex(String uri, String localname) {
        int fingerprint = this.tree.getNamePool().getFingerprint(uri, localname);
        return this.getIndexByFingerprint(fingerprint);
    }

    @Override
    public int getIndexByFingerprint(int fingerprint) {
        int i = this.firstAttribute;
        while (this.tree.attParent[i] == this.element) {
            if ((this.tree.attCode[i] & 0xFFFFF) == fingerprint) {
                return i - this.firstAttribute;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String getValueByFingerprint(int fingerprint) {
        return this.getValue(this.getIndexByFingerprint(fingerprint));
    }

    @Override
    public String getValue(String uri, String localname) {
        return this.getValue(this.getIndex(uri, localname));
    }

    @Override
    public String getValue(int index) {
        CharSequence cs = this.tree.attValue[this.firstAttribute + index];
        return cs == null ? null : cs.toString();
    }

    @Override
    public boolean isId(int index) {
        return this.getTypeAnnotation(index).getFingerprint() == 560 || (this.tree.attCode[this.firstAttribute + index] & 0xFFFFF) == 388;
    }

    @Override
    public boolean isIdref(int index) {
        return this.getTypeAnnotation(index).getFingerprint() == 561 || this.getTypeAnnotation(index).getFingerprint() == 562;
    }
}

