/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class JDateField
extends JTextField {
    private static final long serialVersionUID = 240L;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final int[] FIELD_POSITIONS = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 5, 5, 5, 11, 11, 11, 12, 12, 12, 13, 13, 13};

    public JDateField(Date date) {
        super(20);
        this.addKeyListener(new KeyFocus());
        this.addFocusListener(new FocusClass());
        String myString = this.dateFormat.format(date);
        this.setText(myString);
    }

    public JDateField() {
        this(new Date());
    }

    public void setDate(Date date) {
        this.setText(this.dateFormat.format(date));
    }

    public Date getDate() {
        try {
            return this.dateFormat.parse(this.getText());
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    private static int posToField(int pos) {
        if (pos >= FIELD_POSITIONS.length) {
            pos = FIELD_POSITIONS.length - 1;
        }
        return FIELD_POSITIONS[pos];
    }

    private Calendar parseDate(String datetime) {
        Calendar c = Calendar.getInstance();
        try {
            Date dat = this.dateFormat.parse(datetime);
            c.setTime(dat);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return c;
    }

    private void update(int addend, boolean shifted) {
        Calendar c = this.parseDate(this.getText());
        int pos = this.getCaretPosition();
        int field = JDateField.posToField(pos);
        if (shifted) {
            c.roll(field, true);
        } else {
            c.add(field, addend);
        }
        String newDate = this.dateFormat.format(c.getTime());
        this.setText(newDate);
        if (pos > newDate.length()) {
            pos = newDate.length();
        }
        int newPosition = pos;
        SwingUtilities.invokeLater(() -> this.setCaretPosition(newPosition));
    }

    class FocusClass
    implements FocusListener {
        FocusClass() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (JDateField.this.getText() == null || JDateField.this.getText().isEmpty()) {
                return;
            }
            try {
                JDateField.this.dateFormat.parse(JDateField.this.getText());
            }
            catch (ParseException e1) {
                JDateField.this.requestFocusInWindow();
            }
        }
    }

    class KeyFocus
    extends KeyAdapter {
        KeyFocus() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38) {
                JDateField.this.update(1, e.isShiftDown());
            } else if (e.getKeyCode() == 40) {
                JDateField.this.update(-1, e.isShiftDown());
            }
        }
    }
}

