/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.regex.RegExCache;
import com.helger.commons.string.StringHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSParseHelper {
    public static final char URL_ESCAPE_CHAR = '\\';
    @RegEx
    private static final String SPLIT_NUMBER_REGEX = "^([0-9]*\\.[0-9]+|[0-9]+).*$";
    private static final Pattern SPLIT_NUMBER_PATTERN = RegExCache.getPattern((String)"^([0-9]*\\.[0-9]+|[0-9]+).*$");
    private static final CSSParseHelper s_aInstance = new CSSParseHelper();

    private CSSParseHelper() {
    }

    @Nonnull
    private static String _trimBy(@Nonnull CharSequence charSequence, int n, int n2) {
        return charSequence.toString().substring(n, charSequence.length() - n2);
    }

    @Nullable
    public static String extractStringValue(@Nullable String string) {
        if (StringHelper.hasNoText((String)string) || string.length() < 2) {
            return string;
        }
        char c = string.charAt(0);
        if ((c == '\"' || c == '\'') && StringHelper.getLastChar((CharSequence)string) == c) {
            return CSSParseHelper._trimBy(string, 1, 1);
        }
        return string;
    }

    @Nonnull
    public static String unescapeURL(@Nonnull String string) {
        int n = string.indexOf(92);
        if (n < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        do {
            stringBuilder.append(string, n2, n);
            stringBuilder.append(string, n + 1, n + 2);
        } while ((n = string.indexOf(92, n2 = n + 2)) >= 0);
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    @Nonnull
    public static String trimUrl(@Nonnull CharSequence charSequence) {
        String string = CSSParseHelper._trimBy(charSequence, "url(".length(), ")".length()).trim();
        String string2 = CSSParseHelper.extractStringValue(string);
        return CSSParseHelper.unescapeURL(string2);
    }

    @Nonnull
    public static String splitNumber(@Nonnull StringBuilder stringBuilder) {
        Matcher matcher = SPLIT_NUMBER_PATTERN.matcher(stringBuilder);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    @Nonnull
    public static String validateIdentifier(@Nonnull StringBuilder stringBuilder) {
        char c;
        int n = stringBuilder.length();
        char c2 = stringBuilder.charAt(0);
        char c3 = c = n <= 1 ? (char)'\u0000' : stringBuilder.charAt(1);
        if (c2 == '-' || c2 == '$' || c2 == '*') {
            if (n > 1 && Character.isDigit(c)) {
                throw new IllegalArgumentException("Identifier may not start with a hyphen and a digit: " + stringBuilder);
            }
        } else if (Character.isDigit(c2)) {
            throw new IllegalArgumentException("Identifier may not start with a digit: " + stringBuilder);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String unescapeUnicode(StringBuilder stringBuilder) {
        return stringBuilder.toString();
    }

    @Nonnull
    public static String unescapeOther(StringBuilder stringBuilder) {
        return stringBuilder.toString();
    }
}

