/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.DerivableIcon;
import com.github.weisj.darklaf.icons.IconColorMapper;
import com.github.weisj.darklaf.icons.ImageSource;
import com.github.weisj.darklaf.icons.RotateIcon;
import com.github.weisj.darklaf.icons.ThemedSVGIcon;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Scale;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class DarkSVGIcon
implements DerivableIcon<DarkSVGIcon>,
RotateIcon,
Serializable,
ImageSource {
    private static final Logger LOGGER = LogUtil.getLogger(DarkSVGIcon.class);
    private static final double extraScale = 2.0;
    private final AtomicBoolean loaded;
    private final Dimension size;
    private final SVGIcon icon;
    private Supplier<URI> uriSupplier;
    private URI uri;
    private boolean directRendering;
    private boolean loadedWithExtraScale;
    private double scaleX;
    private double scaleY;
    private Image image;

    public DarkSVGIcon(Supplier<URI> uriSupplier, int displayWidth, int displayHeight) {
        this.uri = null;
        this.uriSupplier = uriSupplier;
        this.size = new Dimension(displayWidth, displayHeight);
        this.icon = this.createSVGIcon();
        this.icon.setAutosize(4);
        this.icon.setAntiAlias(true);
        this.loaded = new AtomicBoolean(false);
    }

    public DarkSVGIcon(URI uri, int displayWidth, int displayHeight) {
        this.uri = uri;
        this.uriSupplier = null;
        this.size = new Dimension(displayWidth, displayHeight);
        this.icon = this.createSVGIcon();
        this.icon.setAutosize(4);
        this.icon.setAntiAlias(true);
        this.loaded = new AtomicBoolean(false);
    }

    protected DarkSVGIcon(int width, int height, DarkSVGIcon parent) {
        this.size = new Dimension(width, height);
        this.icon = parent.icon;
        this.uri = parent.uri;
        this.uriSupplier = parent.uriSupplier;
        this.loaded = parent.loaded;
    }

    @Override
    public DarkSVGIcon derive(int width, int height) {
        return new DarkSVGIcon(width, height, this);
    }

    public void setDisplaySize(int width, int height) {
        this.size.setSize(width, height);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.paintIcon(c, g, x, y, 0.0);
    }

    protected boolean ensureLoaded(boolean painting) {
        return this.ensureSVGLoaded();
    }

    protected URI getUri() {
        this.ensureURILoaded();
        return this.uri;
    }

    private boolean ensureSVGLoaded() {
        if (!this.loaded.get()) {
            URI iconUri = this.getUri();
            LOGGER.finer(() -> "Loading icon '" + iconUri.toASCIIString() + "'.");
            this.icon.setSvgURI(iconUri);
            this.loaded.set(true);
            return true;
        }
        return false;
    }

    private void ensureURILoaded() {
        if (this.uri == null && this.uriSupplier != null) {
            this.uri = this.uriSupplier.get();
            this.uriSupplier = null;
        }
        if (this.uri == null) {
            throw new IllegalStateException("Uri is null.");
        }
    }

    protected void updateCache(boolean update, Component c) {
        GraphicsConfiguration gc = c != null ? c.getGraphicsConfiguration() : null;
        double sx = Scale.getScaleX((GraphicsConfiguration)gc);
        double sy = Scale.getScaleY((GraphicsConfiguration)gc);
        if (!update && Scale.equalWithError((double)this.scaleX, (double)sx) && Scale.equalWithError((double)this.scaleY, (double)sy) && this.image != null) {
            return;
        }
        this.scaleX = sx;
        this.scaleY = sy;
        double effectiveScaleX = this.loadedWithExtraScale ? this.scaleX * 2.0 : this.scaleX;
        double effectiveScaleY = this.loadedWithExtraScale ? this.scaleY * 2.0 : this.scaleY;
        this.image = this.createImage(Scale.scale((double)effectiveScaleX, (double)effectiveScaleY, (Dimension)this.size));
    }

    @Override
    public Image createImage(Dimension size) {
        this.ensureLoaded(false);
        this.icon.setPreferredSize(size);
        try {
            return this.icon.getImage();
        }
        catch (RuntimeException e) {
            if (!(this instanceof ThemedSVGIcon)) {
                IconColorMapper.patchColors(this.icon);
                Image img = this.icon.getImage();
                LOGGER.severe("Icon '" + this.getName(this.uri) + "' that defines custom colors isn't loaded as themed icon.");
                return img;
            }
            throw new RuntimeException("Exception while painting '" + this.uri.toASCIIString() + "'.", e);
        }
    }

    protected String getName(URI uri) {
        String name = uri.toASCIIString();
        name = name.substring(Math.min(name.length() - 1, name.lastIndexOf(47) + 1));
        return name;
    }

    protected void ensureImageLoaded(Component c, double rotation) {
        this.loadedWithExtraScale = !this.isExactRotation(rotation);
        this.updateCache(this.ensureLoaded(true) || this.loadedWithExtraScale, c);
    }

    private boolean isExactRotation(double rotation) {
        double r = rotation;
        if (r < 0.0) {
            r += Math.PI * 2;
        }
        if (r > Math.PI * 2) {
            r -= Math.PI * 2;
        }
        return Scale.equalWithError((double)r, (double)0.0) || Scale.equalWithError((double)r, (double)1.5707963267948966) || Scale.equalWithError((double)r, (double)Math.PI) || Scale.equalWithError((double)r, (double)4.71238898038469);
    }

    protected SVGIcon createSVGIcon() {
        return new SVGIcon();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y, double rotation) {
        boolean dr = this.isDirectRenderingMode();
        if (dr) {
            this.ensureLoaded(true);
            this.icon.setPreferredSize(this.size);
        } else {
            this.ensureImageLoaded(c, rotation);
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = g2.getTransform();
        g2.translate(x, y);
        double imageWidth = dr ? (double)this.size.width : (double)this.image.getWidth(null);
        double imageHeight = dr ? (double)this.size.height : (double)this.image.getHeight(null);
        double sx = (double)this.size.width / imageWidth;
        double sy = (double)this.size.height / imageHeight;
        g2.scale(sx, sy);
        if (rotation != 0.0) {
            g2.rotate(rotation, imageWidth / 2.0, imageHeight / 2.0);
        }
        if (dr) {
            this.getSVGIcon().paintIcon(c, g, 0, 0);
        } else {
            g2.drawImage(this.image, 0, 0, null);
        }
        g2.scale(1.0 / sx, 1.0 / sy);
        g2.translate(-x, -y);
        g2.setTransform(transform);
    }

    public boolean isDirectRenderingMode() {
        return this.directRendering;
    }

    public void setDirectRenderingMode(boolean directRendering) {
        this.directRendering = directRendering;
    }

    @Override
    public int getIconWidth() {
        return this.size.width;
    }

    @Override
    public int getIconHeight() {
        return this.size.height;
    }

    public SVGIcon getSVGIcon() {
        if (!this.loaded.get()) {
            this.ensureSVGLoaded();
        }
        return this.icon;
    }
}

