/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.task.CSSBuilder;
import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.util.ColorUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.UIDefaults;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class StyleSheetInitTask
implements DefaultsInitTask {
    private UIDefaults defaults;

    @Override
    public void run(Theme currentTheme, UIDefaults defaults) {
        this.defaults = defaults;
        StyleSheet styleSheet = new StyleSheet();
        Font font = defaults.getFont("html.font");
        CSSBuilder builder = new CSSBuilder();
        builder.group("body").fontSize(this.pt(14)).fontFamily(font.getFamily(), font.getName()).fontWeight("normal").marginRight(0).marginLeft(0).color(this.hex("textForeground")).group("p").marginTop(this.px(15)).group("h1").fontSize("x-large").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10)).group("h2").fontSize("large").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10)).group("h3").fontSize("medium").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10)).group("h4").fontSize("small").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10)).group("h5").fontSize("x-small").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10)).group("h6").fontSize("xx-small").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10)).group("li p").marginTop(0).marginBottom(0).group("td p").marginTop(0).group("menu li p").marginTop(0).marginBottom(0).group("menu li").margin(0).group("menu").marginLeftLTR(this.px(40)).marginRightRTL(this.px(40)).marginTop(this.px(10)).marginBottom(this.px(10)).group("dir li p").marginTop(0).marginBottom(0).group("dir li").margin(0).group("dir").marginLeftLTR(this.px(40)).marginRightRTL(this.px(40)).marginTop(this.px(10)).marginBottom(this.px(10)).group("dd").marginLeftLTR(this.px(40)).marginRightRTL(this.px(40)).marginTop(this.px(10)).marginBottom(this.px(10)).group("dd p").margin(0).group("dt").marginTop(0).marginBottom(0).group("dl").marginLeft(0).marginTop(this.px(10)).marginBottom(this.px(10)).group("ol li").margin(0).group("ol").marginTop(this.px(10)).marginBottom(this.px(10)).marginLeftLTR(this.px(50)).marginRightRTL(this.px(50)).listStyleType("decimal").group("ol li p").marginTop(0).marginBottom(0).group("ul li").margin(0).group("ul").marginTop(this.px(10)).marginBottom(this.px(10)).marginLeftLTR(this.px(50)).marginRightRTL(this.px(50)).listStyleType("disc").property("-bullet-gap", this.px(10)).group("ul li ul li").margin(0).group("ul li ul").marginLeftLTR(this.px(25)).marginRightRTL(this.px(25)).listStyleType("circle").group("ul li ul li ul li").margin(0).group("ul li menu").marginLeftLTR(this.px(25)).marginRightRTL(this.px(25)).listStyleType("circle").group("ul li p").marginTop(0).marginBottom(0).group("a").color(this.hex("hyperlink")).textDecoration("underline").group("address").color(this.hex("hyperlink")).fontStyle("italic").group("big").fontSize("x-large").group("small").fontSize("x-small").group("samp").fontSize("small").fontFamily("Monospaced", "monospace").group("code").fontSize("small").fontFamily("Monospaced", "monospace").group("kbd").fontSize("small").fontFamily("Monospaced", "monospace").group("cite").fontStyle("italic").group("dfn").fontStyle("italic").group("em").fontStyle("italic").group("i").fontStyle("italic").group("b").fontWeight("bold").group("strong").fontWeight("bold").group("strike").textDecoration("line-through").group("s").textDecoration("line-through").group("sub").property("vertical-align", "sub").group("sup").property("vertical-align", "sub").group("tt").fontFamily("Monospaced", "monospace").group("u").textDecoration("underline").group("var").fontWeight("bold").fontStyle("italic").group("table").borderColor(this.hex("border")).borderStyle("solid").borderWidth(this.px(1)).borderCollapse("collapse").group("td").borderColor(this.hex("border")).borderStyle("none").borderWidth(this.px(1)).padding(this.px(3)).borderCollapse("collapse").group("th").borderColor(this.hex("border")).borderStyle("solid").borderWidth(this.px(1)).padding(this.px(3)).fontWeight("bold").borderCollapse("collapse").group("tr").property("text-align", "left").group("blockquote").margin(this.px(5) + " " + this.px(35)).group("center").property("text-align", "center").group("pre").marginTop(this.px(5)).marginBottom(this.px(5)).fontFamily("Monospaced", "monospace").group("pre p").marginTop(0).group("caption").property("caption-side", "top").property("text-align", "center").group("nobr").property("white-space", "nowrap").group("input").border("none").group("div").borderColor(this.hex("borderSecondary")).borderWidth(this.px(1));
        styleSheet.addRule(builder.toString());
        StyleSheet custom = currentTheme.loadStyleSheet();
        if (custom.getStyleNames().hasMoreElements()) {
            styleSheet.addStyleSheet(custom);
        }
        new HTMLEditorKit().setStyleSheet(styleSheet);
    }

    protected String hex(String key) {
        Color c = this.defaults.getColor(key);
        return "#" + ColorUtil.toHex((Color)c);
    }

    protected String px(int px) {
        return px + "px";
    }

    protected String pt(int pt) {
        return pt + "pt";
    }

    @Override
    public boolean onlyDuringInstallation() {
        return true;
    }
}

