/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererToggleButton;
import com.github.weisj.darklaf.ui.tree.TreeRendererComponent;
import com.github.weisj.darklaf.ui.tree.TreeRendererSupport;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class DarkTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeRendererSupport {
    private final DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorCheckBox> checkBoxRenderer = new DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorCheckBox>(new DarkCellRendererToggleButton.CellEditorCheckBox(false));
    private final DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorRadioButton> radioRenderer = new DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorRadioButton>(new DarkCellRendererToggleButton.CellEditorRadioButton(false));
    private final TreeRendererComponent rendererComponent = new TreeRendererComponent();
    private final TreeCellRenderer parent;

    public DarkTreeCellRenderer() {
        this((TreeCellRenderer)null);
    }

    public DarkTreeCellRenderer(TreeCellRenderer parent) {
        this.parent = parent;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean isFocused = DarkUIUtil.hasFocus(tree);
        Object val = DarkTreeCellRenderer.unwrapBooleanIfPossible(value);
        if (val instanceof Boolean && DarkTreeCellRenderer.isBooleanRenderingEnabled(tree)) {
            super.getTreeCellRendererComponent(tree, val, sel, expanded, leaf, row, hasFocus);
            Component comp = this.getBooleanRenderer(tree).getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, isFocused);
            this.rendererComponent.setComponentOrientation(tree.getComponentOrientation());
            comp.setComponentOrientation(tree.getComponentOrientation());
            comp.setFont(tree.getFont());
            this.rendererComponent.setRenderer(this);
            this.rendererComponent.setRenderComponent(comp);
            return this.rendererComponent;
        }
        Component comp = this.parent != null ? this.parent.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, isFocused) : super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, isFocused);
        CellUtil.setupForeground(comp, (JComponent)tree, sel, this.getTextSelectionColor(), "Tree.selectionForegroundInactive");
        return comp;
    }

    public static Object unwrapBooleanIfPossible(Object value) {
        Object val = value;
        if (val instanceof DefaultMutableTreeNode) {
            val = ((DefaultMutableTreeNode)val).getUserObject();
        }
        if (!(val instanceof Boolean)) {
            String str = String.valueOf(val);
            if ("true".equals(str)) {
                val = true;
            }
            if ("false".equals(str)) {
                val = false;
            }
        }
        return val;
    }

    protected static boolean isBooleanRenderingEnabled(JTree tree) {
        return PropertyUtil.getBooleanProperty((JComponent)tree, (String)"JTree.renderBooleanAsCheckBox");
    }

    protected DarkCellRendererToggleButton<?> getBooleanRenderer(JTree table) {
        if (PropertyUtil.isPropertyEqual((JComponent)table, (String)"JTree.booleanRenderType", (Object)"radioButton")) {
            return this.radioRenderer;
        }
        return this.checkBoxRenderer;
    }
}

