/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tooltip;

import com.github.weisj.darklaf.components.border.BubbleBorder;
import com.github.weisj.darklaf.components.border.DropShadowBorder;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DarkTooltipBorder
implements Border {
    private final DropShadowBorder shadowBorder;
    private final BubbleBorder bubbleBorder;
    private final int shadowSize;
    private final float opacity;
    private boolean skipShadow;
    private Insets margin = UIManager.getInsets("ToolTip.borderInsets");

    public DarkTooltipBorder() {
        if (this.margin == null) {
            this.margin = new Insets(0, 0, 0, 0);
        }
        this.bubbleBorder = new BubbleBorder(UIManager.getColor("ToolTip.borderColor"));
        this.bubbleBorder.setThickness(1);
        this.bubbleBorder.setPointerSize(8);
        this.bubbleBorder.setPointerWidth(12);
        this.bubbleBorder.setPointerSide(Alignment.CENTER);
        this.shadowSize = UIManager.getInt("ToolTip.shadowSize");
        this.opacity = (float)UIManager.getInt("ToolTip.shadowOpacity") / 100.0f;
        this.shadowBorder = new DropShadowBorder(UIManager.getColor("ToolTip.borderShadowColor"), this.shadowSize, this.opacity, 2 * this.shadowSize, false, true, true, true);
    }

    public Area getBackgroundArea(Component c, int width, int height, boolean forPaint) {
        if (this.isPlain(c)) {
            return new Area(new Rectangle(0, 0, width, height));
        }
        Insets ins = this.shadowBorder.getBorderInsets(null);
        this.adjustInsets(ins);
        float adj = forPaint ? 0.5f : 0.0f;
        return this.bubbleBorder.getBubbleArea((float)ins.left - adj, (float)ins.top - adj, (float)(width - ins.left - ins.right) + 2.0f * adj, (float)(height - ins.top - ins.bottom) + 2.0f * adj, true);
    }

    public int getPointerOffset(Component c, Dimension dimension, int thicknessFactor) {
        if (this.isPlain(c)) {
            return 0;
        }
        int offset = (int)this.bubbleBorder.getOffset(dimension.width - 2 * this.shadowBorder.getShadowSize(), dimension.height) + this.shadowBorder.getShadowSize();
        int thickness = this.bubbleBorder.getThickness();
        Alignment align = this.bubbleBorder.getPointerSide();
        if (align.isWest(false)) {
            offset += thicknessFactor * thickness;
        }
        return offset;
    }

    private void adjustInsets(Insets si) {
        Alignment align = this.bubbleBorder.getPointerSide();
        int pointerSize = this.bubbleBorder.getPointerSize();
        if (align == Alignment.SOUTH || align == Alignment.SOUTH_EAST || align == Alignment.SOUTH_WEST) {
            si.bottom -= pointerSize;
        } else if (align == Alignment.EAST) {
            si.right -= pointerSize;
        } else if (align == Alignment.WEST) {
            si.left -= pointerSize;
        } else if (align == Alignment.NORTH_EAST || align == Alignment.NORTH || align == Alignment.NORTH_WEST) {
            si.top = 0;
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        GraphicsContext context = new GraphicsContext(g);
        if (this.isPlain(c)) {
            g.setColor(this.bubbleBorder.getColor());
            PaintUtil.drawRect(g, x, y, width, height, 1);
            return;
        }
        if (c instanceof JToolTip && ((JToolTip)c).getTipText() == null) {
            return;
        }
        Insets ins = this.shadowBorder.getBorderInsets(c);
        this.adjustInsets(ins);
        Area innerArea = this.bubbleBorder.getBubbleArea(x + ins.left, y + ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom, true);
        if (!this.skipShadow && UIManager.getBoolean("ToolTip.paintShadow")) {
            this.paintShadow(c, g, x, y, width, height, innerArea);
        }
        Area outerArea = this.bubbleBorder.getBubbleArea(x + ins.left, y + ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom, false);
        outerArea.subtract(innerArea);
        this.bubbleBorder.paintBorder(g, outerArea);
        context.restore();
    }

    public void paintShadow(Component c, Graphics g, int x, int y, int width, int height, Area bubbleArea) {
        Shape oldClip = g.getClip();
        Area clip = new Area(new Rectangle2D.Double(x, y, width, height));
        clip.subtract(bubbleArea);
        g.setClip(clip);
        int bw = 1 + this.bubbleBorder.getThickness();
        this.shadowBorder.paintBorder(c, g, x + bw, y + bw, width - 2 * bw, height - 2 * bw);
        g.setClip(oldClip);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets uIns = this.getUserInsets(c);
        if (this.isPlain(c)) {
            return new Insets(1 + uIns.top, 1 + uIns.left, 1 + uIns.bottom, 1 + uIns.right);
        }
        Insets ins = new Insets(0, 0, 0, 0);
        Insets bi = this.bubbleBorder.getBorderInsets(c);
        Insets si = this.shadowBorder.getBorderInsets(c);
        ins.bottom = Math.max(bi.bottom, si.bottom);
        ins.left = Math.max(bi.left, si.left);
        ins.right = Math.max(bi.right, si.right);
        ins.top = Math.max(bi.top, si.top);
        ins.left += uIns.left;
        ins.top += uIns.top;
        ins.right += uIns.right;
        ins.bottom += uIns.bottom;
        return ins;
    }

    protected Insets getUserInsets(Component c) {
        return (Insets)PropertyUtil.getObject((Component)c, (String)"JToolTip.insets", Insets.class, (Object)this.margin);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setPointerLocation(Alignment side) {
        this.bubbleBorder.setPointerSide(side);
    }

    public void setPointerWidth(int width) {
        this.bubbleBorder.setPointerWidth(width);
    }

    public void setPointerHeight(int height) {
        this.bubbleBorder.setPointerSize(height);
    }

    protected boolean isPlain(Component c) {
        if (!(c instanceof JComponent)) {
            return false;
        }
        Object prop = ((JComponent)c).getClientProperty("JToolTip.style");
        return prop == ToolTipStyle.PLAIN || "plain".equals(prop);
    }

    public int getShadowSize(Component c) {
        if (this.isPlain(c)) {
            return 0;
        }
        return this.shadowBorder.getShadowSize();
    }

    public void setSkipShadow(boolean skip) {
        this.skipShadow = skip;
    }

    public int getDistanceToPointer() {
        switch (this.bubbleBorder.getPointerSide()) {
            case WEST: 
            case SOUTH: 
            case SOUTH_EAST: 
            case SOUTH_WEST: 
            case EAST: {
                return Math.max(0, this.shadowBorder.getShadowSize() - this.bubbleBorder.getPointerSize()) + this.bubbleBorder.getThickness();
            }
        }
        return this.bubbleBorder.getThickness();
    }
}

