/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.table.DarkTableCellBorder;
import com.github.weisj.darklaf.ui.text.DarkCaret;
import com.github.weisj.darklaf.ui.text.DarkHighlighter;
import com.github.weisj.darklaf.ui.text.DarkPlainTextBorder;
import com.github.weisj.darklaf.ui.text.DarkTextBorder;
import com.github.weisj.darklaf.ui.text.DefaultTextRenderer;
import com.github.weisj.darklaf.ui.text.LabelDefaultTextRenderer;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import sun.awt.SunToolkit;
import sun.swing.DefaultLookup;

public abstract class DarkTextUI
extends BasicTextUI
implements PropertyChangeListener {
    protected static final String KEY_PREFIX = "JTextComponent.";
    public static final String KEY_ROUNDED_SELECTION = "JTextComponent.roundedSelection";
    public static final String KEY_HAS_ERROR = "JTextComponent.hasError";
    public static final String KEY_IS_TREE_EDITOR = "JComponent.isTreeEditor";
    public static final String KEY_IS_TABLE_EDITOR = "JComponent.isTableEditor";
    public static final String KEY_IS_LIST_RENDER = "JComponent.listCellEditor";
    public static final String KEY_DEFAULT_TEXT = "JTextComponent.defaultText";
    protected JTextComponent editor;
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            Caret caret = DarkTextUI.this.editor.getCaret();
            if (caret instanceof DarkCaret) {
                ((DarkCaret)caret).setPaintSelectionHighlight(true);
            }
            DarkTextUI.this.editor.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Caret caret = DarkTextUI.this.editor.getCaret();
            if (caret instanceof DarkCaret) {
                ((DarkCaret)caret).setPaintSelectionHighlight(false);
            }
            DarkTextUI.this.editor.repaint();
        }
    };
    protected DefaultTextRenderer defaultTextRenderer;
    protected Color disabledColor;
    protected Color inactiveColor;

    @Override
    protected Caret createCaret() {
        return new DarkCaret(this.getDefaultCaretStyle());
    }

    protected abstract DarkCaret.CaretStyle getDefaultCaretStyle();

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.editor != null && "javax.swing.plaf.basic.BasicComboBoxEditor$BorderlessTextField".equals(this.editor.getClass().getName())) {
            this.editor.setBorder(null);
        }
        if (this.editor != null) {
            this.editor.putClientProperty(KEY_ROUNDED_SELECTION, UIManager.getBoolean("TextComponent.roundedSelection"));
        }
        this.disabledColor = UIManager.getColor(this.getPropertyPrefix() + ".disabledBackground");
        this.inactiveColor = UIManager.getColor(this.getPropertyPrefix() + ".inactiveBackground");
    }

    protected DefaultTextRenderer createDefaultTextRenderer() {
        return new LabelDefaultTextRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.editor.putClientProperty(KEY_ROUNDED_SELECTION, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (KEY_ROUNDED_SELECTION.equals(key)) {
            this.editor.repaint();
        } else if (KEY_HAS_ERROR.equals(key)) {
            this.editor.repaint();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.editor.addPropertyChangeListener(this);
        this.editor.addFocusListener(this.focusListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.editor.removePropertyChangeListener(this);
        this.editor.removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    protected Color getBackground(JTextComponent c) {
        if (!c.isEnabled()) {
            return this.disabledColor;
        }
        if (!c.isEditable()) {
            return this.inactiveColor;
        }
        return c.getBackground();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String defaultText;
        Dimension dim = super.getPreferredSize(c);
        if (this.isEmpty() && !(defaultText = this.getDefaultText()).isEmpty()) {
            Component renderer = this.getDefaultTextRenderer().getRendererComponent(this.editor, defaultText);
            Dimension prefSize = renderer.getPreferredSize();
            Insets i = c.getInsets();
            prefSize.width += i.left + i.right;
            prefSize.height += i.top + i.bottom;
            dim.width = Math.max(dim.width, prefSize.width);
            dim.height = Math.max(dim.height, prefSize.height);
        }
        dim.width += this.getCaretWidth();
        return dim;
    }

    protected int getCaretWidth() {
        Caret caret = this.editor.getCaret();
        if (caret instanceof DefaultCaret) {
            return (int)((DefaultCaret)caret).getWidth();
        }
        return 1;
    }

    @Override
    protected void paintBackground(Graphics g) {
        Border border;
        Container parent = this.getRelevantParent(this.editor);
        if (parent != null && parent.isOpaque() && !this.editor.isEnabled()) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
            return;
        }
        if (this.editor.isOpaque()) {
            if (DarkUIUtil.isInCell(this.editor)) {
                g.setColor(this.getBackground(this.editor));
                g.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
            } else if (parent != null && parent.isOpaque()) {
                g.setColor(parent.getBackground());
                g.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
            }
        }
        if ((border = this.editor.getBorder()) instanceof DarkTextBorder) {
            this.paintBorderBackground((Graphics2D)g, this.editor);
        } else if (border instanceof DarkTableCellBorder) {
            g.setColor(this.editor.getBackground());
            g.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
        } else if (border != null && !(border instanceof DarkPlainTextBorder)) {
            Insets ins = border.getBorderInsets(this.editor);
            if (ins != null) {
                g.setColor(this.getBackground(this.editor));
                g.fillRect(ins.left, ins.top, this.editor.getWidth() - ins.left - ins.right, this.editor.getHeight() - ins.top - ins.bottom);
            }
        } else {
            g.setColor(this.getBackground(this.editor));
            g.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
        }
    }

    protected Container getRelevantParent(Component c) {
        Container parent = this.editor.getParent();
        if (parent instanceof JSpinner.DefaultEditor) {
            JSpinner spinner = DarkUIUtil.getParentOfType(JSpinner.class, c);
            if (spinner != null) {
                parent = spinner.getParent();
            }
        } else if (parent instanceof JComboBox) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Override
    protected void paintSafely(Graphics g) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        super.paintSafely(g);
        config.restoreClip();
        this.paintDefaultText(g);
        config.restore();
    }

    protected void paintDefaultText(Graphics g) {
        String defaultText;
        if (this.isEmpty() && !(defaultText = this.getDefaultText()).isEmpty()) {
            Rectangle rect = this.getVisibleEditorRect();
            g.translate(rect.x, rect.y);
            Component renderer = this.getDefaultTextRenderer().getRendererComponent(this.editor, defaultText);
            renderer.setBounds(rect);
            renderer.paint(g);
        }
    }

    protected String getDefaultText() {
        return PropertyUtil.getString((JComponent)this.editor, (String)KEY_DEFAULT_TEXT, (String)"");
    }

    protected boolean isEmpty() {
        Document doc = this.editor.getDocument();
        return doc == null || doc.getLength() == 0;
    }

    protected DefaultTextRenderer getDefaultTextRenderer() {
        if (this.defaultTextRenderer == null) {
            this.defaultTextRenderer = this.createDefaultTextRenderer();
        }
        return this.defaultTextRenderer;
    }

    protected void paintBorderBackground(Graphics2D g, JTextComponent c) {
        g.setColor(this.getBackground(c));
        Rectangle r = this.getDrawingRect(c);
        int arc = this.getArcSize(c);
        PaintUtil.fillRoundRect(g, r.x, r.y, r.width, r.height, arc);
    }

    public Rectangle getDrawingRect(JTextComponent c) {
        Border border = c.getBorder();
        int w = 0;
        if (border instanceof DarkTextBorder) {
            w = ((DarkTextBorder)border).getBorderSize();
        }
        return new Rectangle(w, w, c.getWidth() - 2 * w, c.getHeight() - 2 * w);
    }

    protected int getArcSize(JComponent c) {
        Border border = c.getBorder();
        if (border instanceof DarkTextBorder) {
            return ((DarkTextBorder)border).getArcSize(c);
        }
        return 0;
    }

    @Override
    protected void installKeyboardActions() {
        ActionMap map;
        this.editor.setKeymap(this.createKeymap());
        InputMap km = this.getInputMap();
        if (km != null) {
            SwingUtilities.replaceUIInputMap(this.editor, 0, km);
        }
        if ((map = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.editor, map);
        }
        this.updateFocusAcceleratorBinding(false);
    }

    @Override
    public void installUI(JComponent c) {
        if (c instanceof JTextComponent) {
            this.editor = (JTextComponent)c;
        }
        super.installUI(c);
    }

    @Override
    protected Highlighter createHighlighter() {
        return new DarkHighlighter();
    }

    protected InputMap getInputMap() {
        InputMapUIResource map = new InputMapUIResource();
        InputMap shared = (InputMap)DefaultLookup.get(this.editor, this, this.getPropertyPrefix() + ".focusInputMap");
        if (shared != null) {
            map.setParent(shared);
        }
        return map;
    }

    protected ActionMap getActionMap() {
        Action obj;
        String mapName = this.getPropertyPrefix() + ".actionMap";
        ActionMap map = (ActionMap)UIManager.get(mapName);
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put(mapName, map);
        }
        ActionMapUIResource componentMap = new ActionMapUIResource();
        componentMap.put("requestFocus", new FocusAction());
        if (this.getEditorKit(this.editor) instanceof DefaultEditorKit && map != null && (obj = map.get("insert-break")) instanceof DefaultEditorKit.InsertBreakAction) {
            TextActionWrapper action = new TextActionWrapper((TextAction)obj);
            componentMap.put(action.getValue("Name"), action);
        }
        if (map != null) {
            componentMap.setParent(map);
        }
        return componentMap;
    }

    protected void updateFocusAcceleratorBinding(boolean changed) {
        char accelerator = this.editor.getFocusAccelerator();
        if (changed || accelerator != '\u0000') {
            InputMap km = SwingUtilities.getUIInputMap(this.editor, 2);
            if (km == null && accelerator != '\u0000') {
                km = new ComponentInputMapUIResource(this.editor);
                SwingUtilities.replaceUIInputMap(this.editor, 2, km);
                ActionMap am = this.getActionMap();
                SwingUtilities.replaceUIActionMap(this.editor, am);
            }
            if (km != null) {
                km.clear();
                if (accelerator != '\u0000') {
                    km.put(KeyStroke.getKeyStroke((int)accelerator, DarkTextUI.getFocusAcceleratorKeyMask()), "requestFocus");
                    km.put(KeyStroke.getKeyStroke((int)accelerator, DarkUIUtil.setAltGraphMask(DarkTextUI.getFocusAcceleratorKeyMask())), "requestFocus");
                }
            }
        }
    }

    public ActionMap createActionMap() {
        Action[] actions;
        ActionMapUIResource map = new ActionMapUIResource();
        for (Action a : actions = this.editor.getActions()) {
            map.put(a.getValue("Name"), a);
        }
        map.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return map;
    }

    protected static int getFocusAcceleratorKeyMask() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk instanceof SunToolkit) {
            return ((SunToolkit)tk).getFocusAcceleratorKeyMask();
        }
        return 8;
    }

    void updateFocusTraversalKeys() {
        EditorKit editorKit = this.getEditorKit(this.editor);
        if (editorKit instanceof DefaultEditorKit) {
            Set<AWTKeyStroke> storedForwardTraversalKeys = this.editor.getFocusTraversalKeys(0);
            Set<AWTKeyStroke> storedBackwardTraversalKeys = this.editor.getFocusTraversalKeys(1);
            HashSet<AWTKeyStroke> forwardTraversalKeys = new HashSet<AWTKeyStroke>(storedForwardTraversalKeys);
            HashSet<AWTKeyStroke> backwardTraversalKeys = new HashSet<AWTKeyStroke>(storedBackwardTraversalKeys);
            if (this.editor.isEditable()) {
                forwardTraversalKeys.remove(KeyStroke.getKeyStroke(9, 0));
                backwardTraversalKeys.remove(KeyStroke.getKeyStroke(9, 1));
            } else {
                forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
                backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
            }
            LookAndFeel.installProperty(this.editor, "focusTraversalKeysForward", forwardTraversalKeys);
            LookAndFeel.installProperty(this.editor, "focusTraversalKeysBackward", backwardTraversalKeys);
        }
    }

    public class TextActionWrapper
    extends TextAction {
        final TextAction action;

        public TextActionWrapper(TextAction action) {
            super((String)action.getValue("Name"));
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            return (DarkTextUI.this.editor == null || DarkTextUI.this.editor.isEditable()) && this.action.isEnabled();
        }
    }

    public class FocusAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            DarkTextUI.this.editor.requestFocus();
        }

        @Override
        public boolean isEnabled() {
            return DarkTextUI.this.editor.isEditable();
        }
    }
}

