/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.ui.text.DarkTextFieldUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.Document;

public class DarkFormattedTextFieldUI
extends DarkTextFieldUI
implements PropertyChangeListener,
DocumentListener {
    private JFormattedTextField textField;

    public static ComponentUI createUI(JComponent c) {
        return new DarkFormattedTextFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "FormattedTextField";
    }

    @Override
    public void installUI(JComponent c) {
        this.textField = (JFormattedTextField)c;
        super.installUI(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("document".equals(evt.getPropertyName())) {
            Object oldDoc = evt.getOldValue();
            Object newDoc = evt.getNewValue();
            if (oldDoc instanceof Document) {
                ((Document)oldDoc).removeDocumentListener(this);
            }
            if (newDoc instanceof Document) {
                ((Document)newDoc).addDocumentListener(this);
            }
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.textField.getDocument().addDocumentListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.textField.getDocument().removeDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    protected void update() {
        if (this.textField == null) {
            return;
        }
        try {
            this.textField.getFormatter().stringToValue(this.textField.getText());
            this.textField.putClientProperty("JTextComponent.hasError", false);
        }
        catch (ParseException e) {
            this.textField.putClientProperty("JTextComponent.hasError", true);
        }
    }
}

