/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.text.SelectLineAction;
import com.github.weisj.darklaf.ui.text.SelectWordAction;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighterDark.DarkHighlightPainter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public class DarkCaret
extends DefaultCaret
implements UIResource {
    private static Action selectWord;
    private static Action selectLine;
    private final Segment seg = new Segment();
    private final DarkHighlightPainter selectionPainter;
    private MouseEvent selectedWordEvent;
    private CaretStyle style;
    private boolean alwaysVisible;
    private boolean pasteOnMiddleMouseClick;

    public DarkCaret() {
        this(CaretStyle.THICK_VERTICAL_LINE_STYLE);
    }

    public DarkCaret(CaretStyle style) {
        this.setStyle(style);
        this.selectionPainter = new DarkHighlightPainter();
        selectLine = new SelectLineAction();
        selectWord = new SelectWordAction();
        this.pasteOnMiddleMouseClick = true;
    }

    public boolean getRoundedSelectionEdges() {
        return ((DarkHighlightPainter)this.getSelectionPainter()).getRoundedEdges();
    }

    public void setRoundedSelectionEdges(boolean rounded) {
        ((DarkHighlightPainter)this.getSelectionPainter()).setRoundedEdges(rounded);
    }

    public CaretStyle getStyle() {
        return this.style;
    }

    public void setStyle(CaretStyle style) {
        CaretStyle s = style;
        if (s == null) {
            s = CaretStyle.THICK_VERTICAL_LINE_STYLE;
        }
        if (s != this.style) {
            this.style = s;
            this.repaint();
        }
    }

    @Override
    protected void positionCaret(MouseEvent e) {
        super.positionCaret(e);
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    public void setAlwaysVisible(boolean alwaysVisible) {
        if (alwaysVisible != this.alwaysVisible) {
            this.alwaysVisible = alwaysVisible;
            if (!this.isVisible()) {
                this.repaint();
            }
        }
    }

    @Override
    public double getWidth() {
        return this.style.getWidth();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isConsumed()) {
            JTextComponent c;
            JTextComponent textArea = this.getComponent();
            int clickCount = e.getClickCount();
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (clickCount > 2) {
                    switch (clickCount %= 2) {
                        case 0: {
                            this.selectWord(e);
                            this.selectedWordEvent = null;
                            break;
                        }
                        case 1: {
                            selectLine.actionPerformed(new ActionEvent(textArea, 1001, null, e.getWhen(), e.getModifiersEx()));
                        }
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(e) && this.getPasteOnMiddleMouseClick() && clickCount == 1 && textArea.isEditable() && textArea.isEnabled() && (c = (JTextComponent)e.getSource()) != null) {
                try {
                    Toolkit tk = c.getToolkit();
                    Clipboard buffer = tk.getSystemSelection();
                    if (buffer != null) {
                        Transferable trans;
                        this.adjustCaretLocation(e);
                        TransferHandler th = c.getTransferHandler();
                        if (th != null && (trans = buffer.getContents(null)) != null) {
                            th.importData(c, trans);
                        }
                        this.adjustFocus(true);
                    } else {
                        textArea.paste();
                    }
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        }
    }

    private void adjustCaretLocation(MouseEvent e) {
        if (e.isShiftDown() && this.getDot() != -1) {
            this.moveCaret(e);
        } else {
            this.positionCaret(e);
        }
    }

    private void adjustFocus(boolean inWindow) {
        JTextComponent textArea = this.getComponent();
        if (textArea != null && textArea.isEnabled() && textArea.isRequestFocusEnabled()) {
            if (inWindow) {
                textArea.requestFocusInWindow();
            } else {
                textArea.requestFocus();
            }
        }
    }

    @Override
    protected synchronized void damage(Rectangle r) {
        if (r != null) {
            this.validateWidth(r);
            this.x = r.x - 1;
            this.y = r.y;
            this.width = r.width + 4;
            this.height = r.height;
            this.repaint();
        }
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.selectionPainter;
    }

    @Override
    public boolean isSelectionVisible() {
        return super.isSelectionVisible() && this.selectionPainter.isEnabled();
    }

    public void setPaintSelectionHighlight(boolean paintSelectionHighlight) {
        this.selectionPainter.setEnabled(paintSelectionHighlight);
    }

    public boolean getPasteOnMiddleMouseClick() {
        return this.pasteOnMiddleMouseClick;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTextComponent c;
        super.mousePressed(e);
        if (!e.isConsumed() && SwingUtilities.isRightMouseButton(e) && (c = this.getComponent()) != null && c.isEnabled() && c.isRequestFocusEnabled()) {
            c.requestFocusInWindow();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.isVisible() || this.alwaysVisible) {
            Rectangle r;
            JTextComponent textArea = this.getComponent();
            g.setColor(textArea.getCaretColor());
            TextUI mapper = textArea.getUI();
            try {
                r = mapper.modelToView(textArea, this.getDot(), Position.Bias.Forward);
            }
            catch (BadLocationException ex) {
                r = new Rectangle(0, 0, 0, 0);
            }
            this.validateWidth(r);
            if (this.width > 0 && this.height > 0 && !this.contains(r.x, r.y, r.width, r.height)) {
                Rectangle clip = g.getClipBounds();
                if (clip != null && !clip.contains(this)) {
                    this.repaint();
                }
                this.damage(r);
            }
            r.height -= 2;
            ++r.y;
            Color textAreaBg = textArea.getBackground();
            switch (this.style) {
                case BLOCK_STYLE: {
                    if (textAreaBg == null) {
                        textAreaBg = Color.white;
                    }
                    g.setXORMode(textAreaBg);
                    g.fillRect(r.x, r.y, r.width, r.height);
                    break;
                }
                case BLOCK_BORDER_STYLE: {
                    PaintUtil.drawRect(g, r.x, r.y, r.width, r.height, 1);
                    break;
                }
                case UNDERLINE_STYLE: {
                    if (textAreaBg == null) {
                        textAreaBg = Color.white;
                    }
                    g.setXORMode(textAreaBg);
                    int y = r.y + r.height;
                    g.fillRect(r.x, y - 1, r.width, 1);
                    break;
                }
                case THICK_VERTICAL_LINE_STYLE: 
                case VERTICAL_LINE_STYLE: {
                    g.fillRect(r.x, r.y, this.style.getWidth(), r.height);
                }
            }
        }
    }

    private void selectWord(MouseEvent e) {
        if (this.selectedWordEvent != null && this.selectedWordEvent.getX() == e.getX() && this.selectedWordEvent.getY() == e.getY()) {
            return;
        }
        JTextComponent textArea = this.getComponent();
        selectWord.actionPerformed(new ActionEvent(textArea, 1001, null, e.getWhen(), e.getModifiersEx()));
        this.selectedWordEvent = e;
    }

    public void setPasteOnMiddleMouseClick(boolean paste) {
        this.pasteOnMiddleMouseClick = paste;
    }

    @Override
    public void setSelectionVisible(boolean visible) {
        super.setSelectionVisible(true);
    }

    private void validateWidth(Rectangle rect) {
        if (rect != null && rect.width <= 1) {
            JTextComponent textArea = this.getComponent();
            try {
                textArea.getDocument().getText(this.getDot(), 1, this.seg);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                rect.width = 8;
            }
            Font font = textArea.getFont();
            FontMetrics fm = textArea.getFontMetrics(font);
            rect.width = fm.charWidth(this.seg.array[this.seg.offset]);
            if (rect.width == 0) {
                rect.width = fm.charWidth(' ');
            }
        }
    }

    public static enum CaretStyle {
        VERTICAL_LINE_STYLE(1),
        UNDERLINE_STYLE(0),
        BLOCK_STYLE(0),
        BLOCK_BORDER_STYLE(0),
        THICK_VERTICAL_LINE_STYLE(1);

        private final int width;

        private CaretStyle(int width) {
            this.width = width;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

