/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererToggleButton;
import com.github.weisj.darklaf.ui.combobox.DarkComboBoxUI;
import com.github.weisj.darklaf.ui.table.DarkTableCellEditorToggleButton;
import com.github.weisj.darklaf.ui.table.DarkTableCellRenderer;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.ui.table.TextTableCellEditorBorder;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;

public class DarkTableCellEditor
extends DefaultCellEditor {
    private static final JCheckBox dummyCheckBox = new JCheckBox();
    private static final IconWrapper iconWrapper = new IconWrapper();
    private final JToggleButton editorCheckBox = new DarkCellRendererToggleButton.CellEditorCheckBox(true);
    private final DarkTableCellEditorToggleButton checkBoxEditor = new DarkTableCellEditorToggleButton(this, this.editorCheckBox);
    private final JToggleButton editorRadioButton = new DarkCellRendererToggleButton.CellEditorRadioButton(true);
    private final DarkTableCellEditorToggleButton radioButtonEditor = new DarkTableCellEditorToggleButton(this, this.editorRadioButton);
    private boolean value;
    private boolean isBooleanEditor;
    private JTable table;

    public DarkTableCellEditor() {
        this(new JTextField());
    }

    public DarkTableCellEditor(JTextField textField) {
        super(textField);
        textField.setBorder(new TextTableCellEditorBorder());
        textField.putClientProperty("JComponent.isTableEditor", true);
        this.setClickCountToStart(2);
    }

    public DarkTableCellEditor(JComboBox<?> comboBox) {
        super(comboBox);
        comboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (DarkTableCellEditor.this.table != null) {
                    DarkTableCellEditor.this.table.repaint();
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (DarkTableCellEditor.this.table != null) {
                    DarkTableCellEditor.this.table.repaint();
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        comboBox.putClientProperty("JComponent.isTableEditor", true);
        this.setClickCountToStart(2);
    }

    public DarkTableCellEditor(final JSpinner spinner) {
        super(dummyCheckBox);
        this.editorComponent = spinner;
        spinner.putClientProperty("JComponent.isTableEditor", Boolean.TRUE);
        this.setClickCountToStart(2);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public Object getCellEditorValue() {
                return spinner.getValue();
            }

            @Override
            public void setValue(Object value) {
                try {
                    SpinnerModel model = spinner.getModel();
                    if (model instanceof SpinnerNumberModel) {
                        spinner.setValue(NumberFormat.getInstance().parse(value.toString()));
                    } else if (model instanceof SpinnerDateModel) {
                        spinner.setValue(DateFormat.getInstance().parse(value.toString()));
                    } else {
                        spinner.setValue(value);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }
        };
        this.setClickCountToStart(2);
    }

    public DarkTableCellEditor(JCheckBox checkBox) {
        this((JToggleButton)checkBox);
    }

    public DarkTableCellEditor(final JToggleButton toggleButton) {
        super(dummyCheckBox);
        this.editorComponent = toggleButton;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public Object getCellEditorValue() {
                return toggleButton.isSelected();
            }

            @Override
            public void setValue(Object value) {
                boolean selected = false;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                } else if (value instanceof String) {
                    selected = value.equals("true");
                }
                toggleButton.setSelected(selected);
            }
        };
        toggleButton.putClientProperty("JComponent.isTableEditor", true);
        toggleButton.addActionListener(this.delegate);
        toggleButton.setRequestFocusEnabled(false);
    }

    public DarkTableCellEditor(JRadioButton checkBox) {
        this((JToggleButton)checkBox);
    }

    public void setValue(Object value) {
        this.delegate.setValue(value);
        if (value instanceof Boolean) {
            this.value = (Boolean)value;
        } else {
            this.isBooleanEditor = false;
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isBooleanEditor) {
            return this.value;
        }
        return super.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent == null) {
            return super.isCellEditable(anEvent);
        }
        JTable table = (JTable)anEvent.getSource();
        if (anEvent instanceof KeyEvent && DarkTableUI.ignoreKeyCodeOnEdit((KeyEvent)anEvent, table)) {
            return false;
        }
        if (anEvent instanceof MouseEvent && DarkTableCellRenderer.isBooleanRenderingEnabled(table)) {
            Object value;
            Point p = ((MouseEvent)anEvent).getPoint();
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            if (row >= 0 && row < table.getRowCount() && col >= 0 && col < table.getColumnCount() && this.useBooleanEditor(value = table.getValueAt(row, col), table)) {
                Rectangle rect = table.getCellRect(row, col, false);
                p.x -= rect.x;
                p.y -= rect.y;
                Component editor = this.getBooleanEditor(table).getTableCellEditorComponent(table, true, false, row, col);
                editor.setBounds(rect);
                return editor.contains(p);
            }
        }
        return super.isCellEditable(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.editorComponent instanceof JComboBox) {
            ((DarkComboBoxUI)((JComboBox)this.editorComponent).getUI()).resetPopup();
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        if (this.useBooleanEditor(value, table)) {
            this.isBooleanEditor = true;
            return this.getBooleanEditor(table).getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        this.isBooleanEditor = false;
        this.delegate.setValue(value);
        JComponent comp = this.editorComponent;
        Component rendererComp = table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, false, row, column);
        this.setupEditorComponent(value, rendererComp);
        comp = this.applyRendererIcon(comp, rendererComp);
        CellUtil.setupBackground((Component)comp, table, false, row, "JTable.alternateRowColor", "Table.alternateRowBackground", "Table.selectionNoFocusBackground");
        return comp;
    }

    protected JComponent applyRendererIcon(JComponent comp, Component rendererComp) {
        Icon icon;
        if (rendererComp instanceof JLabel && (icon = ((JLabel)rendererComp).getIcon()) != null) {
            comp = iconWrapper;
            iconWrapper.init(this.editorComponent, icon, rendererComp.getComponentOrientation().isLeftToRight());
            iconWrapper.setIconGap(((JLabel)rendererComp).getIconTextGap() - 1);
        }
        return comp;
    }

    protected void setupEditorComponent(Object value, Component rendererComp) {
        if (this.editorComponent instanceof JComboBox) {
            ((JComboBox)this.editorComponent).removeAllItems();
            if (value != null && value.getClass().isArray()) {
                for (Object obj : (Object[])value) {
                    ((JComboBox)this.editorComponent).addItem(obj);
                }
            } else {
                ((JComboBox)this.editorComponent).addItem(value);
                ((JComboBox)this.editorComponent).setSelectedItem(value);
            }
        } else if (this.editorComponent instanceof JSpinner) {
            if (rendererComp instanceof JTextField) {
                this.editorComponent.putClientProperty("JSpinner.cellEditorAlignment", ((JTextField)rendererComp).getHorizontalAlignment());
            } else if (rendererComp instanceof JLabel) {
                this.editorComponent.putClientProperty("JSpinner.cellEditorAlignment", ((JLabel)rendererComp).getHorizontalAlignment());
            }
        }
    }

    private boolean useBooleanEditor(Object value, JTable table) {
        return value instanceof Boolean && DarkTableCellRenderer.isBooleanRenderingEnabled(table) && !(this.editorComponent instanceof JCheckBox) && !(this.editorComponent instanceof JRadioButton);
    }

    protected TableCellEditor getBooleanEditor(JTable table) {
        if (PropertyUtil.isPropertyEqual((JComponent)table, (String)"JTable.booleanRenderType", (Object)"radioButton")) {
            return this.radioButtonEditor;
        }
        return this.checkBoxEditor;
    }

    public static class IconWrapper
    extends JPanel {
        private final JLabel label;
        private JComponent c;
        private int iconGap;

        protected IconWrapper() {
            this.setLayout(null);
            this.label = new JLabel();
            this.label.setIconTextGap(0);
            this.add(this.label);
        }

        protected void setIconGap(int iconGap) {
            this.iconGap = iconGap;
        }

        protected void init(JComponent component, Icon icon, boolean ltr) {
            this.setComponentOrientation(ltr ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
            if (this.c != null) {
                this.remove(this.c);
            }
            this.add(component);
            this.c = component;
            this.label.setIcon(icon);
        }

        @Override
        public void doLayout() {
            if (this.c == null) {
                return;
            }
            int w = this.getWidth();
            int h = this.getHeight();
            Border b = this.c.getBorder();
            Insets ins = new Insets(0, 0, 0, 0);
            Dimension labelSize = this.label.getPreferredSize();
            int gap = this.getIconCompGap();
            if (b != null) {
                ins = b.getBorderInsets(this.c);
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                this.label.setBounds(ins.left + gap, 0, labelSize.width + 1, h);
                this.c.setBounds(ins.left + labelSize.width + 2 * gap - 1, 0, w - ins.left - labelSize.width - 2 * gap + 1, h);
            } else {
                this.c.setBounds(0, 0, w - ins.right - labelSize.width - gap - 1, h);
                this.label.setBounds(w - ins.right - labelSize.width - gap - 1, 0, labelSize.width + 1, h);
            }
        }

        public int getIconCompGap() {
            return this.iconGap;
        }
    }
}

