/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitpane;

import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.ui.splitpane.DarkSplitPaneUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class DarkSplitPaneDivider
extends BasicSplitPaneDivider {
    protected final Icon leftOneTouch;
    protected final Icon rightOneTouch;
    protected final Icon topOneTouch;
    protected final Icon bottomOneTouch;
    protected final Icon verticalSplit;
    protected final Icon horizontalSplit;
    protected final Color borderColor;
    private final DarkSplitPaneUI ui;

    public DarkSplitPaneDivider(DarkSplitPaneUI ui) {
        super(ui);
        this.ui = ui;
        this.leftOneTouch = UIManager.getIcon("SplitPaneDivider.leftOneTouch.icon");
        this.rightOneTouch = UIManager.getIcon("SplitPaneDivider.rightOneTouch.icon");
        this.topOneTouch = UIManager.getIcon("SplitPaneDivider.topOneTouch.icon");
        this.bottomOneTouch = UIManager.getIcon("SplitPaneDivider.bottomOneTouch.icon");
        this.verticalSplit = UIManager.getIcon("SplitPane.verticalGlue.icon");
        this.horizontalSplit = UIManager.getIcon("SplitPane.horizontalGlue.icon");
        this.borderColor = UIManager.getColor("SplitPane.dividerLineColor");
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        boolean paintBorder = this.ui.getStyle().isPaintBorder();
        if (this.splitPane.getOrientation() == 0) {
            Icon icon = this.getVerticalSplitIcon();
            icon.paintIcon(this, g, (this.getWidth() - icon.getIconWidth()) / 2, (this.getHeight() - icon.getIconHeight()) / 2);
            if (paintBorder) {
                g.setColor(this.borderColor);
                g.fillRect(0, 0, this.getWidth(), 1);
                g.fillRect(0, this.getHeight() - 1, this.getWidth(), 1);
            }
        } else {
            Icon icon = this.getHorizontalSplitIcon();
            icon.paintIcon(this, g, (this.getWidth() - icon.getIconWidth()) / 2, (this.getHeight() - icon.getIconHeight()) / 2);
            if (paintBorder) {
                g.setColor(this.borderColor);
                g.fillRect(0, 0, 1, this.getHeight());
                g.fillRect(this.getWidth() - 1, 0, 1, this.getHeight());
            }
        }
    }

    protected Icon getVerticalSplitIcon() {
        return this.verticalSplit;
    }

    protected Icon getHorizontalSplitIcon() {
        return this.horizontalSplit;
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        return new OneTouchLeftButton();
    }

    @Override
    protected JButton createRightOneTouchButton() {
        return new OneTouchRightButton();
    }

    protected Icon getLeftOneTouchIcon() {
        return this.leftOneTouch;
    }

    protected Icon getRightOneTouchIcon() {
        return this.rightOneTouch;
    }

    protected Icon getTopOneTouchIcon() {
        return this.topOneTouch;
    }

    protected Icon getBottomOneTouchIcon() {
        return this.bottomOneTouch;
    }

    protected class OneTouchLeftButton
    extends OneTouchButton {
        protected OneTouchLeftButton() {
        }

        @Override
        public Icon getIcon() {
            if (DarkSplitPaneDivider.this.splitPane != null) {
                return DarkSplitPaneDivider.this.splitPane.getOrientation() == 1 ? DarkSplitPaneDivider.this.getLeftOneTouchIcon() : DarkSplitPaneDivider.this.getTopOneTouchIcon();
            }
            return EmptyIcon.create((int)0);
        }
    }

    protected class OneTouchRightButton
    extends OneTouchButton {
        protected OneTouchRightButton() {
        }

        @Override
        public Icon getIcon() {
            if (DarkSplitPaneDivider.this.splitPane != null) {
                return DarkSplitPaneDivider.this.splitPane.getOrientation() == 1 ? DarkSplitPaneDivider.this.getRightOneTouchIcon() : DarkSplitPaneDivider.this.getBottomOneTouchIcon();
            }
            return EmptyIcon.create((int)0);
        }
    }

    protected static class OneTouchButton
    extends JButton
    implements UIResource {
        protected OneTouchButton() {
            this.putClientProperty("JButton.variant", "onlyLabel");
            this.setMinimumSize(new Dimension(6, 6));
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setRequestFocusEnabled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public Icon getPressedIcon() {
            return this.getIcon();
        }

        @Override
        public Icon getDisabledIcon() {
            return this.getIcon();
        }
    }
}

