/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.rootpane;

import com.github.weisj.darklaf.platform.DecorationsHandler;
import com.github.weisj.darklaf.platform.decorations.CustomTitlePane;
import com.github.weisj.darklaf.ui.rootpane.DarkSubstanceRootLayout;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class DarkRootPaneUI
extends BasicRootPaneUI
implements HierarchyListener {
    protected static final String KEY_PREFIX = "JRootPane.";
    public static final String KEY_NO_DECORATIONS_UPDATE = "JRootPane.noDecorationsUpdate";
    public static final String KEY_NO_DECORATIONS = "JRootPane.noDecorations";
    protected static final String[] borderKeys = new String[]{"RootPane.border", "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private Window window;
    private CustomTitlePane titlePane;
    private LayoutManager layoutManager;
    private LayoutManager oldLayout;
    private JRootPane rootPane;
    private int windowDecorationsStyle = -1;

    public static ComponentUI createUI(JComponent comp) {
        return new DarkRootPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.rootPane = (JRootPane)c;
        this.windowDecorationsStyle = this.rootPane.getWindowDecorationStyle();
        LookAndFeel.installColors(this.rootPane, "RootPane.background", "RootPane.foreground");
        this.updateClientDecoration();
        this.installBorder(this.rootPane);
    }

    protected void installBorder(JRootPane root) {
        if (root == null) {
            return;
        }
        LookAndFeel.installBorder(root, borderKeys[this.windowDecorationsStyle]);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.rootPane);
        DarkRootPaneUI.uninstallBorder(this.rootPane);
        this.layoutManager = null;
        this.rootPane = null;
    }

    private static void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if ("ancestor".equals(propertyName)) {
            this.updateWindow(this.rootPane.getParent());
        }
    }

    protected int decorationsStyleFromWindow(Window window, int windowDecorationsStyle) {
        if (windowDecorationsStyle != 0) {
            return windowDecorationsStyle;
        }
        if (DarkUIUtil.isUndecorated(window)) {
            return 0;
        }
        if (window instanceof JFrame) {
            return 1;
        }
        if (window instanceof JDialog) {
            return 2;
        }
        return windowDecorationsStyle;
    }

    private void uninstallClientDecorations(JRootPane root) {
        if (root != null) {
            DarkRootPaneUI.uninstallBorder(root);
            root.removeHierarchyListener(this);
            if (this.titlePane != null) {
                this.titlePane.uninstall();
                this.setTitlePane(root, null);
            }
            this.uninstallLayout(root);
            int style = root.getWindowDecorationStyle();
            if (style == 0) {
                root.repaint();
                root.revalidate();
            }
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private void uninstallLayout(JRootPane root) {
        if (this.oldLayout != null) {
            root.setLayout(this.oldLayout);
            this.oldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        this.updateWindow(this.rootPane.getParent());
        int style = this.decorationsStyleFromWindow(this.window, this.windowDecorationsStyle < 0 ? root.getWindowDecorationStyle() : this.windowDecorationsStyle);
        CustomTitlePane titlePane = DecorationsHandler.getSharedInstance().createTitlePane(root, style, this.window);
        this.installLayout(root);
        this.setTitlePane(root, titlePane);
        if (titlePane != null) {
            titlePane.setDecorationsStyle(this.windowDecorationsStyle);
        }
        root.addHierarchyListener(this);
    }

    private void setTitlePane(JRootPane root, CustomTitlePane titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        CustomTitlePane oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            layeredPane.remove((Component)oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    private void updateWindow(Component parent) {
        this.window = DarkUIUtil.getWindow(parent);
        this.windowDecorationsStyle = this.decorationsStyleFromWindow(this.window, this.windowDecorationsStyle);
        this.installBorder(this.rootPane);
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.oldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    protected CustomTitlePane getTitlePane() {
        return this.titlePane;
    }

    protected LayoutManager createLayoutManager() {
        return new DarkSubstanceRootLayout();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (this.rootPane == null) {
            return;
        }
        Container parent = this.rootPane.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getClass().getName().startsWith("org.jdesktop.jdic.tray") || parent.getClass().getName().equals("javax.swing.Popup$HeavyWeightWindow")) {
            SwingUtilities.invokeLater(() -> {
                if (this.rootPane != null) {
                    this.rootPane.removeHierarchyListener(this);
                }
            });
        }
        if (e.getChangeFlags() == 1L && DarkUIUtil.getWindow(this.rootPane) != this.window) {
            this.updateClientDecoration();
        }
    }

    protected void updateClientDecoration() {
        if (!PropertyUtil.getBooleanProperty((JComponent)this.rootPane, (String)KEY_NO_DECORATIONS_UPDATE)) {
            this.uninstallClientDecorations(this.rootPane);
            if (DecorationsHandler.getSharedInstance().isCustomDecorationSupported()) {
                this.installClientDecorations(this.rootPane);
            }
        }
    }
}

