/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.label;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import sun.swing.SwingUtilities2;

public class DarkLabelUI
extends BasicLabelUI
implements PropertyChangeListener {
    protected static final DarkLabelUI darkLabelUI = new DarkLabelUI();
    private Color inactiveForeground;
    private Color cellForegroundNoFocus;
    private Color cellInactiveForeground;
    private Color cellInactiveForegroundSelectedNoFocus;
    private Color cellInactiveForegroundSelected;
    protected final Rectangle paintIconR = new Rectangle();
    protected final Rectangle paintTextR = new Rectangle();

    public DarkLabelUI() {
        this.installUI(null);
    }

    public static ComponentUI createUI(JComponent c) {
        return darkLabelUI;
    }

    @Override
    public void installUI(JComponent c) {
        if (c != null) {
            super.installUI(c);
        }
    }

    @Override
    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        LookAndFeel.installProperty(c, "opaque", false);
        this.inactiveForeground = UIManager.getColor("Label.inactiveForeground");
        this.cellForegroundNoFocus = UIManager.getColor("Label.cellForegroundNoFocus");
        this.cellInactiveForeground = UIManager.getColor("Label.cellInactiveForeground");
        this.cellInactiveForegroundSelected = UIManager.getColor("Label.cellInactiveForegroundSelected");
        this.cellInactiveForegroundSelectedNoFocus = UIManager.getColor("Label.cellInactiveForegroundSelectedNoFocus");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GraphicsContext config = new GraphicsContext(g);
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon = this.getIcon(label);
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)label, g);
        String clippedText = this.layout(label, fm, c.getWidth(), c.getHeight());
        if (icon != null) {
            icon.paintIcon(c, g, this.paintIconR.x, this.paintIconR.y);
            config.restoreClip();
        }
        PaintUtil.drawString(g, c, clippedText, this.paintTextR, fm, (g2, c2, rect, t) -> {
            if (label.isEnabled()) {
                this.paintEnabledText(label, g2, t, rect.x, rect.y);
            } else {
                this.paintDisabledText(label, g2, t, rect.x, rect.y);
            }
        });
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = l.getDisplayedMnemonicIndex();
        if (DarkUIUtil.isInCell(l) && !this.hasFocusInCell(l)) {
            g.setColor(this.cellForegroundNoFocus);
        } else {
            g.setColor(l.getForeground());
        }
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY);
    }

    protected boolean hasFocusInCell(JLabel l) {
        return DarkUIUtil.hasFocus(l) || DarkUIUtil.hasFocus(DarkUIUtil.getParentOfType(JTree.class, l)) || DarkUIUtil.hasFocus(DarkUIUtil.getParentOfType(JTable.class, l)) || DarkUIUtil.hasFocus(DarkUIUtil.getParentOfType(JList.class, l)) || DarkUIUtil.getParentOfType(JPopupMenu.class, l) != null;
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonicIndex();
        if (DarkUIUtil.isInCell(l)) {
            boolean selected = PropertyUtil.getBooleanProperty((JComponent)l, (String)"JComponent.selectedCellRenderer");
            boolean focused = this.hasFocusInCell(l);
            if (focused) {
                if (selected) {
                    g.setColor(this.cellInactiveForegroundSelected);
                } else {
                    g.setColor(this.cellInactiveForeground);
                }
            } else if (selected) {
                g.setColor(this.cellInactiveForegroundSelectedNoFocus);
            } else {
                g.setColor(this.inactiveForeground);
            }
        } else {
            g.setColor(this.inactiveForeground);
        }
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, accChar, textX, textY);
    }

    protected Icon getIcon(JLabel label) {
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        return icon;
    }

    protected String layout(JLabel label, FontMetrics fm, int width, int height) {
        Insets insets = label.getInsets(null);
        String text = label.getText();
        Icon icon = this.getIcon(label);
        Rectangle paintViewR = new Rectangle();
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = width - (insets.left + insets.right);
        paintViewR.height = height - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return this.layoutCL(label, fm, text, icon, paintViewR, this.paintIconR, this.paintTextR);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source;
        super.propertyChange(e);
        String key = e.getPropertyName();
        if ("componentOrientation".equals(key) && (source = e.getSource()) instanceof JLabel) {
            ((JLabel)source).doLayout();
            ((JLabel)source).repaint();
        }
    }
}

