/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.cell;

import com.github.weisj.darklaf.ui.list.DarkListUI;
import com.github.weisj.darklaf.ui.table.DarkTableCellEditor;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ListUI;

public class CellUtil {
    public static final String KEY_SELECTED_CELL_RENDERER = "JComponent.selectedCellRenderer";

    public static void setupForeground(Component comp, JComponent parent, boolean selected, String activeKey, String inactiveKey) {
        CellUtil.setupForeground(comp, parent, selected, UIManager.getColor(activeKey), inactiveKey);
    }

    public static void setupForeground(Component comp, JTable parent, boolean selected, String inactiveKey) {
        CellUtil.setupForeground(comp, (JComponent)parent, selected, parent.getSelectionForeground(), inactiveKey);
    }

    public static void setupForeground(Component comp, JComponent parent, boolean selected, Color activeColor, String inactiveKey) {
        if (selected) {
            if (DarkUIUtil.hasFocus(parent)) {
                comp.setForeground(activeColor);
            } else {
                comp.setForeground(UIManager.getColor(inactiveKey));
            }
        } else {
            comp.setForeground(parent.getForeground());
        }
        CellUtil.setSelectedFlag(comp, selected);
    }

    public static void setSelectedFlag(Component comp, boolean selected) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).putClientProperty(KEY_SELECTED_CELL_RENDERER, selected);
        }
    }

    public static void setupBackground(Component comp, JTable parent, boolean selected, int row, String altBgKey, String altColorKey, String noFocusSelectionBgKey) {
        CellUtil.setupBackground(comp, parent, selected, row, altBgKey, parent.getBackground(), altColorKey, parent.getSelectionBackground(), noFocusSelectionBgKey);
    }

    public static void setupBackground(Component comp, JTable parent, boolean selected, int row, String altBgKey, String colorKey, String altColorKey, String noFocusSelectionBgKey) {
        CellUtil.setupBackground(comp, parent, selected, row, altBgKey, UIManager.getColor(colorKey), altColorKey, parent.getSelectionBackground(), noFocusSelectionBgKey);
    }

    public static void setupBackground(Component comp, JList<?> parent, boolean selected, int index, String altBgKey, String altColorKey, String noFocusSelectionBgKey) {
        int layout = parent.getLayoutOrientation();
        boolean altRow = false;
        if (layout == 0) {
            altRow = index % 2 == 1;
        } else if (layout == 1 || layout == 2) {
            int row;
            ListUI ui = parent.getUI();
            altRow = ui instanceof DarkListUI ? (row = ((DarkListUI)ui).convertModelToRow(index)) % 2 == 1 : false;
        }
        CellUtil.setupBackground(comp, parent, selected, altRow ? 1 : 0, altBgKey, parent.getBackground(), altColorKey, parent.getSelectionBackground(), noFocusSelectionBgKey);
    }

    protected static void setupBackground(Component comp, JComponent parent, boolean selected, int row, String altBgKey, Color bgColor, String altColorKey, Color selectionBackground, String noFocusSelectionBgKey) {
        Color background;
        boolean alternativeRow = PropertyUtil.getBooleanProperty((JComponent)parent, (String)altBgKey);
        Color alternativeRowColor = UIManager.getColor(altColorKey);
        Color color = background = alternativeRow && row % 2 == 1 ? alternativeRowColor : bgColor;
        if (selected) {
            if (DarkUIUtil.hasFocus(parent)) {
                comp.setBackground(selectionBackground);
            } else {
                comp.setBackground(UIManager.getColor(noFocusSelectionBgKey));
            }
        } else {
            comp.setBackground(background);
        }
    }

    public static void paintTableEditorBorder(Graphics g, Component c, JTable table, int width, int height) {
        int row = table.getEditingRow();
        int col = table.getEditingColumn();
        if (!table.getShowHorizontalLines()) {
            if (row > CellUtil.getMinRowIndex(table)) {
                g.fillRect(0, 0, width, 1);
            }
            g.fillRect(0, height - 1, width, 1);
        }
        if (!table.getShowVerticalLines()) {
            if (col > CellUtil.getMinColumnIndex(table)) {
                g.fillRect(0, 0, 1, height);
            }
            if (col < CellUtil.getMaxColumnIndex(table)) {
                g.fillRect(width - 1, 0, 1, height);
            }
        } else if (CellUtil.isInWrapper(c)) {
            if (table.getComponentOrientation().isLeftToRight()) {
                g.fillRect(0, 0, 1, height);
            } else {
                g.fillRect(width - 1, 0, 1, height);
            }
        }
    }

    protected static boolean isInWrapper(Component c) {
        return c.getParent() instanceof DarkTableCellEditor.IconWrapper;
    }

    protected static boolean isListEditor(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)"JComponent.listCellEditor") && c.getParent() instanceof JList;
    }

    public static Insets adjustEditorInsets(Insets ins, Component c) {
        ListCellRenderer renderer;
        if (CellUtil.isInWrapper(c)) {
            if (CellUtil.parentLTR(c)) {
                ins.left -= ((DarkTableCellEditor.IconWrapper)c.getParent()).getIconCompGap();
            } else {
                ins.right -= ((DarkTableCellEditor.IconWrapper)c.getParent()).getIconCompGap();
            }
        } else if (CellUtil.isListEditor(c) && (renderer = ((JList)c.getParent()).getCellRenderer()) instanceof JLabel) {
            if (CellUtil.parentLTR(c)) {
                ins.left -= ((JLabel)((Object)renderer)).getIconTextGap() - 1;
            } else {
                ins.right -= ((JLabel)((Object)renderer)).getIconTextGap() - 1;
            }
        }
        return CellUtil.adjustTableCellEditorInsets(ins, DarkUIUtil.getParentOfType(JTable.class, c));
    }

    public static Insets adjustTableCellEditorInsets(Insets ins, JTable table) {
        if (table != null && !table.getShowVerticalLines()) {
            int cMin = CellUtil.getMinColumnIndex(table);
            int column = table.getEditingColumn();
            if (column > cMin) {
                ++ins.left;
            }
        }
        return ins;
    }

    protected static boolean parentLTR(Component c) {
        return c.getParent().getComponentOrientation().isLeftToRight();
    }

    public static int getMinColumnIndex(JTable table) {
        Rectangle rect = table.getVisibleRect();
        return table.columnAtPoint(rect.getLocation());
    }

    public static int getMaxColumnIndex(JTable table) {
        Rectangle rect = table.getVisibleRect();
        Point p = rect.getLocation();
        p.x += rect.width - 1;
        return table.columnAtPoint(p);
    }

    public static int getMinRowIndex(JTable table) {
        Rectangle rect = table.getVisibleRect();
        return table.rowAtPoint(rect.getLocation());
    }
}

