/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.listener;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class HoverListener
implements MouseListener {
    private final JComponent component;
    private boolean hover = false;
    private boolean scheduled = false;

    public HoverListener(JComponent component) {
        this.component = component;
    }

    public boolean isHover() {
        return this.hover;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.hover) {
            this.hover = true;
            this.scheduleRepaint();
        }
    }

    private void scheduleRepaint() {
        if (!this.scheduled) {
            this.scheduled = true;
            SwingUtilities.invokeLater(() -> {
                this.component.invalidate();
                this.component.repaint();
                this.scheduled = false;
            });
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hover) {
            this.hover = false;
            this.scheduleRepaint();
        }
    }
}

