/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.util.Scale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public final class ImageUtil {
    private static final int FRAME_ICON_SIZE = 32;

    private ImageUtil() {
    }

    public static Image createFrameIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        double scaleX = Scale.SCALE_X * (32.0 / (double)w);
        double scaleY = Scale.SCALE_Y * (32.0 / (double)h);
        return ImageUtil.createScaledImage(icon, scaleX, scaleY);
    }

    public static Image createScaledImage(Icon icon, double scalex, double scaley) {
        if (icon == null) {
            return null;
        }
        int w = (int)(scalex * (double)icon.getIconWidth());
        int h = (int)(scaley * (double)icon.getIconHeight());
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.scale(scalex, scaley);
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static Image createDragImage(Component c, int lw, Color borderColor) {
        return ImageUtil.createDragImage(c, new Rectangle(0, 0, c.getWidth(), c.getHeight()), lw, borderColor);
    }

    public static Image createDragImage(Component c, Rectangle bounds, int lw, Color borderColor) {
        BufferedImage tabImage = ImageUtil.scaledImageFromComponent(c, bounds);
        int w = ((Image)tabImage).getWidth(null);
        int h = ((Image)tabImage).getHeight(null);
        Graphics g = ((Image)tabImage).getGraphics();
        g.setColor(borderColor);
        PaintUtil.drawRect(g, 0, 0, w, h, lw);
        g.dispose();
        return tabImage;
    }

    public static BufferedImage imageFromComponent(Component c, Rectangle bounds) {
        return ImageUtil.scaledImageFromComponent(c, bounds, 1.0, 1.0, true);
    }

    public static BufferedImage imageFromComponent(Component c, Rectangle bounds, boolean print) {
        return ImageUtil.scaledImageFromComponent(c, bounds, 1.0, 1.0, print);
    }

    public static BufferedImage scaledImageFromComponent(Component c, Rectangle bounds) {
        return ImageUtil.scaledImageFromComponent(c, bounds, Scale.SCALE_X, Scale.SCALE_Y, true);
    }

    public static BufferedImage scaledImageFromComponent(Component c, Rectangle bounds, double scalex, double scaley, boolean print) {
        boolean scale = scalex != 1.0 || scaley != 1.0;
        BufferedImage image = scale ? new BufferedImage((int)(scalex * (double)bounds.width), (int)(scaley * (double)bounds.height), 1) : new BufferedImage(bounds.width, bounds.height, 1);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        if (scale) {
            g2d.scale(scalex, scaley);
        }
        g2d.translate(-bounds.x, -bounds.y);
        if (print) {
            c.printAll(g2d);
        } else {
            c.paintAll(g2d);
        }
        g2d.dispose();
        return image;
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return ImageUtil.isHeadless() ? new BufferedImage(width, height, 2) : ImageUtil.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }
}

