/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.loading;

import com.github.weisj.darklaf.components.RotatableIconAnimator;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.icons.RotatableIcon;
import com.github.weisj.darklaf.icons.TwoIcon;
import com.github.weisj.darklaf.util.DarkUIUtil;
import javax.swing.Icon;
import javax.swing.JLabel;

public class LoadingIndicator
extends JLabel {
    private final RotatableIcon loadIcon = new RotatableIcon(DarkUIUtil.ICON_LOADER.getIcon("progress/step_working.svg"));
    private final Icon pausedIcon = DarkUIUtil.ICON_LOADER.getIcon("progress/step_passive.svg");
    private final Icon emptyIcon = EmptyIcon.create((int)this.loadIcon.getIconWidth(), (int)this.loadIcon.getIconHeight());
    private final TwoIcon displayIcon = new TwoIcon((Icon)this.loadIcon, null);
    private final RotatableIconAnimator animator = new RotatableIconAnimator(8, this.loadIcon, this);
    private boolean running;

    public LoadingIndicator(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.displayIcon.setIconGap(this.getIconTextGap());
    }

    public LoadingIndicator(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public LoadingIndicator(String text) {
        this(text, null, 10);
    }

    public LoadingIndicator(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public LoadingIndicator(Icon image) {
        this(null, image, 0);
    }

    public LoadingIndicator() {
        this("", null, 10);
    }

    public void setRunning(boolean running) {
        this.running = running;
        this.setAnimatorState(running);
    }

    private void setAnimatorState(boolean running) {
        if (running == this.animator.isRunning()) {
            return;
        }
        if (running) {
            this.animator.resume();
        } else {
            this.animator.suspend();
        }
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setAnimatorState(this.isRunning());
    }

    public boolean isRunning() {
        return this.running && this.isEnabled();
    }

    @Override
    public void setIconTextGap(int iconTextGap) {
        super.setIconTextGap(iconTextGap);
        this.displayIcon.setIconGap(this.getIconTextGap());
    }

    @Override
    public Icon getIcon() {
        this.displayIcon.setLeftIcon((Icon)(this.running ? this.loadIcon : this.pausedIcon));
        this.displayIcon.setRightIcon(super.getIcon());
        return this.displayIcon;
    }

    @Override
    public Icon getDisabledIcon() {
        this.displayIcon.setLeftIcon(this.emptyIcon);
        this.displayIcon.setRightIcon(super.getDisabledIcon());
        return this.displayIcon;
    }
}

