/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.color;

import com.github.weisj.darklaf.components.color.SmallColorChooser;
import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.ui.tooltip.DarkTooltipBorder;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class PopupColorChooser
extends JToolTip {
    protected DarkTooltipBorder border;
    protected static SmallColorChooser chooser;
    protected static ToolTipContext context;

    protected SmallColorChooser getChooser(Color initial, Consumer<Color> callback) {
        if (chooser == null) {
            chooser = new SmallColorChooser(initial, callback);
        }
        SmallColorChooser smallColorChooser = chooser;
        if (chooser.getParent() != null) {
            smallColorChooser = new SmallColorChooser(initial, callback);
        }
        smallColorChooser.reset(initial, callback);
        smallColorChooser.setOpaque(false);
        return smallColorChooser;
    }

    protected ToolTipContext getContext() {
        if (context == null) {
            context = this.createToolTipContext();
        }
        return context;
    }

    public PopupColorChooser(JComponent parent, Color initial, Consumer<Color> callback) {
        this.setComponent(parent);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getChooser(initial, callback), "Center");
    }

    @Override
    public void updateUI() {
        this.putClientProperty("JPopupFactory.focusablePopup", true);
        this.putClientProperty("JToolTip.toolTipContext", this.getContext());
        super.updateUI();
    }

    public static void showColorChooser(JComponent parent, Color initial, Consumer<Color> callback, Consumer<AWTEvent> onClose) {
        PopupColorChooser toolTip = new PopupColorChooser(parent, initial, callback);
        Popup popup = PopupFactory.getSharedInstance().getPopup(parent, toolTip, 0, 0);
        popup.show();
        Window window = DarkUIUtil.getWindow(parent);
        final AtomicReference<Consumer<AWTEvent>> close = new AtomicReference<Consumer<AWTEvent>>();
        ComponentAdapter windowListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                ((Consumer)close.get()).accept(e);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ((Consumer)close.get()).accept(e);
            }
        };
        AWTEventListener listener = event -> {
            boolean doClose;
            int id;
            if (event instanceof MouseEvent && (id = event.getID()) != 500 && id != 501) {
                return;
            }
            boolean bl = doClose = event instanceof FocusEvent && !DarkUIUtil.hasFocus(toolTip, (FocusEvent)event) && !DarkUIUtil.hasFocus(toolTip) && !DarkUIUtil.hasFocus(parent, (FocusEvent)event);
            if (!doClose) {
                Point p = MouseInfo.getPointerInfo().getLocation();
                Point p2 = new Point(p);
                Point p3 = new Point(p);
                SwingUtilities.convertPointFromScreen(p2, parent);
                SwingUtilities.convertPointFromScreen(p3, toolTip);
                boolean bl2 = doClose = !parent.contains(p2) && !toolTip.contains(p3);
            }
            if (doClose) {
                ((Consumer)close.get()).accept(event);
            }
        };
        close.set(e -> {
            popup.hide();
            Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            if (window != null) {
                window.removeComponentListener(windowListener);
            }
            if (onClose != null) {
                onClose.accept((AWTEvent)e);
            }
        });
        SwingUtilities.invokeLater(() -> {
            window.addComponentListener(windowListener);
            Toolkit.getDefaultToolkit().addAWTEventListener(listener, 20L);
        });
    }

    protected ToolTipContext createToolTipContext() {
        return new ToolTipContext().setAlignment(Alignment.CENTER).setCenterAlignment(Alignment.SOUTH).setUseBestFit(true).setToolTipInsets(new Insets(2, 2, 2, 2)).setFallBackPositionProvider(c -> {
            Window window = DarkUIUtil.getWindow(c.getTarget());
            Dimension size = c.getToolTip().getPreferredSize();
            Rectangle bounds = window.getBounds();
            return new Point(bounds.x + (bounds.width - size.width) / 2, bounds.y + (bounds.height - size.height) / 2);
        });
    }

    @Override
    public String getTipText() {
        return "";
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.getLayout() != null) {
            return this.getLayout().preferredLayoutSize(this);
        }
        return super.getPreferredSize();
    }
}

