/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.border.MutableLineBorder;
import com.github.weisj.darklaf.theme.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.function.Function;
import javax.swing.UIManager;

public class DarkLineBorder
extends MutableLineBorder {
    private final String key;
    private final Function<Color, Color> fallbackSupplier;
    protected Theme currentTheme;

    public DarkLineBorder(int top, int left, int bottom, int right, String key, Function<Color, Color> fallbackSupplier) {
        super(top, left, bottom, right, null);
        this.key = key;
        this.fallbackSupplier = fallbackSupplier;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.getColor(c));
        g.fillRect(x, y, width - this.right, this.top);
        g.fillRect(x, y + this.top, this.left, height - this.top);
        g.fillRect(x + this.left, y + height - this.bottom, width - this.left, this.bottom);
        g.fillRect(x + width - this.right, y, this.right, height - this.bottom);
    }

    protected Color getColor(Component c) {
        if (!(UIManager.getLookAndFeel() instanceof DarkLaf)) {
            this.currentTheme = null;
            Color bg = c.getBackground();
            return bg != null ? this.fallbackSupplier.apply(bg) : null;
        }
        Color color = this.getColor();
        if (color == null || this.currentTheme != LafManager.getTheme()) {
            this.currentTheme = LafManager.getTheme();
            color = UIManager.getColor(this.key);
            this.setColor(color);
        }
        return color;
    }
}

