/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;

public class ClosableTabComponent
extends JPanel {
    private JTabbedPane pane;

    public ClosableTabComponent(JTabbedPane pane) {
        super(new FlowLayout(0, 0, 0));
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null.");
        }
        this.pane = pane;
        this.setOpaque(false);
        this.add(new TabLabel(this));
        this.add(new TabButton(this));
    }

    public void setTabbedPane(JTabbedPane pane) {
        this.pane = pane;
    }

    protected static class TabButton
    extends JButton
    implements ActionListener {
        private final ClosableTabComponent tabComponent;

        protected TabButton(final ClosableTabComponent tabComponent) {
            this.tabComponent = tabComponent;
            this.putClientProperty("JButton.variant", "onlyLabel");
            this.putClientProperty("JButton.noBorderlessOverwrite", true);
            this.setOpaque(false);
            this.setRolloverEnabled(true);
            this.setIcon(UIManager.getIcon("TabbedPane.tabCloseIcon"));
            this.setRolloverIcon(UIManager.getIcon("TabbedPane.tabCloseHoverIcon"));
            this.addActionListener(this);
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    int i;
                    TabbedPaneUI ui = tabComponent.pane.getUI();
                    if (ui instanceof DarkTabbedPaneUI && (i = tabComponent.pane.indexOfTabComponent(tabComponent)) != -1) {
                        ((DarkTabbedPaneUI)ui).setRolloverTab(i);
                        tabComponent.pane.repaint();
                    }
                }
            };
            this.addMouseListener(mouseListener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = this.tabComponent.pane.indexOfTabComponent(this.tabComponent);
            if (i != -1) {
                this.tabComponent.pane.remove(i);
            }
        }
    }

    protected static class TabLabel
    extends JLabel {
        private final ClosableTabComponent tabComponent;

        protected TabLabel(ClosableTabComponent tabComponent) {
            this.tabComponent = tabComponent;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }

        @Override
        public String getText() {
            if (this.tabComponent == null) {
                return "";
            }
            int i = this.tabComponent.pane.indexOfTabComponent(this.tabComponent);
            if (i != -1) {
                return this.tabComponent.pane.getTitleAt(i);
            }
            return "";
        }
    }
}

