/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme.info;

import com.github.weisj.darklaf.theme.DarculaTheme;
import com.github.weisj.darklaf.theme.HighContrastDarkTheme;
import com.github.weisj.darklaf.theme.HighContrastLightTheme;
import com.github.weisj.darklaf.theme.IntelliJTheme;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.UnsupportedThemeException;
import com.github.weisj.darklaf.theme.info.ColorToneRule;
import com.github.weisj.darklaf.theme.info.ContrastRule;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.theme.info.ThemeProvider;

public class DefaultThemeProvider
implements ThemeProvider {
    private final Theme lightTheme;
    private final Theme darkTheme;
    private final Theme lightHighContrastTheme;
    private final Theme darkHighContrastTheme;

    public DefaultThemeProvider() {
        this(new IntelliJTheme(), new DarculaTheme(), new HighContrastLightTheme(), new HighContrastDarkTheme());
    }

    public DefaultThemeProvider(Theme lightTheme, Theme darkTheme, Theme lightHighContrastTheme, Theme darkHighContrastTheme) {
        if (Theme.isDark(lightTheme)) {
            throw new UnsupportedThemeException("Given light theme " + lightTheme + "is declared as dark");
        }
        if (Theme.isDark(lightHighContrastTheme)) {
            throw new UnsupportedThemeException("Given light high-contrast theme " + lightHighContrastTheme + " is declared as dark");
        }
        if (!Theme.isDark(darkTheme)) {
            throw new UnsupportedThemeException("Given dark theme " + darkTheme + "is not declared as dark");
        }
        if (!Theme.isDark(darkHighContrastTheme)) {
            throw new UnsupportedThemeException("Given dark high-contrast theme " + darkTheme + "is not declared as dark");
        }
        if (!Theme.isHighContrast(lightHighContrastTheme)) {
            throw new UnsupportedThemeException("Given light high-contrast theme " + lightHighContrastTheme + " is not declared as high-contrast");
        }
        if (!Theme.isHighContrast(darkHighContrastTheme)) {
            throw new UnsupportedThemeException("Given dark high-contrast theme " + darkHighContrastTheme + " is not declared as high-contrast");
        }
        this.lightTheme = lightTheme;
        this.darkTheme = darkTheme;
        this.lightHighContrastTheme = lightHighContrastTheme;
        this.darkHighContrastTheme = darkHighContrastTheme;
    }

    @Override
    public Theme getTheme(PreferredThemeStyle themeStyle) {
        boolean highContrast;
        if (themeStyle == null) {
            return this.lightTheme;
        }
        boolean dark = themeStyle.getColorToneRule() == ColorToneRule.DARK;
        boolean bl = highContrast = themeStyle.getContrastRule() == ContrastRule.HIGH_CONTRAST;
        Theme theme = dark ? (highContrast ? this.darkHighContrastTheme : this.darkTheme) : (highContrast ? this.lightHighContrastTheme : this.lightTheme);
        return theme.derive(themeStyle.getFontSizeRule(), themeStyle.getAccentColorRule());
    }
}

