/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jorphan.reflect.ClassFilter;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassFinder {
    private static final Logger log = LoggerFactory.getLogger(ClassFinder.class);
    private static final String DOT_JAR = ".jar";
    private static final String DOT_CLASS = ".class";
    private static final int DOT_CLASS_LEN = ".class".length();

    private ClassFinder() {
    }

    public static List<String> findClassesThatExtend(String[] paths, Class<?>[] superClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(paths, superClasses, false);
    }

    private static Set<File> addJarsInPath(String[] paths) {
        HashSet<File> fullList = new HashSet<File>();
        for (String path : paths) {
            File[] jars;
            File dir = new File(path);
            fullList.add(dir);
            if (!dir.exists() || !dir.isDirectory() || (jars = dir.listFiles(f -> f.isFile() && f.getName().endsWith(DOT_JAR))) == null) continue;
            Collections.addAll(fullList, jars);
        }
        return fullList;
    }

    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, null, null);
    }

    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses, String contains, String notContains) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, contains, notContains, false);
    }

    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, innerClasses, null, null, true);
    }

    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, false, null, null, true);
    }

    public static List<String> findClassesThatExtend(String[] searchPathsOrJars, Class<?>[] classNames, boolean innerClasses, String contains, String notContains, boolean annotations) throws IOException {
        ClassFilter filter;
        if (log.isDebugEnabled()) {
            log.debug("findClassesThatExtend with searchPathsOrJars : {}, superclass : {} innerClasses : {} annotations: {} contains: {}, notContains: {}", new Object[]{Arrays.toString(searchPathsOrJars), Arrays.toString(classNames), innerClasses, annotations, contains, notContains});
        }
        if (annotations) {
            Class<?>[] annoclassNames = classNames;
            filter = new AnnoClassFilter(annoclassNames, innerClasses);
        } else {
            filter = new ExtendsClassFilter(classNames, innerClasses, contains, notContains);
        }
        return ClassFinder.findClasses(searchPathsOrJars, filter);
    }

    public static List<String> findClasses(String[] searchPathsOrJars, ClassFilter filter) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("findClasses with searchPathsOrJars : {} and classFilter : {}", (Object)Arrays.toString(searchPathsOrJars), (Object)filter);
        }
        Set<File> strPathsOrJars = ClassFinder.addJarsInPath(searchPathsOrJars);
        TreeSet<String> listClasses = new TreeSet<String>();
        for (File path : strPathsOrJars) {
            ClassFinder.findClassesInOnePath(path, listClasses, filter);
        }
        if (log.isDebugEnabled()) {
            log.debug("listClasses.size()={}", (Object)listClasses.size());
            for (String clazz : listClasses) {
                log.debug("listClasses : {}", (Object)clazz);
            }
        }
        return new ArrayList<String>(listClasses);
    }

    private static String fixPathEntry(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(".")) {
            return System.getProperty("user.dir");
        }
        String resultPath = path;
        if (path.length() > 3 && path.matches("[a-z]:\\\\.*")) {
            resultPath = path.substring(0, 1).toUpperCase(Locale.ROOT) + path.substring(1);
        }
        resultPath = resultPath.trim().replace('\\', '/');
        resultPath = JOrphanUtils.substitute(resultPath, "//", "/");
        while (resultPath.endsWith("/")) {
            resultPath = resultPath.substring(0, resultPath.length() - 1);
        }
        return resultPath;
    }

    private static String fixClassName(String strClassName) {
        String fixedClassName = strClassName.replace('\\', '.');
        fixedClassName = fixedClassName.replace('/', '.');
        fixedClassName = fixedClassName.substring(0, fixedClassName.length() - DOT_CLASS_LEN);
        return fixedClassName;
    }

    private static void findClassesInOnePath(File file, Set<String> listClasses, ClassFilter filter) throws IOException {
        if (file.isDirectory()) {
            ClassFinder.findClassesInPathsDir(file.getAbsolutePath(), file, listClasses, filter);
        } else if (file.exists()) {
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String strEntry = entries.nextElement().toString();
                    if (!strEntry.endsWith(DOT_CLASS)) continue;
                    String fixedClassName = ClassFinder.fixClassName(strEntry);
                    ClassFinder.applyFiltering(listClasses, filter, fixedClassName);
                }
            }
            catch (IOException e) {
                log.warn("Can not open the jar {}, message: {}", new Object[]{file.getAbsolutePath(), e.getLocalizedMessage(), e});
            }
        }
    }

    private static void findClassesInPathsDir(String strPathElement, File dir, Set<String> listClasses, ClassFilter filter) throws IOException {
        File[] list = dir.listFiles();
        if (list == null) {
            log.warn("{} is not a folder", (Object)dir.getAbsolutePath());
            return;
        }
        for (File file : list) {
            if (file.isDirectory()) {
                ClassFinder.findClassesInPathsDir(strPathElement, file, listClasses, filter);
                continue;
            }
            if (!file.getPath().endsWith(DOT_CLASS) || !file.exists() || file.length() == 0L) continue;
            String path = file.getPath();
            String className = path.substring(strPathElement.length() + 1, path.lastIndexOf(46)).replace(File.separator.charAt(0), '.');
            ClassFinder.applyFiltering(listClasses, filter, className);
        }
    }

    private static void applyFiltering(Set<String> classesSet, ClassFilter filter, String className) {
        try {
            if (filter.accept(className)) {
                classesSet.add(className);
            }
        }
        catch (Throwable e) {
            log.error("Error filtering class {}, it will be ignored", (Object)className, (Object)e);
        }
    }

    private static class AnnoClassFilter
    implements ClassFilter {
        private final boolean inner;
        private final Class<? extends Annotation>[] annotations;
        private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        AnnoClassFilter(Class<? extends Annotation>[] annotations, boolean inner) {
            this.annotations = annotations;
            this.inner = inner;
        }

        @Override
        public boolean accept(String className) {
            if (!className.contains("$") || this.inner) {
                return this.hasAnnotationOnMethod(this.annotations, className, this.contextClassLoader);
            }
            return false;
        }

        private boolean hasAnnotationOnMethod(Class<? extends Annotation>[] annotations, String classInQuestion, ClassLoader contextClassLoader) {
            try {
                Class<?> c = Class.forName(classInQuestion, false, contextClassLoader);
                return Arrays.stream(c.getMethods()).anyMatch(method -> Arrays.stream(annotations).anyMatch(method::isAnnotationPresent));
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError | VerifyError ignored) {
                log.debug(ignored.getLocalizedMessage(), ignored);
                return false;
            }
        }

        public String toString() {
            return "AnnoClassFilter [inner=" + this.inner + ", annotations=" + (this.annotations != null ? Arrays.toString(this.annotations) : "null") + "]";
        }
    }

    private static class ExtendsClassFilter
    implements ClassFilter {
        private final Class<?>[] parents;
        private final boolean inner;
        private final String contains;
        private final String notContains;
        private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        ExtendsClassFilter(Class<?>[] parents, boolean inner, String contains, String notContains) {
            this.parents = parents;
            this.inner = inner;
            this.contains = contains;
            this.notContains = notContains;
        }

        @Override
        public boolean accept(String className) {
            if (this.contains != null && !className.contains(this.contains)) {
                return false;
            }
            if (this.notContains != null && className.contains(this.notContains)) {
                return false;
            }
            if (!className.contains("$") || this.inner) {
                return this.isChildOf(this.parents, className, this.contextClassLoader);
            }
            return false;
        }

        private boolean isChildOf(Class<?>[] parentClasses, String strClassName, ClassLoader contextClassLoader) {
            try {
                Class<?> targetClass = Class.forName(strClassName, false, contextClassLoader);
                if (!targetClass.isInterface() && !Modifier.isAbstract(targetClass.getModifiers())) {
                    return Arrays.stream(parentClasses).anyMatch(parent -> parent.isAssignableFrom(targetClass));
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError | VerifyError e) {
                log.debug(e.getLocalizedMessage(), e);
            }
            return false;
        }

        public String toString() {
            return "ExtendsClassFilter [parents=" + (this.parents != null ? Arrays.toString(this.parents) : "null") + ", inner=" + this.inner + ", contains=" + this.contains + ", notContains=" + this.notContains + "]";
        }
    }
}

