/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.theme.DarculaTheme;
import com.github.weisj.darklaf.theme.HighContrastDarkTheme;
import com.github.weisj.darklaf.theme.HighContrastLightTheme;
import com.github.weisj.darklaf.theme.IntelliJTheme;
import com.github.weisj.darklaf.theme.OneDarkTheme;
import com.github.weisj.darklaf.theme.SolarizedDarkTheme;
import com.github.weisj.darklaf.theme.SolarizedLightTheme;
import com.github.weisj.darklaf.theme.Theme;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.util.JMeterMenuBar;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookAndFeelCommand
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(LookAndFeelCommand.class);
    private static final String JMETER_LAF = "jmeter.laf";
    private static final Map<String, MenuItem> items = new LinkedHashMap<String, MenuItem>();
    private static final Preferences PREFS = Preferences.userNodeForPackage(LookAndFeelCommand.class);
    private static final String USER_PREFS_KEY = "laf.command";

    public static Collection<MenuItem> getMenuItems() {
        return Collections.unmodifiableCollection(items.values());
    }

    @Deprecated
    public static String getJMeterLaf() {
        String laf = PREFS.get(USER_PREFS_KEY, null);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        laf = JMeterUtils.getProperty("jmeter.laf." + osName.replace(' ', '_'));
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String[] osFamily = osName.split("\\s");
        laf = JMeterUtils.getProperty("jmeter.laf." + osFamily[0]);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        laf = JMeterUtils.getPropDefault(JMETER_LAF, "com.bulenkov.darcula.DarculaLaf");
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static String getPreferredLafCommand() {
        String laf = PREFS.get(USER_PREFS_KEY, null);
        if (laf != null) {
            return laf;
        }
        String jMeterLaf = LookAndFeelCommand.getJMeterLaf();
        if (jMeterLaf.equals("com.bulenkov.darcula.DarculaLaf")) {
            return MenuItem.ofDarklafTheme(DarculaTheme.class).command;
        }
        return MenuItem.of((String)"default", (String)jMeterLaf).command;
    }

    private static String checkLafName(String laf) {
        if ("System".equalsIgnoreCase(laf)) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        if ("CrossPlatform".equalsIgnoreCase(laf)) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        return laf;
    }

    public static boolean isDark() {
        String lookAndFeelID = UIManager.getLookAndFeel().getID();
        if (lookAndFeelID.equals("Darklaf")) {
            Theme lafTheme = LafManager.getTheme();
            if (lafTheme == null) {
                return false;
            }
            String name = lafTheme.getName();
            return name.equals("darcula") || name.equals("solarized_dark");
        }
        return false;
    }

    public static void activateLookAndFeel(String command) {
        MenuItem item = items.get(command);
        String className = item.lafClassName;
        try {
            GuiPackage instance;
            if (item.lafTheme != null) {
                LafManager.setTheme((Theme)item.lafTheme.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            if ((instance = GuiPackage.getInstance()) != null) {
                instance.updateUIForHiddenComponents();
            }
            JFactory.refreshUI((String)className);
            PREFS.put(USER_PREFS_KEY, item.command);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Look and Feel unavailable:" + e.toString(), e);
        }
        catch (InvocationTargetException e) {
            Throwable c = e.getCause();
            throw new IllegalArgumentException("Look and Feel unavailable:" + c.toString(), c);
        }
    }

    @Override
    public void doAction(ActionEvent ev) {
        try {
            LookAndFeelCommand.activateLookAndFeel(ev.getActionCommand());
        }
        catch (IllegalArgumentException e) {
            JMeterUtils.reportErrorToUser(e.getMessage(), e);
        }
    }

    @Override
    public Set<String> getActionNames() {
        return Collections.unmodifiableSet(items.keySet());
    }

    static {
        if (System.getProperty("darklaf.decorations") == null) {
            System.setProperty("darklaf.decorations", "false");
        }
        if (System.getProperty("darklaf.allowNativeCode") == null) {
            System.setProperty("darklaf.allowNativeCode", "false");
        }
        UIManager.installLookAndFeel("Darklaf", "com.github.weisj.darklaf.DarkLaf");
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (UIManager.LookAndFeelInfo laf : JMeterMenuBar.getAllLAFs()) {
            if (!laf.getClassName().equals("com.github.weisj.darklaf.DarkLaf")) {
                items.add(MenuItem.of(laf.getName(), laf.getClassName()));
                continue;
            }
            items.add(MenuItem.ofDarklafTheme(DarculaTheme.class));
            items.add(MenuItem.ofDarklafTheme(IntelliJTheme.class));
            items.add(MenuItem.ofDarklafTheme(OneDarkTheme.class));
            items.add(MenuItem.ofDarklafTheme(SolarizedDarkTheme.class));
            items.add(MenuItem.ofDarklafTheme(SolarizedLightTheme.class));
            items.add(MenuItem.ofDarklafTheme(HighContrastDarkTheme.class));
            items.add(MenuItem.ofDarklafTheme(HighContrastLightTheme.class));
        }
        items.sort(Comparator.comparing(MenuItem::getTitle));
        for (MenuItem item : items) {
            LookAndFeelCommand.items.put(item.command, item);
        }
    }

    public static class MenuItem {
        final String title;
        final String command;
        final String lafClassName;
        final Class<? extends Theme> lafTheme;

        private MenuItem(String title, String command, String lafClassName, Class<? extends Theme> lafTheme) {
            this.title = title;
            this.command = command;
            this.lafClassName = lafClassName;
            this.lafTheme = lafTheme;
        }

        public String getTitle() {
            return this.title;
        }

        public String getCommand() {
            return this.command;
        }

        private static MenuItem of(String title, String lafClass) {
            return new MenuItem(title, "laf:" + lafClass, lafClass, null);
        }

        private static MenuItem ofDarklafTheme(Class<? extends Theme> lafTheme) {
            return new MenuItem("Darklaf - " + lafTheme.getSimpleName().replace("Theme", ""), "com.github.weisj.darklaf.DarkLaf:" + lafTheme.getName(), "com.github.weisj.darklaf.DarkLaf", lafTheme);
        }
    }
}

