/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.assertions.LogErrorHandler;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLAssertion
extends AbstractTestElement
implements Serializable,
Assertion,
ThreadListener {
    private static final Logger log = LoggerFactory.getLogger(XMLAssertion.class);
    private static final long serialVersionUID = 242L;
    private static final ThreadLocal<XMLReader> XML_READER = new ThreadLocal<XMLReader>(){

        @Override
        protected XMLReader initialValue() {
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                return reader;
            }
            catch (SAXException e) {
                log.error("Error initializing XMLReader in XMLAssertion", (Throwable)e);
                return null;
            }
        }
    };

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        String resultData = response.getResponseDataAsString();
        if (resultData.length() == 0) {
            return result.setResultForNull();
        }
        result.setFailure(false);
        XMLReader builder = XML_READER.get();
        if (builder != null) {
            try {
                builder.setErrorHandler(new LogErrorHandler());
                builder.parse(new InputSource(new StringReader(resultData)));
            }
            catch (IOException | SAXException e) {
                result.setError(true);
                result.setFailure(true);
                result.setFailureMessage(e.getMessage());
            }
        } else {
            result.setError(true);
            result.setFailureMessage("Cannot initialize XMLReader in element:" + this.getName() + ", check jmeter.log file");
        }
        return result;
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        XML_READER.remove();
    }
}

